/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.primitives.SignedBytes;
import com.google.common.primitives.UnsignedBytes;
import com.google.firebase.rules.v1.ListReleaseExecutablesRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ExistenceFilterUtils {
    static final int MURMUR128_MITZ_64_STRATEGY = 1;
    public static final Funnel<CharSequence> funnel = Funnels.stringFunnel(StandardCharsets.UTF_8);

    public static ListReleaseExecutablesRequest.ExistenceFilter toExistence(BloomFilter<CharSequence> bloom) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            bloom.writeTo(out);
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));
            byte strategy = din.readByte();
            Preconditions.checkArgument(strategy == 1);
            int numHashFunctions = UnsignedBytes.toInt(din.readByte());
            int dataLength = din.readInt();
            ListReleaseExecutablesRequest.ExistenceFilter.Builder filterBuilder = ListReleaseExecutablesRequest.ExistenceFilter.newBuilder().setHashes(numHashFunctions).setStrategy(ListReleaseExecutablesRequest.ExistenceFilter.HashStrategy.MURMUR128_MITZ_64);
            for (int i = 0; i < dataLength; ++i) {
                filterBuilder.addBits(din.readLong());
            }
            return filterBuilder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BloomFilter<CharSequence> toBloom(ListReleaseExecutablesRequest.ExistenceFilter filter) {
        Preconditions.checkArgument(filter.getStrategy() == ListReleaseExecutablesRequest.ExistenceFilter.HashStrategy.MURMUR128_MITZ_64);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeByte(SignedBytes.checkedCast(1L));
            dout.writeByte(UnsignedBytes.checkedCast(filter.getHashes()));
            dout.writeInt(filter.getBitsCount());
            for (int i = 0; i < filter.getBitsCount(); ++i) {
                dout.writeLong(filter.getBits(i));
            }
            return BloomFilter.readFrom(new ByteArrayInputStream(out.toByteArray()), funnel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

