/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionOrBuilder;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.ListExpression;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MapExpression;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Member;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.Permission;
import com.google.firebase.rules.runtime.v1.RulesetAstOrBuilder;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class FieldAccessVisitor {
    private static final ImmutableList<String> EMPTY_SET = ImmutableList.of();
    private static final Predicate<List<String>> MATCH_ALL = fieldAccess -> true;

    private FieldAccessVisitor() {
    }

    public static Set<List<String>> visitRuleset(RulesetAstOrBuilder rulesetAst) {
        return FieldAccessVisitor.visitRuleset(rulesetAst, MATCH_ALL);
    }

    public static Set<List<String>> visitRuleset(RulesetAstOrBuilder rulesetAst, Predicate<List<String>> fieldAccessFilter) {
        HashSet<List<String>> fieldAccesses = new HashSet<List<String>>();
        for (Function function : rulesetAst.getFunctionsList()) {
            fieldAccesses.addAll(FieldAccessVisitor.visitExpression(function.getBody(), fieldAccessFilter));
        }
        for (ServiceRule serviceRule : rulesetAst.getServiceRulesList()) {
            for (Function function : serviceRule.getFunctionsList()) {
                fieldAccesses.addAll(FieldAccessVisitor.visitExpression(function.getBody(), fieldAccessFilter));
            }
            for (MatchRule matchRule : serviceRule.getMatchRulesList()) {
                fieldAccesses.addAll(FieldAccessVisitor.visitMatchRule(matchRule, fieldAccessFilter));
            }
        }
        return fieldAccesses;
    }

    private static Set<List<String>> visitMatchRule(MatchRule matchRule, Predicate<List<String>> fieldAccessFilter) {
        HashSet<List<String>> fieldAccesses = new HashSet<List<String>>();
        for (Function function : matchRule.getFunctionsList()) {
            fieldAccesses.addAll(FieldAccessVisitor.visitExpression(function.getBody(), fieldAccessFilter));
        }
        for (Permission permission : matchRule.getPermissionsList()) {
            fieldAccesses.addAll(FieldAccessVisitor.visitExpression(permission.getAllow(), fieldAccessFilter));
        }
        for (MatchRule childRule : matchRule.getMatchRulesList()) {
            fieldAccesses.addAll(FieldAccessVisitor.visitMatchRule(childRule, fieldAccessFilter));
        }
        return fieldAccesses;
    }

    public static Set<List<String>> visitExpression(ExpressionOrBuilder expression) {
        return FieldAccessVisitor.visitExpression(expression, MATCH_ALL);
    }

    public static Set<List<String>> visitExpression(ExpressionOrBuilder expression, Predicate<List<String>> filter) {
        HashSet<List<String>> fieldAccesses = new HashSet<List<String>>();
        switch (expression.getExpressionCase()) {
            case MEMBER: {
                Member member = expression.getMember();
                List<String> memberAccess = FieldAccessVisitor.resolveFieldAccess(member);
                if (!memberAccess.isEmpty() && filter.test(memberAccess)) {
                    fieldAccesses.add(memberAccess);
                    break;
                }
                if (!member.hasOperand()) break;
                fieldAccesses.addAll(FieldAccessVisitor.visitExpression(member.getOperand(), filter));
                break;
            }
            case CALL: {
                CallExpression call = expression.getCall();
                List<String> indexAccess = FieldAccessVisitor.resolveFieldAccess(call);
                if (!indexAccess.isEmpty() && filter.test(indexAccess)) {
                    fieldAccesses.add(indexAccess);
                    break;
                }
                if (call.hasOperand()) {
                    fieldAccesses.addAll(FieldAccessVisitor.visitExpression(call.getOperand(), filter));
                }
                for (Expression arg : call.getArgumentsList()) {
                    fieldAccesses.addAll(FieldAccessVisitor.visitExpression(arg, filter));
                }
                break;
            }
            case MAP: {
                MapExpression map = expression.getMap();
                for (Expression key : map.getKeysList()) {
                    fieldAccesses.addAll(FieldAccessVisitor.visitExpression(key, filter));
                }
                for (Expression value : map.getValuesList()) {
                    fieldAccesses.addAll(FieldAccessVisitor.visitExpression(value, filter));
                }
                break;
            }
            case LIST: {
                ListExpression list = expression.getList();
                for (Expression elem : list.getExpressionsList()) {
                    fieldAccesses.addAll(FieldAccessVisitor.visitExpression(elem, filter));
                }
                break;
            }
            case PATH: {
                Path path = expression.getPath();
                for (Path.PathSegment segment : path.getSegmentsList()) {
                    switch (segment.getKindCase()) {
                        case EXPRESSION: {
                            fieldAccesses.addAll(FieldAccessVisitor.visitExpression(segment.getExpression(), filter));
                            break;
                        }
                    }
                }
                break;
            }
        }
        return fieldAccesses;
    }

    public static List<String> resolveFieldAccess(Expression expression) {
        switch (expression.getExpressionCase()) {
            case MEMBER: {
                return FieldAccessVisitor.resolveFieldAccess(expression.getMember());
            }
            case CALL: {
                return FieldAccessVisitor.resolveFieldAccess(expression.getCall());
            }
        }
        return EMPTY_SET;
    }

    private static List<String> resolveFieldAccess(Member member) {
        List<String> access = new ArrayList<String>();
        access.add(member.getId().getName());
        if (member.hasOperand()) {
            List<String> operand = FieldAccessVisitor.resolveFieldAccess(member.getOperand());
            if (operand.isEmpty()) {
                return EMPTY_SET;
            }
            operand.addAll(access);
            access = operand;
        }
        return access;
    }

    private static List<String> resolveFieldAccess(CallExpression call) {
        if (!call.getFunctionName().getName().equals(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName())) {
            return EMPTY_SET;
        }
        if (call.getArgumentsCount() != 1) {
            return EMPTY_SET;
        }
        String fieldName = FieldAccessVisitor.resolveLiteral(call.getArguments(0));
        if (fieldName == null) {
            return EMPTY_SET;
        }
        List<String> access = FieldAccessVisitor.resolveFieldAccess(call.getOperand());
        if (access.isEmpty()) {
            return EMPTY_SET;
        }
        access.add(fieldName);
        return access;
    }

    @Nullable
    private static String resolveLiteral(Expression expression) {
        if (expression.getExpressionCase() != Expression.ExpressionCase.LITERAL) {
            return null;
        }
        Literal literal = expression.getLiteral();
        if (literal.getKindCase() != Literal.KindCase.STRING_VALUE) {
            return null;
        }
        return literal.getStringValue();
    }
}

