/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.collect.ImmutableSet;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class KindCaseHelper {
    public static final ImmutableSet<ExpressionValue.KindCase> ORDERABLE_KIND_CASES = ImmutableSet.of(ExpressionValue.KindCase.TIMESTAMP_VALUE, ExpressionValue.KindCase.DURATION_VALUE, ExpressionValue.KindCase.FLOAT_VALUE, ExpressionValue.KindCase.INT_VALUE, ExpressionValue.KindCase.STRING_VALUE, ExpressionValue.KindCase.BYTES_VALUE, new ExpressionValue.KindCase[0]);
    public static final ImmutableSet<ExpressionValue.KindCase> COMPARABLE_KIND_CASES = ImmutableSet.of(ExpressionValue.KindCase.BOOL_VALUE, ExpressionValue.KindCase.DURATION_VALUE, ExpressionValue.KindCase.FLOAT_VALUE, ExpressionValue.KindCase.INT_VALUE, ExpressionValue.KindCase.LATLNG_VALUE, ExpressionValue.KindCase.MAP_VALUE, new ExpressionValue.KindCase[]{ExpressionValue.KindCase.NULL_VALUE, ExpressionValue.KindCase.STRING_VALUE, ExpressionValue.KindCase.BYTES_VALUE, ExpressionValue.KindCase.TIMESTAMP_VALUE, ExpressionValue.KindCase.PATH_VALUE, ExpressionValue.KindCase.LIST_VALUE});

    private KindCaseHelper() {
    }

    public static String kindToString(ExpressionValue.KindCase kindCase) {
        switch (kindCase) {
            case BOOL_VALUE: {
                return "bool";
            }
            case DURATION_VALUE: {
                return "duration";
            }
            case FLOAT_VALUE: {
                return "float";
            }
            case INT_VALUE: {
                return "int";
            }
            case LATLNG_VALUE: {
                return "latlng";
            }
            case LIST_VALUE: {
                return "list";
            }
            case MAP_VALUE: {
                return "map";
            }
            case NULL_VALUE: {
                return "null";
            }
            case STRING_VALUE: {
                return "string";
            }
            case BYTES_VALUE: {
                return "bytes";
            }
            case TIMESTAMP_VALUE: {
                return "timestamp";
            }
            case CONSTRAINT_VALUE: {
                return "constraint";
            }
            case PATH_VALUE: {
                return "path";
            }
            case UNDEFINED: {
                return "undefined";
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported 'kindCase': %s", kindCase.name()));
    }
}

