/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import java.util.Locale;

public class RestrictionException
extends EvaluationException {
    private RestrictionException(SourcePosition sourcePosition, String message) {
        super(sourcePosition, message);
    }

    public static RestrictionException makeMaximumExpressionsError(SourcePosition sourcePosition, int totalExpressions) {
        return new RestrictionException(sourcePosition, FirebaseRulesMessages.MAX_EVALUATION_COUNT_REACHED.get(Locale.ENGLISH).toString(Integer.toString(totalExpressions)));
    }

    public static RestrictionException makeMaximumStackSizeError(SourcePosition sourcePosition, int totalStackSize) {
        return new RestrictionException(sourcePosition, FirebaseRulesMessages.MAX_STACK_SIZE_REACHED.get(Locale.ENGLISH).toString(Integer.toString(totalStackSize)));
    }

    public static RestrictionException makeMaxEvaluationTimeReached(SourcePosition sourcePosition) {
        return new RestrictionException(sourcePosition, FirebaseRulesMessages.MAX_EVALUATION_TIME_REACHED.get(Locale.ENGLISH).toString());
    }
}

