/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.evaluators;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.eventflow.client.path.Path;
import com.google.firebase.rules.runtime.evaluators.EventRuleEvaluator;
import java.util.List;
import java.util.Optional;
import org.joda.time.ReadableInstant;

final class AutoValue_EventRuleEvaluator_EventRuleContext
extends EventRuleEvaluator.EventRuleContext {
    private final Path resource;
    private final ImmutableList<String> eventTypes;
    private final String eventId;
    private final Optional<ReadableInstant> timestamp;

    private AutoValue_EventRuleEvaluator_EventRuleContext(Path resource, ImmutableList<String> eventTypes, String eventId, Optional<ReadableInstant> timestamp) {
        this.resource = resource;
        this.eventTypes = eventTypes;
        this.eventId = eventId;
        this.timestamp = timestamp;
    }

    @Override
    public Path resource() {
        return this.resource;
    }

    @Override
    public ImmutableList<String> eventTypes() {
        return this.eventTypes;
    }

    @Override
    public String eventId() {
        return this.eventId;
    }

    @Override
    public Optional<ReadableInstant> timestamp() {
        return this.timestamp;
    }

    public String toString() {
        String string = String.valueOf(this.resource);
        String string2 = String.valueOf(this.eventTypes);
        String string3 = this.eventId;
        String string4 = String.valueOf(this.timestamp);
        return new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("EventRuleContext{resource=").append(string).append(", eventTypes=").append(string2).append(", eventId=").append(string3).append(", timestamp=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventRuleEvaluator.EventRuleContext) {
            EventRuleEvaluator.EventRuleContext that = (EventRuleEvaluator.EventRuleContext)o;
            return this.resource.equals(that.resource()) && this.eventTypes.equals(that.eventTypes()) && this.eventId.equals(that.eventId()) && this.timestamp.equals(that.timestamp());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.eventTypes.hashCode();
        h$ *= 1000003;
        h$ ^= this.eventId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.timestamp.hashCode();
    }

    @Override
    public EventRuleEvaluator.EventRuleContext.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EventRuleEvaluator.EventRuleContext.Builder {
        private Path resource;
        private ImmutableList.Builder<String> eventTypesBuilder$;
        private ImmutableList<String> eventTypes;
        private String eventId;
        private Optional<ReadableInstant> timestamp = Optional.empty();

        Builder() {
        }

        private Builder(EventRuleEvaluator.EventRuleContext source) {
            this.resource = source.resource();
            this.eventTypes = source.eventTypes();
            this.eventId = source.eventId();
            this.timestamp = source.timestamp();
        }

        @Override
        public EventRuleEvaluator.EventRuleContext.Builder setResource(Path resource) {
            if (resource == null) {
                throw new NullPointerException("Null resource");
            }
            this.resource = resource;
            return this;
        }

        @Override
        public EventRuleEvaluator.EventRuleContext.Builder setEventTypes(List<String> eventTypes) {
            if (this.eventTypesBuilder$ != null) {
                throw new IllegalStateException("Cannot set eventTypes after calling eventTypesBuilder()");
            }
            this.eventTypes = ImmutableList.copyOf(eventTypes);
            return this;
        }

        @Override
        ImmutableList.Builder<String> eventTypesBuilder() {
            if (this.eventTypesBuilder$ == null) {
                if (this.eventTypes == null) {
                    this.eventTypesBuilder$ = ImmutableList.builder();
                } else {
                    this.eventTypesBuilder$ = ImmutableList.builder();
                    this.eventTypesBuilder$.addAll(this.eventTypes);
                    this.eventTypes = null;
                }
            }
            return this.eventTypesBuilder$;
        }

        @Override
        public EventRuleEvaluator.EventRuleContext.Builder setEventId(String eventId) {
            if (eventId == null) {
                throw new NullPointerException("Null eventId");
            }
            this.eventId = eventId;
            return this;
        }

        @Override
        public EventRuleEvaluator.EventRuleContext.Builder setTimestamp(ReadableInstant timestamp) {
            this.timestamp = Optional.of(timestamp);
            return this;
        }

        @Override
        public EventRuleEvaluator.EventRuleContext build() {
            if (this.eventTypesBuilder$ != null) {
                this.eventTypes = this.eventTypesBuilder$.build();
            } else if (this.eventTypes == null) {
                this.eventTypes = ImmutableList.of();
            }
            String missing = "";
            if (this.resource == null) {
                missing = String.valueOf(missing).concat(" resource");
            }
            if (this.eventId == null) {
                missing = String.valueOf(missing).concat(" eventId");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_EventRuleEvaluator_EventRuleContext(this.resource, this.eventTypes, this.eventId, this.timestamp);
        }
    }
}

