/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.evaluators;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.firebase.eventflow.Flow;
import com.google.firebase.rules.eventflow.client.path.Path;
import com.google.firebase.rules.eventflow.client.path.PathMatcher;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_EventRuleContext;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_EventRuleEvaluatorRequest;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_EventRuleMatch;
import com.google.firebase.rules.runtime.evaluators.BaseEvaluatorRequest;
import com.google.firebase.rules.utils.ResourceNameUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.joda.time.ReadableInstant;

public interface EventRuleEvaluator {
    public List<EventRuleMatch> evaluate(EventRuleContext var1);

    public Multimap<EventRuleContext, EventRuleMatch> evaluate(List<EventRuleContext> var1);

    public String getRulesetName();

    public boolean hasNoFlows();

    @AutoValue
    public static abstract class EventRuleMatch {
        public abstract Flow flow();

        public abstract PathMatcher.PathMatch pathMatch();

        public static EventRuleMatch create(Flow flow, PathMatcher.PathMatch pathMatch) {
            return new AutoValue_EventRuleEvaluator_EventRuleMatch(flow, pathMatch);
        }
    }

    @AutoValue
    public static abstract class EventRuleContext {
        public abstract Path resource();

        public abstract ImmutableList<String> eventTypes();

        public abstract String eventId();

        public abstract Optional<ReadableInstant> timestamp();

        public static EventRuleContext create(Path resource, String eventType) {
            return EventRuleContext.builder().setResource(resource).addEventType(eventType).build();
        }

        public static Builder builder() {
            return new AutoValue_EventRuleEvaluator_EventRuleContext.Builder().setEventId(UUID.randomUUID().toString());
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            abstract ImmutableList.Builder<String> eventTypesBuilder();

            public Builder setResource(String resourcePath) {
                return this.setResource(resourcePath, Function.identity());
            }

            public Builder setResource(String resourcePath, Function<String, String> segmentDecoder) {
                return this.setResource(Path.parse((CharSequence)resourcePath, segmentDecoder));
            }

            public abstract Builder setResource(Path var1);

            public abstract Builder setEventTypes(List<String> var1);

            public Builder addEventType(String eventType) {
                this.eventTypesBuilder().add((Object)eventType);
                return this;
            }

            public abstract Builder setEventId(String var1);

            public abstract Builder setTimestamp(ReadableInstant var1);

            public abstract EventRuleContext build();
        }
    }

    @AutoValue
    public static abstract class EventRuleEvaluatorRequest
    extends BaseEvaluatorRequest {
        public abstract Function<String, String> pathSegmentDecoder();

        public static EventRuleEvaluatorRequest release(String projectId, String releaseId, Function<String, String> segmentDecoder) {
            return EventRuleEvaluatorRequest.release(ResourceNameUtils.ReleaseReference.formatName(projectId, releaseId), segmentDecoder);
        }

        public static EventRuleEvaluatorRequest release(String releaseName, Function<String, String> segmentDecoder) {
            return new AutoValue_EventRuleEvaluator_EventRuleEvaluatorRequest(releaseName, segmentDecoder);
        }
    }
}

