/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.ParentPointer;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class CompositeListener
implements EvaluationListener {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/impl/CompositeListener");
    private final ImmutableList<EvaluationListener> listeners;

    private CompositeListener(ImmutableList<EvaluationListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.beforeExpression(expression, contextParentPointer)));
    }

    @Override
    public void afterExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer, @Nullable ExpressionValue expressionValue) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.afterExpression(expression, contextParentPointer, expressionValue)));
    }

    @Override
    public void beforeAsyncFunction(long uniqueId, ExecutionRequest request, ParentPointer<ExecutionContext> contextParentPointer) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.beforeAsyncFunction(uniqueId, request, contextParentPointer)));
    }

    @Override
    public void afterAsyncFunction(long uniqueId, ExecutionRequest request, ParentPointer<ExecutionContext> contextParentPointer, ListenableFuture<ExecutionResponse> asyncResponse) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.afterAsyncFunction(uniqueId, request, contextParentPointer, asyncResponse)));
    }

    @Override
    public void beforePermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.beforePermissionEvaluation(contexts)));
    }

    @Override
    public void afterPermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts, boolean allow) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.afterPermissionEvaluation(contexts, allow)));
    }

    @Override
    public void afterPermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts, Throwable throwable) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.afterPermissionEvaluation(contexts, throwable)));
    }

    @Override
    public void afterSinglePermissionEvaluation(Evaluator.Context context, boolean allow, Expression expression) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.afterSinglePermissionEvaluation(context, allow, expression)));
    }

    @Override
    public void afterSinglePermissionEvaluation(Evaluator.Context context, Throwable throwable, Expression expression) {
        this.listeners.forEach(this.tryInvoke(listener -> listener.afterSinglePermissionEvaluation(context, throwable, expression)));
    }

    @Override
    public void functionNotFound(ExecutionRequest request, ParentPointer<ExecutionContext> contextParentPointer) {
        this.listeners.stream().forEach(this.tryInvoke(listener -> listener.functionNotFound(request, contextParentPointer)));
    }

    private Consumer<EvaluationListener> tryInvoke(Consumer<EvaluationListener> invocation) {
        return listener -> {
            try {
                invocation.accept((EvaluationListener)listener);
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(1, TimeUnit.MINUTES)).withCause(e)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/CompositeListener", "lambda$tryInvoke$10", 119, "CompositeListener.java")).log();
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<EvaluationListener> evaluationListeners = ImmutableList.builder();

        public Builder addListener(EvaluationListener evaluationListener) {
            this.evaluationListeners.add((Object)evaluationListener);
            return this;
        }

        public CompositeListener build() {
            return new CompositeListener((ImmutableList)this.evaluationListeners.build());
        }
    }
}

