/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.firebase.rules.runtime.common.EvaluationRestrictions;
import com.google.firebase.rules.runtime.common.RestrictionException;
import com.google.firebase.rules.runtime.impl.ExpressionStackWalker;
import com.google.firebase.rules.runtime.impl.MultiThreadedCpuTimeMeasurer;
import com.google.firebase.rules.runtime.impl.StackSizeMonitor;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class EvaluationManager {
    private final EvaluationRestrictions restrictions;
    private final boolean timeLimitEnabled;
    private final boolean stackLimitEnabled;
    private long totalEvaluatedExpressions = 0L;
    private final ExpressionStackWalker expressionStackWalker;
    private final StackSizeMonitor stackSizeMonitor = new StackSizeMonitor();
    private MultiThreadedCpuTimeMeasurer multiThreadedCpuTimeMeasurer = new MultiThreadedCpuTimeMeasurer();

    public EvaluationManager(EvaluationRestrictions restrictions, ExpressionStackWalker expressionStackWalker) {
        this.restrictions = restrictions;
        this.expressionStackWalker = expressionStackWalker;
        this.timeLimitEnabled = !restrictions.maximumEvaluationTime().isZero() && !restrictions.maximumEvaluationTime().isNegative();
        this.stackLimitEnabled = restrictions.maximumStackSize() > 0;
    }

    public synchronized void canEvaluate(Expression expression) throws RestrictionException {
        if (++this.totalEvaluatedExpressions > (long)this.restrictions.maximumExpressionSize()) {
            throw RestrictionException.makeMaximumExpressionsError(expression.getSourcePosition(), this.restrictions.maximumExpressionSize());
        }
        if (this.stackLimitEnabled && this.stackSizeMonitor.getTotalStackSize() > (long)this.restrictions.maximumStackSize()) {
            throw RestrictionException.makeMaximumStackSizeError(expression.getSourcePosition(), this.restrictions.maximumExpressionSize());
        }
        if (this.timeLimitEnabled && this.multiThreadedCpuTimeMeasurer.totalTime().compareTo(this.restrictions.maximumEvaluationTime()) > 0) {
            throw RestrictionException.makeMaxEvaluationTimeReached(expression.getSourcePosition());
        }
    }

    public ExpressionStackWalker expressionStackWalker() {
        return this.expressionStackWalker;
    }

    synchronized void valuePopped(ExpressionValue expressionValue) {
        if (this.stackLimitEnabled) {
            this.stackSizeMonitor.valuePopped(expressionValue);
        }
    }

    synchronized void valuePushed(ExpressionValue expressionValue) {
        if (this.stackLimitEnabled) {
            this.stackSizeMonitor.valuePushed(expressionValue);
        }
    }

    public void startMeasuringThreadTime() {
        if (this.timeLimitEnabled) {
            this.multiThreadedCpuTimeMeasurer.start();
        }
    }

    public void stopMeasuringThreadTime() {
        if (this.timeLimitEnabled) {
            this.multiThreadedCpuTimeMeasurer.stop();
        }
    }
}

