/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.impl.EvaluationManager;
import com.google.firebase.rules.runtime.impl.ExecutableExpression;
import com.google.firebase.rules.runtime.impl.Program;
import com.google.firebase.rules.runtime.impl.StackMachine;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class Interpreter {
    private final EvaluationManager evaluationManager;

    public Interpreter(EvaluationManager evaluationManager) {
        this.evaluationManager = evaluationManager;
    }

    public ListenableFuture<Boolean> interpret(ExecutableExpression executableExpression, EvaluationListener evaluationListener) {
        return Futures.transformAsync(this.evaluate(executableExpression, evaluationListener), value -> {
            if (!ExpressionValueUtils.isBool(value)) {
                throw EvaluationException.makeTypeError(executableExpression.expression().getSourcePosition(), value.getKindCase(), ExpressionValue.KindCase.BOOL_VALUE);
            }
            return Futures.immediateFuture(value.getBoolValue());
        }, MoreExecutors.directExecutor());
    }

    public ListenableFuture<ExpressionValue> evaluate(ExecutableExpression executableExpression, EvaluationListener evaluationListener) {
        Program program = new Program(this.evaluationManager, evaluationListener);
        program.pushExecution(executableExpression);
        return new StackMachine(program).evaluate();
    }
}

