/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.impl.Activation;
import com.google.firebase.rules.runtime.impl.EvaluationManager;
import com.google.firebase.rules.runtime.impl.ExecutableExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;

public class Program {
    private final EvaluationManager evaluationManager;
    private final EvaluationListener evaluationListener;
    private final Deque<ExecutionFrame> executionFrames = new ArrayDeque<ExecutionFrame>();
    private final Deque<ExpressionValue> stack = new ArrayDeque<ExpressionValue>();

    Program(EvaluationManager evaluationManager, EvaluationListener evaluationListener) {
        this.evaluationManager = evaluationManager;
        this.evaluationListener = evaluationListener;
    }

    void pushExecution(ExecutableExpression executableExpression) {
        this.executionFrames.push(new ExecutionFrame(this, executableExpression));
    }

    @Nullable
    Expression getNextExpression() {
        Expression next;
        ExecutionFrame executionFrame = this.executionFrames.peek();
        if (executionFrame == null) {
            return null;
        }
        Expression previous = executionFrame.peekPreviousExpression();
        if (!this.stack.isEmpty() && previous != null) {
            this.afterExpression(previous, executionFrame.activation, this.stack.peek());
        }
        if ((next = executionFrame.getNextExpression()) == null) {
            this.executionFrames.pop();
            return this.getNextExpression();
        }
        this.beforeExpression(next, executionFrame.activation);
        return next;
    }

    private static boolean isJumpIf(Expression expression) {
        return expression.hasCall() && expression.getCall().getFunctionName().getName().equals(FunctionTemplate.BuiltInBooleanOperator.JUMP_IF.getFunctionName());
    }

    private void beforeExpression(Expression expression, Activation activation) {
        if (!Program.isJumpIf(expression)) {
            this.evaluationListener.beforeExpression(expression, activation);
        }
    }

    private void afterExpression(Expression expression, Activation activation, @Nullable ExpressionValue value) {
        if (!Program.isJumpIf(expression)) {
            this.evaluationListener.afterExpression(expression, activation, value);
        }
    }

    public Activation activation() {
        return this.executionFrames.peek().activation;
    }

    EvaluationManager evaluationManager() {
        return this.evaluationManager;
    }

    EvaluationListener evaluationListener() {
        return this.evaluationListener;
    }

    public Deque<ExpressionValue> stack() {
        return this.stack;
    }

    void incrementProgramCounter(int jumpCount) {
        Preconditions.checkArgument(jumpCount > 0);
        ExecutionFrame currentExecution = this.executionFrames.peek();
        Preconditions.checkArgument(currentExecution.pc + jumpCount <= currentExecution.source.size());
        for (int i = 0; i < jumpCount - 1; ++i) {
            Expression expression = currentExecution.getNextExpression();
            this.beforeExpression(expression, currentExecution.activation);
            this.afterExpression(expression, currentExecution.activation, null);
        }
        this.beforeExpression(currentExecution.getNextExpression(), currentExecution.activation);
    }

    private class ExecutionFrame {
        private final Activation activation;
        private final ImmutableList<Expression> source;
        private final int sourceSize;
        private int pc;

        ExecutionFrame(Program program, ExecutableExpression executableExpression) {
            this.source = program.evaluationManager.expressionStackWalker().walk(executableExpression.expression());
            this.activation = executableExpression.activation();
            this.pc = 0;
            this.sourceSize = this.source.size();
        }

        @Nullable
        Expression getNextExpression() {
            Preconditions.checkState(this.pc <= this.sourceSize);
            if (this.sourceSize == this.pc) {
                return null;
            }
            return (Expression)this.source.get(this.pc++);
        }

        @Nullable
        Expression peekPreviousExpression() {
            Preconditions.checkState(this.pc <= this.sourceSize);
            if (this.pc == 0) {
                return null;
            }
            return (Expression)this.source.get(this.pc - 1);
        }
    }
}

