/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;

public final class Abs
extends OverloadedRuntimeFunction {
    public Abs() {
        super(FunctionTemplate.ABS, new AbsInt(), new AbsFloat());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class AbsFloat
    implements RuntimeFunction {
        private AbsFloat() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Math.abs(request.getArguments(0).getFloatValue())));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class AbsInt
    implements RuntimeFunction {
        private AbsInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Math.abs(request.getArguments(0).getIntValue())));
        }
    }
}

