/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;

public final class Add
extends OverloadedRuntimeFunction {
    public Add() {
        super((FunctionTemplate)FunctionTemplate.BuiltInMathOperator.ADD, new AddInt(), new AddNumber(), new ConcatString(), new AddDuration(), new AddDurationToTimestamp(), new AddTimestampToDuration());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class AddTimestampToDuration
    implements RuntimeFunction {
        private AddTimestampToDuration() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.add(request.getArguments(0).getTimestampValue(), request.getArguments(1).getDurationValue())));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidTimestampError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.TIMESTAMP})
    private static class AddDurationToTimestamp
    implements RuntimeFunction {
        private AddDurationToTimestamp() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.add(request.getArguments(1).getTimestampValue(), request.getArguments(0).getDurationValue())));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidTimestampError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class AddDuration
    implements RuntimeFunction {
        private AddDuration() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Durations.add(request.getArguments(0).getDurationValue(), request.getArguments(1).getDurationValue())));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidDurationError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class AddNumber
    implements RuntimeFunction {
        private AddNumber() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            double value = 0.0;
            for (ExpressionValue arg : request.getArgumentsList()) {
                value += arg.getFloatValue();
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(value));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class AddInt
    implements RuntimeFunction {
        private AddInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            long value = 0L;
            for (ExpressionValue arg : request.getArgumentsList()) {
                try {
                    value = Math.addExact(value, arg.getIntValue());
                }
                catch (ArithmeticException e) {
                    throw EvaluationException.makeIntegerOverflowError(request.getSourcePosition());
                }
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(value));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING, FunctionExpects.ExpectedExpressionKind.STRING})
    private static class ConcatString
    implements RuntimeFunction {
        private ConcatString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            StringBuilder sb = new StringBuilder();
            for (ExpressionValue arg : request.getArgumentsList()) {
                sb.append(arg.getStringValue());
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)sb.toString()));
        }
    }
}

