/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.LessThan;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

public final class GreaterThan
extends OverloadedRuntimeFunction {
    public GreaterThan() {
        super((FunctionTemplate)FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN, new GreaterThanString(), new GreaterThanBytes(), new GreaterThanInteger(), new GreaterThanFloat(), new GreaterThanDuration(), new GreaterThanTimestamp(), new GreaterThanConstraintAny(), new GreaterThanAnyConstraint(new LessThan.LessThanConstraintAny()));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.CONSTRAINT})
    private static class GreaterThanAnyConstraint
    implements RuntimeFunction {
        private final LessThan.LessThanConstraintAny lessThanConstraintAny;

        public GreaterThanAnyConstraint(LessThan.LessThanConstraintAny lessThanConstraintAny) {
            this.lessThanConstraintAny = lessThanConstraintAny;
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return this.lessThanConstraintAny.execute(ExpressionValueUtils.swapArguments(request));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.CONSTRAINT, FunctionExpects.ExpectedExpressionKind.ANY})
    static class GreaterThanConstraintAny
    implements RuntimeFunction {
        GreaterThanConstraintAny() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ConstraintValue leftValue = request.getArguments(0).getConstraintValue();
            ExpressionValue rightValue = request.getArguments(1);
            if (ExpressionValueUtils.isConstraint(rightValue)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.ORDERABLE_KIND_CASES);
            }
            SimpleConstraint simpleConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.GT, rightValue, request.getSourcePosition());
            return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(leftValue, simpleConstraint));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.TIMESTAMP})
    private static class GreaterThanTimestamp
    extends GreaterThanObject {
        private GreaterThanTimestamp() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class GreaterThanDuration
    extends GreaterThanObject {
        private GreaterThanDuration() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class GreaterThanFloat
    extends GreaterThanObject {
        private GreaterThanFloat() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class GreaterThanInteger
    extends GreaterThanObject {
        private GreaterThanInteger() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.BYTES, FunctionExpects.ExpectedExpressionKind.BYTES})
    private static class GreaterThanBytes
    extends GreaterThanObject {
        private GreaterThanBytes() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING, FunctionExpects.ExpectedExpressionKind.STRING})
    private static class GreaterThanString
    extends GreaterThanObject {
        private GreaterThanString() {
        }
    }

    private static class GreaterThanObject
    implements RuntimeFunction {
        private GreaterThanObject() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue leftValue = request.getArguments(0);
            ExpressionValue rightValue = request.getArguments(1);
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(ExpressionValueUtils.greaterThan(leftValue, rightValue)));
        }
    }
}

