/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.LessThanOrEquals;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

public final class GreaterThanOrEquals
extends OverloadedRuntimeFunction {
    public GreaterThanOrEquals() {
        super((FunctionTemplate)FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN_OR_EQUALS, new GreaterThanOrEqualsString(), new GreaterThanOrEqualsBytes(), new GreaterThanOrEqualsInteger(), new GreaterThanOrEqualsFloat(), new GreaterThanOrEqualsDuration(), new GreaterThanOrEqualsTimestamp(), new GreaterThanOrEqualsConstraintAny(), new GreaterThanOrEqualsAnyConstraint(new LessThanOrEquals.LessThanOrEqualsConstraintAny()));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.CONSTRAINT})
    private static class GreaterThanOrEqualsAnyConstraint
    implements RuntimeFunction {
        private final LessThanOrEquals.LessThanOrEqualsConstraintAny lessThanOrEqualsConstraintAny;

        public GreaterThanOrEqualsAnyConstraint(LessThanOrEquals.LessThanOrEqualsConstraintAny lessThanOrEqualsConstraintAny) {
            this.lessThanOrEqualsConstraintAny = lessThanOrEqualsConstraintAny;
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return this.lessThanOrEqualsConstraintAny.execute(ExpressionValueUtils.swapArguments(request));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.CONSTRAINT, FunctionExpects.ExpectedExpressionKind.ANY})
    static class GreaterThanOrEqualsConstraintAny
    implements RuntimeFunction {
        GreaterThanOrEqualsConstraintAny() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ConstraintValue leftValue = request.getArguments(0).getConstraintValue();
            ExpressionValue rightValue = request.getArguments(1);
            if (ExpressionValueUtils.isConstraint(rightValue)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.ORDERABLE_KIND_CASES);
            }
            SimpleConstraint simpleConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.GTE, rightValue, request.getSourcePosition());
            return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(leftValue, simpleConstraint));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.TIMESTAMP})
    private static class GreaterThanOrEqualsTimestamp
    extends GreaterThanOrEqualsObject {
        private GreaterThanOrEqualsTimestamp() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class GreaterThanOrEqualsDuration
    extends GreaterThanOrEqualsObject {
        private GreaterThanOrEqualsDuration() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class GreaterThanOrEqualsFloat
    extends GreaterThanOrEqualsObject {
        private GreaterThanOrEqualsFloat() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class GreaterThanOrEqualsInteger
    extends GreaterThanOrEqualsObject {
        private GreaterThanOrEqualsInteger() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.BYTES, FunctionExpects.ExpectedExpressionKind.BYTES})
    private static class GreaterThanOrEqualsBytes
    extends GreaterThanOrEqualsObject {
        private GreaterThanOrEqualsBytes() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING, FunctionExpects.ExpectedExpressionKind.STRING})
    private static class GreaterThanOrEqualsString
    extends GreaterThanOrEqualsObject {
        private GreaterThanOrEqualsString() {
        }
    }

    private static class GreaterThanOrEqualsObject
    implements RuntimeFunction {
        private GreaterThanOrEqualsObject() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue leftValue = request.getArguments(0);
            ExpressionValue rightValue = request.getArguments(1);
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(ExpressionValueUtils.greaterThanOrEquals(leftValue, rightValue)));
        }
    }
}

