/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.common.TypeName;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.STRING})
public class IsType
extends GuardedRuntimeFunction {
    public IsType() {
        super(FunctionTemplate.BuiltInBooleanOperator.IS_TYPE);
    }

    @Override
    public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
        ExpressionValue.KindCase exprValueType = request.getArguments(0).getKindCase();
        String typeNameString = request.getArguments(1).getStringValue();
        TypeName typeName = TypeName.fromString(typeNameString);
        return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(this.valueIsBuiltinType(exprValueType, typeName)));
    }

    private boolean valueIsBuiltinType(ExpressionValue.KindCase exprValueType, TypeName typeName) {
        switch (exprValueType) {
            case BOOL_VALUE: {
                return typeName == TypeName.BOOL;
            }
            case DURATION_VALUE: {
                return typeName == TypeName.DURATION;
            }
            case CONSTRAINT_VALUE: {
                return typeName == TypeName.CONSTRAINT;
            }
            case FLOAT_VALUE: {
                return typeName == TypeName.FLOAT || typeName == TypeName.NUMBER;
            }
            case INT_VALUE: {
                return typeName == TypeName.INT || typeName == TypeName.NUMBER;
            }
            case LATLNG_VALUE: {
                return typeName == TypeName.LATLNG;
            }
            case LIST_VALUE: {
                return typeName == TypeName.LIST;
            }
            case MAP_VALUE: {
                return typeName == TypeName.MAP;
            }
            case STRING_VALUE: {
                return typeName == TypeName.STRING;
            }
            case BYTES_VALUE: {
                return typeName == TypeName.BYTES;
            }
            case TIMESTAMP_VALUE: {
                return typeName == TypeName.TIMESTAMP;
            }
            case PATH_VALUE: {
                return typeName == TypeName.PATH_TEMPLATE;
            }
        }
        return false;
    }
}

