/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.type.LatLng;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
public class LatLngValue
extends GuardedRuntimeFunction {
    public LatLngValue() {
        super(FunctionTemplate.BuiltInTypeConversionFunction.LATLNG_VALUE);
    }

    @Override
    public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
        double lat = request.getArguments(0).getFloatValue();
        double lng = request.getArguments(1).getFloatValue();
        if (Double.isNaN(lat) || Double.isNaN(lng) || lat > 90.0 || lat < -90.0 || lng < -180.0 || lng > 180.0) {
            throw EvaluationException.makeInvalidLatLngError(request.getSourcePosition(), lat, lng);
        }
        return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)LatLng.newBuilder().setLatitude(lat).setLongitude(lng).build()));
    }
}

