/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.GreaterThan;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

public final class LessThan
extends OverloadedRuntimeFunction {
    public LessThan() {
        super((FunctionTemplate)FunctionTemplate.BuiltInBooleanOperator.LESS_THAN, new LessThanString(), new LessThanBytes(), new LessThanInteger(), new LessThanFloat(), new LessThanDuration(), new LessThanTimestamp(), new LessThanConstraintAny(), new LessThanAnyConstraint(new GreaterThan.GreaterThanConstraintAny()));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.CONSTRAINT})
    private static class LessThanAnyConstraint
    implements RuntimeFunction {
        private final GreaterThan.GreaterThanConstraintAny greaterThanConstraintAny;

        public LessThanAnyConstraint(GreaterThan.GreaterThanConstraintAny greaterThanConstraintAny) {
            this.greaterThanConstraintAny = greaterThanConstraintAny;
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return this.greaterThanConstraintAny.execute(ExpressionValueUtils.swapArguments(request));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.CONSTRAINT, FunctionExpects.ExpectedExpressionKind.ANY})
    static class LessThanConstraintAny
    implements RuntimeFunction {
        LessThanConstraintAny() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ConstraintValue leftValue = request.getArguments(0).getConstraintValue();
            ExpressionValue rightValue = request.getArguments(1);
            SimpleConstraint simpleConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.LT, rightValue, request.getSourcePosition());
            if (ExpressionValueUtils.isConstraint(rightValue)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.ORDERABLE_KIND_CASES);
            }
            return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(leftValue, simpleConstraint));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.TIMESTAMP})
    private static class LessThanTimestamp
    extends LessThanObject {
        private LessThanTimestamp() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class LessThanDuration
    extends LessThanObject {
        private LessThanDuration() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class LessThanFloat
    extends LessThanObject {
        private LessThanFloat() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class LessThanInteger
    extends LessThanObject {
        private LessThanInteger() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.BYTES, FunctionExpects.ExpectedExpressionKind.BYTES})
    private static class LessThanBytes
    extends LessThanObject {
        private LessThanBytes() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING, FunctionExpects.ExpectedExpressionKind.STRING})
    private static class LessThanString
    extends LessThanObject {
        private LessThanString() {
        }
    }

    private static class LessThanObject
    implements RuntimeFunction {
        private LessThanObject() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue leftValue = request.getArguments(0);
            ExpressionValue rightValue = request.getArguments(1);
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(ExpressionValueUtils.lessThan(leftValue, rightValue)));
        }
    }
}

