/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;

public final class Minus
extends OverloadedRuntimeFunction {
    public Minus() {
        super((FunctionTemplate)FunctionTemplate.BuiltInMathOperator.MINUS, new MinusInt(), new MinusNumber(), new MinusDuration(), new MinusTimestampDuration(), new MinusTimestamp());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.TIMESTAMP})
    private static class MinusTimestamp
    implements RuntimeFunction {
        private MinusTimestamp() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.between(request.getArguments(1).getTimestampValue(), request.getArguments(0).getTimestampValue())));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidDurationError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class MinusTimestampDuration
    implements RuntimeFunction {
        private MinusTimestampDuration() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.subtract(request.getArguments(0).getTimestampValue(), request.getArguments(1).getDurationValue())));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidTimestampError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class MinusDuration
    implements RuntimeFunction {
        private MinusDuration() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Durations.subtract(request.getArguments(0).getDurationValue(), request.getArguments(1).getDurationValue())));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidDurationError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class MinusNumber
    implements RuntimeFunction {
        private MinusNumber() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            double result = request.getArguments(0).getFloatValue() - request.getArguments(1).getFloatValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(result));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class MinusInt
    implements RuntimeFunction {
        private MinusInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            try {
                long result = Math.subtractExact(request.getArguments(0).getIntValue(), request.getArguments(1).getIntValue());
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(result));
            }
            catch (ArithmeticException e) {
                throw EvaluationException.makeIntegerOverflowError(request.getSourcePosition());
            }
        }
    }
}

