/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;

public final class Modulus
extends OverloadedRuntimeFunction {
    public Modulus() {
        super((FunctionTemplate)FunctionTemplate.BuiltInMathOperator.MODULUS, new ModulusInt(), new ModulusNumber());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class ModulusNumber
    implements RuntimeFunction {
        private ModulusNumber() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            double leftValue = request.getArguments(0).getFloatValue();
            double rightValue = request.getArguments(1).getFloatValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(leftValue % rightValue));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class ModulusInt
    implements RuntimeFunction {
        private ModulusInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            long leftValue = request.getArguments(0).getIntValue();
            long rightValue = request.getArguments(1).getIntValue();
            if (rightValue == 0L) {
                throw EvaluationException.makeDivideByZeroError(request.getSourcePosition());
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(leftValue % rightValue));
        }
    }
}

