/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;

public final class Multiply
extends OverloadedRuntimeFunction {
    public Multiply() {
        super((FunctionTemplate)FunctionTemplate.BuiltInMathOperator.MULTIPLY, new MultiplyInt(), new MultiplyNumber());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class MultiplyNumber
    implements RuntimeFunction {
        private MultiplyNumber() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            double leftValue = request.getArguments(0).getFloatValue();
            double rightValue = request.getArguments(1).getFloatValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(leftValue * rightValue));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class MultiplyInt
    implements RuntimeFunction {
        private MultiplyInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            long leftValue = request.getArguments(0).getIntValue();
            long rightValue = request.getArguments(1).getIntValue();
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Math.multiplyExact(leftValue, rightValue)));
            }
            catch (ArithmeticException e) {
                throw EvaluationException.makeIntegerOverflowError(request.getSourcePosition());
            }
        }
    }
}

