/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.common.primitives.Ints;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.units.TimestampUtil;
import com.google.protobuf.util.JodaTimeConversions;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
public class TimestampDate
extends GuardedRuntimeFunction {
    public TimestampDate() {
        super(FunctionTemplate.BuiltInTypeConversionFunction.TIMESTAMP_DATE);
    }

    @Override
    public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
        LocalDate localDate;
        long year = request.getArguments(0).getIntValue();
        long month = request.getArguments(1).getIntValue();
        long day = request.getArguments(2).getIntValue();
        if (!TimestampUtil.isValidYear(year)) {
            throw EvaluationException.makeBadYearTimestampError(request.getSourcePosition(), year);
        }
        try {
            localDate = new LocalDate(Ints.checkedCast(year), Ints.checkedCast(month), Ints.checkedCast(day));
        }
        catch (IllegalArgumentException e) {
            throw EvaluationException.makeInvalidDateExceptionError(request.getSourcePosition(), year, month, day);
        }
        return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)JodaTimeConversions.toProtoTimestamp(localDate.toDateTimeAtStartOfDay(DateTimeZone.UTC))));
    }
}

