/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.protobuf.util.Timestamps;
import java.text.ParseException;

public class TimestampEpoch
extends OverloadedRuntimeFunction {
    public TimestampEpoch() {
        super((FunctionTemplate)FunctionTemplate.BuiltInTypeConversionFunction.TIMESTAMP_VALUE, new TimestampMillis(), new TimestampString());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class TimestampString
    implements RuntimeFunction {
        private TimestampString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            String timestampString = request.getArguments(0).getStringValue();
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.parse(timestampString)));
            }
            catch (ParseException e) {
                throw EvaluationException.makeInvalidTimestampError(request.getSourcePosition());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class TimestampMillis
    implements RuntimeFunction {
        private TimestampMillis() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            long millisFromEpoch = request.getArguments(0).getIntValue();
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.fromMillis(millisFromEpoch)));
            }
            catch (IllegalArgumentException e) {
                throw EvaluationException.makeInvalidTimestampError(request.getSourcePosition());
            }
        }
    }
}

