/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.v1.SourcePosition;

public final class ToString
extends OverloadedRuntimeFunction {
    private static final String NULL_STRING = "null";
    private static final ToString INSTANCE = new ToString();

    public ToString() {
        super((FunctionTemplate)FunctionTemplate.BuiltInTypeConversionFunction.TO_STRING, new IntToString(), new FloatToString(), new NullToString(), new StringToString(), new BoolToString());
    }

    private static String intToString(ExpressionValue value) {
        return Long.toString(value.getIntValue());
    }

    private static String floatToString(ExpressionValue value) {
        return Double.toString(value.getFloatValue());
    }

    private static String boolToString(ExpressionValue value) {
        return Boolean.toString(value.getBoolValue());
    }

    private static String nullToString() {
        return NULL_STRING;
    }

    public static String stringify(SourcePosition sourcePosition, ExpressionValue expressionValue) throws EvaluationException {
        switch (expressionValue.getKindCase()) {
            case STRING_VALUE: {
                return expressionValue.getStringValue();
            }
            case INT_VALUE: {
                return ToString.intToString(expressionValue);
            }
            case FLOAT_VALUE: {
                return ToString.floatToString(expressionValue);
            }
            case NULL_VALUE: {
                return ToString.nullToString();
            }
            case BOOL_VALUE: {
                return ToString.boolToString(expressionValue);
            }
        }
        return INSTANCE.execute(ExecutionRequest.newBuilder().addArguments(expressionValue).setSourcePosition(sourcePosition).setFunctionName(FunctionTemplate.BuiltInTypeConversionFunction.TO_STRING.getFunctionName()).build()).getValue().getStringValue();
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.BOOL})
    private static class BoolToString
    implements RuntimeFunction {
        private BoolToString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)ToString.boolToString(request.getArguments(0))));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL})
    private static class NullToString
    implements RuntimeFunction {
        private NullToString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)ToString.nullToString()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class StringToString
    implements RuntimeFunction {
        private StringToString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(request.getArguments(0));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class FloatToString
    implements RuntimeFunction {
        private FloatToString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)ToString.floatToString(request.getArguments(0))));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class IntToString
    implements RuntimeFunction {
        private IntToString() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)ToString.intToString(request.getArguments(0))));
        }
    }
}

