/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class BytesType
extends AbstractTypeProvider {
    public BytesType() {
        super(ExpressionValue.KindCase.BYTES_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.StringMembers.SIZE.getFunctionName(), new BytesSize());
    }

    @FunctionExpects
    private static class BytesSize
    extends GuardedRuntimeFunction {
        public BytesSize() {
            super(FunctionTemplate.StringMembers.SIZE, ExpressionValue.KindCase.BYTES_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getBytesValue().size()));
        }
    }
}

