/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

public class ConstraintType
extends AbstractTypeProvider {
    public ConstraintType() {
        super(ExpressionValue.KindCase.CONSTRAINT_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.ListMembers.HAS_ANY.getFunctionName(), new HasAny());
        builder.put(FunctionTemplate.IN.getFunctionName(), new In());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY})
    private static class In
    extends GuardedRuntimeFunction {
        public In() {
            super(FunctionTemplate.IN, ExpressionValue.KindCase.CONSTRAINT_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue argument = request.getArguments(0);
            ConstraintValue queryConstraint = request.getOperand().getConstraintValue();
            if (ExpressionValueUtils.isConstraint(argument)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.ORDERABLE_KIND_CASES);
            }
            SimpleConstraint simpleConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.LIST_CONTAINS, argument, request.getSourcePosition());
            return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(queryConstraint, simpleConstraint));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST})
    private static class HasAny
    extends GuardedRuntimeFunction {
        public HasAny() {
            super(FunctionTemplate.ListMembers.HAS_ANY, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue argument = request.getArguments(0).getListValue();
            ConstraintValue queryConstraint = request.getOperand().getConstraintValue();
            for (ExpressionValue argumentItem : argument.getValuesList()) {
                SimpleConstraint simpleConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.LIST_CONTAINS, argumentItem, request.getSourcePosition());
                ExpressionValue implies = ConstraintValueUtils.implies(queryConstraint, simpleConstraint);
                if (!implies.getBoolValue()) continue;
                return ExpressionValueUtils.createResponse(implies);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.FALSE);
        }
    }
}

