/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.Map;

public class MapType
extends AbstractTypeProvider {
    public MapType() {
        super(ExpressionValue.KindCase.MAP_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.MapMembers.SIZE.getFunctionName(), new MapSize());
        builder.put(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), new MapItemAtIndex());
        builder.put(FunctionTemplate.IN.getFunctionName(), new In());
        builder.put(FunctionTemplate.MapMembers.KEYS.getFunctionName(), new MapKeys());
        builder.put(FunctionTemplate.MapMembers.VALUES.getFunctionName(), new MapValues());
    }

    @FunctionExpects
    public static class MapValues
    extends GuardedRuntimeFunction {
        public MapValues() {
            super(FunctionTemplate.MapMembers.VALUES, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue.Builder result = ExpressionListValue.newBuilder();
            ExpressionMapValue mapValue = request.getOperand().getMapValue();
            for (Map.Entry<String, ExpressionValue> entry : mapValue.getFieldsMap().entrySet()) {
                result.addValues(entry.getValue());
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(result.build()));
        }
    }

    @FunctionExpects
    public static class MapKeys
    extends GuardedRuntimeFunction {
        public MapKeys() {
            super(FunctionTemplate.MapMembers.KEYS, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue.Builder result = ExpressionListValue.newBuilder();
            ExpressionMapValue mapValue = request.getOperand().getMapValue();
            for (Map.Entry<String, ExpressionValue> entry : mapValue.getFieldsMap().entrySet()) {
                result.addValues(ExpressionValueUtils.createValue((Object)entry.getKey()));
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(result.build()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class In
    extends GuardedRuntimeFunction {
        public In() {
            super(FunctionTemplate.IN, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String key = request.getArguments(0).getStringValue();
            Map<String, ExpressionValue> map = request.getOperand().getMapValue().getFieldsMap();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(map.containsKey(key)));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    public static class MapItemAtIndex
    extends GuardedRuntimeFunction {
        public MapItemAtIndex() {
            super(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String key = request.getArguments(0).getStringValue();
            Map<String, ExpressionValue> values = request.getOperand().getMapValue().getFieldsMap();
            if (values.containsKey(key)) {
                return ExpressionValueUtils.createResponse(values.get(key));
            }
            throw EvaluationException.makeUndefinedPropertyError(request.getSourcePosition(), key);
        }
    }

    @FunctionExpects
    public static class MapSize
    extends GuardedRuntimeFunction {
        public MapSize() {
            super(FunctionTemplate.MapMembers.SIZE, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionMapValue mapValue = request.getOperand().getMapValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(mapValue.getFieldsMap().size()));
        }
    }
}

