/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.ToString;
import com.google.firebase.rules.runtime.impl.types.RangeCheckUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValueOrBuilder;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.HashSet;
import java.util.Map;

public class PathType
extends AbstractTypeProvider {
    public PathType() {
        super(ExpressionValue.KindCase.PATH_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.PathMembers.BIND.getFunctionName(), new Bind());
        builder.put(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), new PathBindingAtIndex());
        builder.put(FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE.getFunctionName(), new PathLookupRange());
    }

    public static ExpressionValue getPathBoundVariable(ExpressionPathValueOrBuilder pathValue, String key, SourcePosition sourcePosition) throws EvaluationException {
        for (ExpressionPathSegmentValue segment : pathValue.getSegmentsList()) {
            switch (segment.getKindCase()) {
                case CAPTURE: {
                    ExpressionPathSegmentValue.Capture capture = segment.getCapture();
                    String variableName = capture.getVariableName();
                    if (!variableName.equals(key)) break;
                    if (Strings.isNullOrEmpty(capture.getBoundValue())) {
                        throw EvaluationException.makeUnboundVariableError(sourcePosition, key);
                    }
                    return ExpressionValueUtils.createValue((Object)capture.getBoundValue());
                }
                case GLOB_CAPTURE: {
                    ExpressionPathSegmentValue.GlobCapture globCapture = segment.getGlobCapture();
                    String variableName = globCapture.getVariableName();
                    if (!variableName.equals(key)) break;
                    if (!globCapture.hasBoundValue()) {
                        throw EvaluationException.makeUnboundVariableError(sourcePosition, key);
                    }
                    return ExpressionValueUtils.createValue(globCapture.getBoundValue());
                }
            }
        }
        throw EvaluationException.makeUndefinedPropertyError(sourcePosition, key);
    }

    private static ExpressionValue getPathIndexValue(ExpressionPathValueOrBuilder pathValue, Long index, SourcePosition sourcePosition) throws EvaluationException {
        String segmentValue;
        ImmutableList<ExpressionPathSegmentValue> flattenedPathValue = PathType.flattenGlobs(pathValue, sourcePosition);
        int size = flattenedPathValue.size();
        if (index < 0L || index >= (long)size) {
            throw EvaluationException.makeIndexOutOfBoundError(sourcePosition, index, size);
        }
        ExpressionPathSegmentValue segment = (ExpressionPathSegmentValue)flattenedPathValue.get(index.intValue());
        switch (segment.getKindCase()) {
            case CAPTURE: {
                ExpressionPathSegmentValue.Capture capture = segment.getCapture();
                String boundValue = capture.getBoundValue();
                if (Strings.isNullOrEmpty(boundValue)) {
                    throw EvaluationException.makeUnboundVariableError(sourcePosition, capture.getVariableName());
                }
                segmentValue = boundValue;
                break;
            }
            default: {
                segmentValue = segment.getSimple();
            }
        }
        return ExpressionValueUtils.createValue((Object)segmentValue);
    }

    public static ImmutableList<ExpressionPathSegmentValue> flattenGlobs(ExpressionPathValueOrBuilder pathValue, SourcePosition sourcePosition) throws EvaluationException {
        ImmutableList.Builder flattenedPathValues = ImmutableList.builder();
        block4: for (ExpressionPathSegmentValue segment : pathValue.getSegmentsList()) {
            switch (segment.getKindCase()) {
                case GLOB_CAPTURE: {
                    ExpressionPathSegmentValue.GlobCapture globCapture = segment.getGlobCapture();
                    if (!globCapture.hasBoundValue()) {
                        throw EvaluationException.makeUnboundVariableError(sourcePosition, globCapture.getVariableName());
                    }
                    flattenedPathValues.addAll(PathType.flattenGlobs(globCapture.getBoundValue(), sourcePosition));
                    continue block4;
                }
                case CAPTURE: {
                    ExpressionPathSegmentValue.Capture capture = segment.getCapture();
                    String boundValue = capture.getBoundValue();
                    if (Strings.isNullOrEmpty(boundValue)) {
                        throw EvaluationException.makeUnboundVariableError(sourcePosition, capture.getVariableName());
                    }
                    flattenedPathValues.add(segment);
                    continue block4;
                }
            }
            flattenedPathValues.add(segment);
        }
        return flattenedPathValues.build();
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL, FunctionExpects.ExpectedExpressionKind.NULL})
    private static class PathReference
    implements RuntimeFunction {
        private PathReference() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(request.getOperand());
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class PathRangeIntInt
    extends PathRange {
        private PathRangeIntInt() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.NULL})
    private static class PathRangeIntNull
    extends PathRange {
        private PathRangeIntNull() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL, FunctionExpects.ExpectedExpressionKind.INT})
    private static class PathRangeNullInt
    extends PathRange {
        private PathRangeNullInt() {
        }
    }

    private static abstract class PathRange
    implements RuntimeFunction {
        private PathRange() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ImmutableList<ExpressionPathSegmentValue> flattened = PathType.flattenGlobs(request.getOperand().getPathValue(), request.getSourcePosition());
            int pathLength = flattened.size();
            ExpressionValue rangeStart = request.getArguments(0);
            ExpressionValue rangeEnd = request.getArguments(1);
            int fromIndex = RangeCheckUtils.getFromIndex(request, rangeStart, pathLength);
            int toIndex = RangeCheckUtils.getToIndex(request, rangeEnd, pathLength);
            RangeCheckUtils.checkRange(request, fromIndex, pathLength);
            RangeCheckUtils.checkRange(request, toIndex - 1, pathLength);
            if (toIndex < fromIndex) {
                throw EvaluationException.makeIllegalRangeError(request.getSourcePosition(), fromIndex, toIndex);
            }
            ExpressionPathValue.Builder rangeList = ExpressionPathValue.newBuilder();
            for (int i = fromIndex; i < toIndex; ++i) {
                rangeList.addSegments((ExpressionPathSegmentValue)flattened.get(i));
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(rangeList.build()));
        }
    }

    public static class PathLookupRange
    extends OverloadedRuntimeFunction {
        public PathLookupRange() {
            super((FunctionTemplate)FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE, ExpressionValue.KindCase.PATH_VALUE, new PathReference(), new PathRangeIntInt(), new PathRangeIntNull(), new PathRangeNullInt());
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.MAP})
    public static class Bind
    extends GuardedRuntimeFunction {
        public Bind() {
            super(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX, ExpressionValue.KindCase.PATH_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionPathValue inputPath = request.getOperand().getPathValue();
            ExpressionPathValue.Builder outputPath = ExpressionPathValue.newBuilder();
            Map<String, ExpressionValue> bindings = request.getArguments(0).getMapValue().getFields();
            HashSet<String> remainingKeys = Sets.newHashSet(bindings.keySet());
            block5: for (ExpressionPathSegmentValue segment : inputPath.getSegmentsList()) {
                switch (segment.getKindCase()) {
                    case CAPTURE: {
                        ExpressionPathSegmentValue.Capture capture = segment.getCapture();
                        String variableName = capture.getVariableName();
                        if (!bindings.containsKey(variableName)) continue block5;
                        if (!Strings.isNullOrEmpty(capture.getBoundValue())) {
                            throw EvaluationException.makeAlreadyBoundError(request.getSourcePosition(), variableName);
                        }
                        String boundValue = ToString.stringify(request.getSourcePosition(), bindings.get(variableName));
                        if (Strings.isNullOrEmpty(boundValue)) {
                            throw EvaluationException.makeEmptyBindError(request.getSourcePosition(), variableName);
                        }
                        outputPath.addSegments(ExpressionPathSegmentValue.newBuilder().setCapture(capture.toBuilder().setBoundValue(boundValue)));
                        remainingKeys.remove(variableName);
                        continue block5;
                    }
                    case GLOB_CAPTURE: {
                        ExpressionPathSegmentValue.GlobCapture globCapture = segment.getGlobCapture();
                        String variableName = globCapture.getVariableName();
                        if (!bindings.containsKey(variableName)) continue block5;
                        if (globCapture.hasBoundValue()) {
                            throw EvaluationException.makeAlreadyBoundError(request.getSourcePosition(), variableName);
                        }
                        ExpressionValue boundValue = bindings.get(variableName);
                        if (!ExpressionValueUtils.isPath(boundValue)) {
                            throw EvaluationException.makeTypeError(request.getSourcePosition(), boundValue.getKindCase(), ExpressionValue.KindCase.PATH_VALUE);
                        }
                        ExpressionValueUtils.getPathSegments(request.getSourcePosition(), boundValue.getPathValue());
                        outputPath.addSegments(ExpressionPathSegmentValue.newBuilder().setGlobCapture(globCapture.toBuilder().setBoundValue(boundValue.getPathValue())));
                        remainingKeys.remove(variableName);
                        continue block5;
                    }
                    case SIMPLE: {
                        outputPath.addSegments(segment);
                        continue block5;
                    }
                }
                String string = String.valueOf(segment.getKindCase());
                throw new RuntimeException(new StringBuilder(31 + String.valueOf(string).length()).append("Unknown path template segment: ").append(string).toString());
            }
            if (!remainingKeys.isEmpty()) {
                throw EvaluationException.makeUnknownBindError(request.getSourcePosition(), Joiner.on(",").join(remainingKeys));
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(outputPath.build()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class PathBindingAtIntIndex
    implements RuntimeFunction {
        private PathBindingAtIntIndex() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(PathType.getPathIndexValue(request.getOperand().getPathValue(), request.getArguments(0).getIntValue(), request.getSourcePosition()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class PathBindingAtStringIndex
    implements RuntimeFunction {
        private PathBindingAtStringIndex() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(PathType.getPathBoundVariable(request.getOperand().getPathValue(), request.getArguments(0).getStringValue(), request.getSourcePosition()));
        }
    }

    public static class PathBindingAtIndex
    extends OverloadedRuntimeFunction {
        public PathBindingAtIndex() {
            super((FunctionTemplate)FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX, ExpressionValue.KindCase.PATH_VALUE, new PathBindingAtStringIndex(), new PathBindingAtIntIndex());
        }
    }
}

