/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.common.RegexValidator;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.types.RangeCheckUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.re2j.Pattern;

public class StringType
extends AbstractTypeProvider {
    public StringType() {
        super(ExpressionValue.KindCase.STRING_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.StringMembers.SIZE.getFunctionName(), new StringSize());
        builder.put(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), new CharAtIndex());
        builder.put(FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE.getFunctionName(), new StringLookupRange());
        builder.put(FunctionTemplate.StringMembers.SPLIT.getFunctionName(), new StringSplit());
        builder.put(FunctionTemplate.StringMembers.MATCHES.getFunctionName(), new StringMatches());
        builder.put(FunctionTemplate.StringMembers.TRIM.getFunctionName(), new StringTrim());
        builder.put(FunctionTemplate.StringMembers.UPPER.getFunctionName(), new StringUpper());
        builder.put(FunctionTemplate.StringMembers.LOWER.getFunctionName(), new StringLower());
    }

    private static Pattern compile(SourcePosition sourcePosition, String pattern) throws EvaluationException {
        try {
            return RegexValidator.validateAndCompile(pattern);
        }
        catch (IllegalArgumentException e) {
            throw new EvaluationException(sourcePosition, e.getMessage());
        }
    }

    @FunctionExpects
    private static class StringLower
    extends GuardedRuntimeFunction {
        public StringLower() {
            super(FunctionTemplate.StringMembers.LOWER, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String stringValue = request.getOperand().getStringValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)stringValue.toLowerCase()));
        }
    }

    @FunctionExpects
    private static class StringUpper
    extends GuardedRuntimeFunction {
        public StringUpper() {
            super(FunctionTemplate.StringMembers.UPPER, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String stringValue = request.getOperand().getStringValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)stringValue.toUpperCase()));
        }
    }

    @FunctionExpects
    private static class StringTrim
    extends GuardedRuntimeFunction {
        public StringTrim() {
            super(FunctionTemplate.StringMembers.TRIM, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String stringValue = request.getOperand().getStringValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)stringValue.trim()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class StringMatches
    extends GuardedRuntimeFunction {
        public StringMatches() {
            super(FunctionTemplate.StringMembers.MATCHES, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String stringValue = request.getOperand().getStringValue();
            String pattern = request.getArguments(0).getStringValue();
            Pattern regex = StringType.compile(request.getSourcePosition(), pattern);
            boolean matches = regex.matches(stringValue);
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(matches));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class StringSplit
    extends GuardedRuntimeFunction {
        public StringSplit() {
            super(FunctionTemplate.StringMembers.SPLIT, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String stringValue = request.getOperand().getStringValue();
            String pattern = request.getArguments(0).getStringValue();
            Pattern regex = StringType.compile(request.getSourcePosition(), pattern);
            ExpressionListValue.Builder expressionListValue = ExpressionListValue.newBuilder();
            for (String part : regex.split(stringValue)) {
                expressionListValue.addValues(ExpressionValueUtils.createValue((Object)part));
            }
            return ExpressionValueUtils.createResponse(ExpressionValue.newBuilder().setListValue(expressionListValue).build());
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class StringRangeIntInt
    extends StringRange {
        private StringRangeIntInt() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.NULL})
    private static class StringRangeIntNull
    extends StringRange {
        private StringRangeIntNull() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL, FunctionExpects.ExpectedExpressionKind.INT})
    private static class StringRangeNullInt
    extends StringRange {
        private StringRangeNullInt() {
        }
    }

    private static abstract class StringRange
    implements RuntimeFunction {
        private StringRange() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            String stringValue = request.getOperand().getStringValue();
            int stringLength = stringValue.length();
            ExpressionValue rangeStart = request.getArguments(0);
            ExpressionValue rangeEnd = request.getArguments(1);
            int fromIndex = RangeCheckUtils.getFromIndex(request, rangeStart, stringLength);
            int toIndex = RangeCheckUtils.getToIndex(request, rangeEnd, stringLength);
            RangeCheckUtils.checkRange(request, fromIndex, stringLength);
            RangeCheckUtils.checkRange(request, toIndex - 1, stringLength);
            if (toIndex < fromIndex) {
                throw EvaluationException.makeIllegalRangeError(request.getSourcePosition(), fromIndex, toIndex);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)stringValue.substring(fromIndex, toIndex)));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL, FunctionExpects.ExpectedExpressionKind.NULL})
    private static class StringReference
    implements RuntimeFunction {
        private StringReference() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(request.getOperand());
        }
    }

    private static class StringLookupRange
    extends OverloadedRuntimeFunction {
        public StringLookupRange() {
            super((FunctionTemplate)FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE, ExpressionValue.KindCase.STRING_VALUE, new StringReference(), new StringRangeNullInt(), new StringRangeIntNull(), new StringRangeIntInt());
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class CharAtIndex
    extends GuardedRuntimeFunction {
        public CharAtIndex() {
            super(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            int index;
            String stringValue = request.getOperand().getStringValue();
            ExpressionValue indexArg = request.getArguments(0);
            try {
                index = Math.toIntExact(indexArg.getIntValue());
            }
            catch (ArithmeticException e) {
                throw EvaluationException.makeIndexOutOfBoundError(request.getSourcePosition(), indexArg.getIntValue(), stringValue.length());
            }
            RangeCheckUtils.checkRange(request, index, stringValue.length());
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Character.toString(stringValue.charAt(index))));
        }
    }

    @FunctionExpects
    private static class StringSize
    extends GuardedRuntimeFunction {
        public StringSize() {
            super(FunctionTemplate.StringMembers.SIZE, ExpressionValue.KindCase.STRING_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getStringValue().length()));
        }
    }
}

