/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.units.TimestampUtil;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JodaTimeConversions;
import com.google.protobuf.util.Timestamps;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampType
extends AbstractTypeProvider {
    public TimestampType() {
        super(ExpressionValue.KindCase.TIMESTAMP_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.TimestampMembers.NANOS.getFunctionName(), new Nanos());
        builder.put(FunctionTemplate.TimestampMembers.SECONDS.getFunctionName(), new Seconds());
        builder.put(FunctionTemplate.TimestampMembers.MINUTES.getFunctionName(), new Minutes());
        builder.put(FunctionTemplate.TimestampMembers.HOURS.getFunctionName(), new Hours());
        builder.put(FunctionTemplate.TimestampMembers.DAY.getFunctionName(), new Day());
        builder.put(FunctionTemplate.TimestampMembers.MONTH.getFunctionName(), new Month());
        builder.put(FunctionTemplate.TimestampMembers.YEAR.getFunctionName(), new Year());
        builder.put(FunctionTemplate.TimestampMembers.DAY_OF_YEAR.getFunctionName(), new DayOfYear());
        builder.put(FunctionTemplate.TimestampMembers.DAY_OF_WEEK.getFunctionName(), new DayOfWeek());
        builder.put(FunctionTemplate.TimestampMembers.DATE.getFunctionName(), new ToDate());
        builder.put(FunctionTemplate.TimestampMembers.TO_MILLIS.getFunctionName(), new ToMillis());
        builder.put(FunctionTemplate.TimestampMembers.TIME.getFunctionName(), new Time());
    }

    private static DateTime toDateTime(Timestamp timestamp) {
        return JodaTimeConversions.toJodaInstant(timestamp).toDateTime(DateTimeZone.UTC);
    }

    @FunctionExpects
    public static class Time
    extends GuardedRuntimeFunction {
        public Time() {
            super(FunctionTemplate.TimestampMembers.TIME, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            Timestamp timestamp = request.getOperand().getTimestampValue();
            Timestamp startOfTheDay = TimestampUtil.beginningOfTheDay(timestamp);
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)Timestamps.between(startOfTheDay, timestamp)));
        }
    }

    @FunctionExpects
    public static class ToMillis
    extends GuardedRuntimeFunction {
        public ToMillis() {
            super(FunctionTemplate.TimestampMembers.TO_MILLIS, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            Timestamp timestamp = request.getOperand().getTimestampValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Timestamps.toMillis(timestamp)));
        }
    }

    @FunctionExpects
    public static class ToDate
    extends GuardedRuntimeFunction {
        public ToDate() {
            super(FunctionTemplate.TimestampMembers.DATE, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)TimestampUtil.beginningOfTheDay(request.getOperand().getTimestampValue())));
        }
    }

    @FunctionExpects
    public static class DayOfWeek
    extends GuardedRuntimeFunction {
        public DayOfWeek() {
            super(FunctionTemplate.TimestampMembers.DAY_OF_WEEK, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getDayOfWeek()));
        }
    }

    @FunctionExpects
    public static class DayOfYear
    extends GuardedRuntimeFunction {
        public DayOfYear() {
            super(FunctionTemplate.TimestampMembers.DAY_OF_YEAR, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getDayOfYear()));
        }
    }

    @FunctionExpects
    public static class Year
    extends GuardedRuntimeFunction {
        public Year() {
            super(FunctionTemplate.TimestampMembers.YEAR, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getYear()));
        }
    }

    @FunctionExpects
    public static class Month
    extends GuardedRuntimeFunction {
        public Month() {
            super(FunctionTemplate.TimestampMembers.MONTH, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getMonthOfYear()));
        }
    }

    @FunctionExpects
    public static class Day
    extends GuardedRuntimeFunction {
        public Day() {
            super(FunctionTemplate.TimestampMembers.DAY, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getDayOfMonth()));
        }
    }

    @FunctionExpects
    public static class Hours
    extends GuardedRuntimeFunction {
        public Hours() {
            super(FunctionTemplate.TimestampMembers.HOURS, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getHourOfDay()));
        }
    }

    @FunctionExpects
    public static class Minutes
    extends GuardedRuntimeFunction {
        public Minutes() {
            super(FunctionTemplate.TimestampMembers.MINUTES, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getMinuteOfHour()));
        }
    }

    @FunctionExpects
    public static class Seconds
    extends GuardedRuntimeFunction {
        public Seconds() {
            super(FunctionTemplate.TimestampMembers.SECONDS, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(TimestampType.toDateTime(request.getOperand().getTimestampValue()).getSecondOfMinute()));
        }
    }

    @FunctionExpects
    public static class Nanos
    extends GuardedRuntimeFunction {
        public Nanos() {
            super(FunctionTemplate.TimestampMembers.NANOS, ExpressionValue.KindCase.TIMESTAMP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getTimestampValue().getNanos()));
        }
    }
}

