/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;
import com.google.firebase.rules.v1.SourcePosition;

public class ConstraintValueUtils {
    public static void validate(SimpleConstraint constraint, SourcePosition sourcePosition) throws EvaluationException {
        if (!(constraint.getComparator() != SimpleConstraint.Comparator.GT && constraint.getComparator() != SimpleConstraint.Comparator.LT && constraint.getComparator() != SimpleConstraint.Comparator.GTE && constraint.getComparator() != SimpleConstraint.Comparator.LTE || ExpressionValueUtils.isOrderable(constraint.getValue()))) {
            throw EvaluationException.makeTypeError(sourcePosition, constraint.getValue().getKindCase(), KindCaseHelper.ORDERABLE_KIND_CASES);
        }
        if (!ExpressionValueUtils.isComparable(constraint.getValue())) {
            throw EvaluationException.makeTypeError(sourcePosition, constraint.getValue().getKindCase(), KindCaseHelper.COMPARABLE_KIND_CASES);
        }
    }

    public static ExpressionValue implies(ConstraintValue queryConstraint, SimpleConstraint rulesConstraint) throws EvaluationException {
        for (SimpleConstraint fromSimpleConstraint : queryConstraint.getSimpleConstraintsList()) {
            if (!ConstraintValueUtils.implies(fromSimpleConstraint, rulesConstraint)) continue;
            return ExpressionValueUtils.createValue(true);
        }
        return ExpressionValueUtils.UNSATISFIED_CONSTRAINT;
    }

    private static boolean implies(SimpleConstraint queryConstraint, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue queryValue = queryConstraint.getValue();
        SimpleConstraint.Comparator queryComparator = queryConstraint.getComparator();
        ExpressionValue rulesValue = rulesConstraint.getValue();
        if (ExpressionValueUtils.isNull(rulesValue) && rulesConstraint.getComparator() == SimpleConstraint.Comparator.NEQ) {
            return !ExpressionValueUtils.isNull(queryValue) || queryComparator != SimpleConstraint.Comparator.EQ;
        }
        if (queryValue.getKindCase() == ExpressionValue.KindCase.FLOAT_VALUE && rulesValue.getKindCase() == ExpressionValue.KindCase.INT_VALUE) {
            rulesValue = ExpressionValueUtils.createValue((double)rulesValue.getIntValue());
        }
        if (queryValue.getKindCase() == ExpressionValue.KindCase.INT_VALUE && rulesValue.getKindCase() == ExpressionValue.KindCase.FLOAT_VALUE) {
            queryValue = ExpressionValueUtils.createValue((double)queryValue.getIntValue());
        }
        if (!ExpressionValueUtils.comparable(queryValue, rulesValue)) {
            return false;
        }
        if (queryValue.getKindCase() == ExpressionValue.KindCase.FLOAT_VALUE) {
            if (Double.isNaN(queryValue.getFloatValue())) {
                if (queryComparator == SimpleConstraint.Comparator.NEQ) {
                    return rulesConstraint.getComparator() == SimpleConstraint.Comparator.NEQ && Double.isNaN(rulesValue.getFloatValue());
                }
                return true;
            }
            if (Double.isNaN(rulesValue.getFloatValue())) {
                if (rulesConstraint.getComparator() == SimpleConstraint.Comparator.NEQ) {
                    return true;
                }
                return queryConstraint.getComparator() == SimpleConstraint.Comparator.GT && queryConstraint.getValue().getFloatValue() == Double.POSITIVE_INFINITY || queryConstraint.getComparator() == SimpleConstraint.Comparator.LT && queryConstraint.getValue().getFloatValue() == Double.NEGATIVE_INFINITY;
            }
        }
        switch (queryComparator) {
            case EQ: {
                return ConstraintValueUtils.impliedByEquals(queryValue, rulesConstraint);
            }
            case NEQ: {
                return ConstraintValueUtils.impliedByNotEquals(queryValue, rulesConstraint);
            }
            case GT: {
                return ConstraintValueUtils.impliedByGreaterThan(queryValue, rulesConstraint);
            }
            case GTE: {
                return ConstraintValueUtils.impliedByGreaterThanOrEquals(queryValue, rulesConstraint);
            }
            case LT: {
                return ConstraintValueUtils.impliedByLessThan(queryValue, rulesConstraint);
            }
            case LTE: {
                return ConstraintValueUtils.impliedByLessThanOrEquals(queryValue, rulesConstraint);
            }
            case LIST_CONTAINS: {
                return ConstraintValueUtils.impliedByContains(queryValue, rulesConstraint);
            }
        }
        String string = String.valueOf(queryComparator);
        throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Invalid comparator ").append(string).toString());
    }

    private static boolean impliedByContains(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        switch (rulesConstraint.getComparator()) {
            case LIST_CONTAINS: {
                return ExpressionValueUtils.equal(queryValue, rulesConstraint.getValue());
            }
        }
        return false;
    }

    private static boolean impliedByLessThanOrEquals(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue rulesValue = rulesConstraint.getValue();
        switch (rulesConstraint.getComparator()) {
            case NEQ: {
                return ExpressionValueUtils.lessThan(queryValue, rulesValue);
            }
            case LT: {
                return ExpressionValueUtils.lessThan(queryValue, rulesValue);
            }
            case LTE: {
                return ExpressionValueUtils.lessThanOrEquals(queryValue, rulesValue);
            }
        }
        return false;
    }

    private static boolean impliedByLessThan(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue rulesValue = rulesConstraint.getValue();
        switch (rulesConstraint.getComparator()) {
            case NEQ: {
                return ExpressionValueUtils.lessThanOrEquals(queryValue, rulesValue);
            }
            case LT: {
                return ExpressionValueUtils.lessThanOrEquals(queryValue, rulesValue);
            }
            case LTE: {
                return ExpressionValueUtils.lessThanOrEquals(queryValue, rulesValue);
            }
        }
        return false;
    }

    private static boolean impliedByGreaterThanOrEquals(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue rulesValue = rulesConstraint.getValue();
        switch (rulesConstraint.getComparator()) {
            case NEQ: {
                return ExpressionValueUtils.greaterThan(queryValue, rulesValue);
            }
            case GT: {
                return ExpressionValueUtils.greaterThan(queryValue, rulesValue);
            }
            case GTE: {
                return ExpressionValueUtils.greaterThanOrEquals(queryValue, rulesValue);
            }
        }
        return false;
    }

    private static boolean impliedByGreaterThan(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue rulesValue = rulesConstraint.getValue();
        switch (rulesConstraint.getComparator()) {
            case NEQ: {
                return ExpressionValueUtils.greaterThanOrEquals(queryValue, rulesValue);
            }
            case GT: {
                return ExpressionValueUtils.greaterThanOrEquals(queryValue, rulesValue);
            }
            case GTE: {
                return ExpressionValueUtils.greaterThanOrEquals(queryValue, rulesValue);
            }
        }
        return false;
    }

    private static boolean impliedByNotEquals(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue rulesValue = rulesConstraint.getValue();
        switch (rulesConstraint.getComparator()) {
            case NEQ: {
                return ExpressionValueUtils.equal(queryValue, rulesValue);
            }
        }
        return false;
    }

    private static boolean impliedByEquals(ExpressionValue queryValue, SimpleConstraint rulesConstraint) throws EvaluationException {
        ExpressionValue rulesValue = rulesConstraint.getValue();
        switch (rulesConstraint.getComparator()) {
            case EQ: {
                return ExpressionValueUtils.equal(queryValue, rulesValue);
            }
            case NEQ: {
                return !ExpressionValueUtils.equal(queryValue, rulesValue);
            }
            case GT: {
                return ExpressionValueUtils.greaterThan(queryValue, rulesValue);
            }
            case GTE: {
                return ExpressionValueUtils.greaterThanOrEquals(queryValue, rulesValue);
            }
            case LT: {
                return ExpressionValueUtils.lessThan(queryValue, rulesValue);
            }
            case LTE: {
                return ExpressionValueUtils.lessThanOrEquals(queryValue, rulesValue);
            }
        }
        return false;
    }

    private ConstraintValueUtils() {
    }
}

