/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.JsonUtils;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;
import com.google.firebase.rules.runtime.v1.Undefined;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.gson.JsonElement;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.google.type.LatLng;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ExpressionValueUtils {
    public static final ExpressionValue UNSATISFIED_CONSTRAINT = ExpressionValue.newBuilder().setUndefined(Undefined.getDefaultInstance()).build();
    public static final ExpressionValue NULL = ExpressionValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    public static final ExpressionValue TRUE = ExpressionValue.newBuilder().setBoolValue(true).build();
    public static final ExpressionValue FALSE = ExpressionValue.newBuilder().setBoolValue(false).build();

    public static ExpressionValue createValue(long value) {
        if (value >= -128L && value <= 127L) {
            return IntegerCache.cache[(int)(value + 128L)];
        }
        return ExpressionValue.newBuilder().setIntValue(value).build();
    }

    public static ExpressionValue createValue(double value) {
        return ExpressionValue.newBuilder().setFloatValue(value).build();
    }

    public static ExpressionValue createValue(boolean value) {
        return value ? TRUE : FALSE;
    }

    private static ExpressionValue createValue(String value) {
        return ExpressionValue.newBuilder().setStringValue(value).build();
    }

    private static ExpressionValue createValue(ByteString value) {
        return ExpressionValue.newBuilder().setBytesValue(value).build();
    }

    private static ExpressionValue createValue(Duration value) {
        return ExpressionValue.newBuilder().setDurationValue(value).build();
    }

    private static ExpressionValue createValue(LatLng value) {
        return ExpressionValue.newBuilder().setLatlngValue(value).build();
    }

    private static ExpressionValue createValue(Timestamp value) {
        return ExpressionValue.newBuilder().setTimestampValue(value).build();
    }

    private static ExpressionValue createValue(List<?> values) {
        ExpressionListValue.Builder listBuilder = ExpressionListValue.newBuilder();
        for (Object value : values) {
            listBuilder.addValues(ExpressionValueUtils.createValue(value));
        }
        return ExpressionValue.newBuilder().setListValue(listBuilder).build();
    }

    private static ExpressionValue createValue(Map<?, ?> valueMap) {
        HashMap<String, ExpressionValue> exprValueMap = Maps.newHashMap();
        for (Map.Entry<?, ?> value : valueMap.entrySet()) {
            Object key = value.getKey();
            if (key != null) {
                key = key.toString();
            }
            exprValueMap.put((String)key, ExpressionValueUtils.createValue(value.getValue()));
        }
        ExpressionMapValue.Builder mapBuilder = ExpressionMapValue.newBuilder();
        mapBuilder.putAllFields(exprValueMap);
        return ExpressionValue.newBuilder().setMapValue(mapBuilder).build();
    }

    private static ExpressionValue createValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return ExpressionValueUtils.createValue(value.getBoolValue());
            }
            case LIST_VALUE: {
                return ExpressionValueUtils.createValue(value.getListValue());
            }
            case NUMBER_VALUE: {
                boolean isIntLike;
                boolean bl = isIntLike = value.getNumberValue() == (double)((long)value.getNumberValue());
                if (isIntLike) {
                    return ExpressionValueUtils.createValue((long)value.getNumberValue());
                }
                return ExpressionValueUtils.createValue(value.getNumberValue());
            }
            case STRING_VALUE: {
                return ExpressionValueUtils.createValue(value.getStringValue());
            }
            case STRUCT_VALUE: {
                return ExpressionValueUtils.createValue(value.getStructValue());
            }
            case NULL_VALUE: {
                return NULL;
            }
        }
        throw new IllegalArgumentException("Parameter 'value' cannot be converted to an ExpressionValue.");
    }

    private static ExpressionValue createValue(ListValue value) {
        return ExpressionValueUtils.createValue(value.getValuesList());
    }

    private static ExpressionValue createValue(Struct value) {
        return ExpressionValueUtils.createValue(value.getFieldsMap());
    }

    public static ExpressionValue createValue(Object value) {
        if (value instanceof ExpressionValue) {
            return (ExpressionValue)value;
        }
        if (value instanceof Double || value instanceof Float) {
            return ExpressionValueUtils.createValue(((Number)value).doubleValue());
        }
        if (value instanceof Number) {
            return ExpressionValueUtils.createValue(((Number)value).longValue());
        }
        if (value instanceof CharSequence) {
            return ExpressionValueUtils.createValue(value.toString());
        }
        if (value instanceof ByteString) {
            return ExpressionValueUtils.createValue((ByteString)value);
        }
        if (value instanceof Boolean) {
            return ExpressionValueUtils.createValue((Boolean)value);
        }
        if (value instanceof Duration) {
            return ExpressionValueUtils.createValue((Duration)value);
        }
        if (value instanceof Timestamp) {
            return ExpressionValueUtils.createValue((Timestamp)value);
        }
        if (value instanceof LatLng) {
            return ExpressionValueUtils.createValue((LatLng)value);
        }
        if (value instanceof ExpressionListValue) {
            return ExpressionValue.newBuilder().setListValue((ExpressionListValue)value).build();
        }
        if (value instanceof ExpressionPathValue) {
            return ExpressionValue.newBuilder().setPathValue((ExpressionPathValue)value).build();
        }
        if (value instanceof ExpressionMapValue) {
            return ExpressionValue.newBuilder().setMapValue((ExpressionMapValue)value).build();
        }
        if (value instanceof List) {
            return ExpressionValueUtils.createValue((List)value);
        }
        if (value instanceof Map) {
            return ExpressionValueUtils.createValue((Map)value);
        }
        if (value instanceof Value) {
            return ExpressionValueUtils.createValue((Value)value);
        }
        if (value instanceof ListValue) {
            return ExpressionValueUtils.createValue((ListValue)value);
        }
        if (value instanceof Struct) {
            return ExpressionValueUtils.createValue((Struct)value);
        }
        if (value instanceof ConstraintValue) {
            return ExpressionValue.newBuilder().setConstraintValue((ConstraintValue)value).build();
        }
        if (value == null || value instanceof NullValue) {
            return NULL;
        }
        if (value instanceof JsonElement) {
            return JsonUtils.getExpressionValue((JsonElement)value);
        }
        throw new IllegalArgumentException(String.format("Parameter '%s' cannot be converted to an ExpressionValue.", value));
    }

    public static ExecutionResponse createResponse(ExpressionValue value) {
        return ExecutionResponse.newBuilder().setValue(value).build();
    }

    public static boolean comparable(ExpressionValue value, ExpressionValue otherValue) {
        return KindCaseHelper.COMPARABLE_KIND_CASES.contains(value.getKindCase()) && value.getKindCase() == otherValue.getKindCase();
    }

    public static boolean isOrderable(ExpressionValue value) {
        return KindCaseHelper.ORDERABLE_KIND_CASES.contains(value.getKindCase());
    }

    public static boolean isComparable(ExpressionValue value) {
        return KindCaseHelper.COMPARABLE_KIND_CASES.contains(value.getKindCase());
    }

    public static boolean equal(ExpressionValue value, ExpressionValue otherValue) throws EvaluationException {
        return ExpressionValueUtils.comparable(value, otherValue) && ExpressionValueUtils.compare(value, otherValue);
    }

    public static boolean greaterThan(ExpressionValue value, ExpressionValue otherValue) throws EvaluationException {
        return ExpressionValueUtils.orderCompare(value, otherValue, OrderOp.GT);
    }

    public static boolean greaterThanOrEquals(ExpressionValue value, ExpressionValue otherValue) throws EvaluationException {
        return ExpressionValueUtils.orderCompare(value, otherValue, OrderOp.GTE);
    }

    public static boolean lessThan(ExpressionValue value, ExpressionValue otherValue) throws EvaluationException {
        return ExpressionValueUtils.orderCompare(value, otherValue, OrderOp.LT);
    }

    public static boolean lessThanOrEquals(ExpressionValue value, ExpressionValue otherValue) throws EvaluationException {
        return ExpressionValueUtils.orderCompare(value, otherValue, OrderOp.LTE);
    }

    private static boolean orderCompare(ExpressionValue value, ExpressionValue otherValue, OrderOp orderOp) throws EvaluationException {
        int cmp;
        ExpressionValue.KindCase valueKind = value.getKindCase();
        ExpressionValue.KindCase otherKind = otherValue.getKindCase();
        if (valueKind == ExpressionValue.KindCase.UNDEFINED) {
            throw ExpressionValueUtils.propagateUndefined(value);
        }
        if (otherKind == ExpressionValue.KindCase.UNDEFINED) {
            throw ExpressionValueUtils.propagateUndefined(otherValue);
        }
        if (!ExpressionValueUtils.comparable(value, otherValue) || !ExpressionValueUtils.isOrderable(value)) {
            return false;
        }
        switch (value.getKindCase()) {
            case DURATION_VALUE: {
                cmp = Durations.comparator().compare(value.getDurationValue(), otherValue.getDurationValue());
                break;
            }
            case INT_VALUE: {
                cmp = Long.compare(value.getIntValue(), otherValue.getIntValue());
                break;
            }
            case STRING_VALUE: {
                cmp = value.getStringValue().compareTo(otherValue.getStringValue());
                break;
            }
            case BYTES_VALUE: {
                cmp = ByteString.unsignedLexicographicalComparator().compare(value.getBytesValue(), otherValue.getBytesValue());
                break;
            }
            case TIMESTAMP_VALUE: {
                cmp = Timestamps.comparator().compare(value.getTimestampValue(), otherValue.getTimestampValue());
                break;
            }
            case FLOAT_VALUE: {
                double float1 = value.getFloatValue();
                double float2 = otherValue.getFloatValue();
                switch (orderOp) {
                    case GT: {
                        return float1 > float2;
                    }
                    case GTE: {
                        return float1 >= float2;
                    }
                    case LT: {
                        return float1 < float2;
                    }
                    case LTE: {
                        return float1 <= float2;
                    }
                }
                return value.getFloatValue() > otherValue.getFloatValue();
            }
            default: {
                String string = String.valueOf(value);
                String string2 = String.valueOf(otherValue);
                throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot compare ").append(string).append(" to ").append(string2).toString());
            }
        }
        switch (orderOp) {
            case GT: {
                return cmp > 0;
            }
            case GTE: {
                return cmp >= 0;
            }
            case LT: {
                return cmp < 0;
            }
            case LTE: {
                return cmp <= 0;
            }
        }
        String string = String.valueOf((Object)orderOp);
        throw new IllegalArgumentException(new StringBuilder(14 + String.valueOf(string).length()).append("Invalid order ").append(string).toString());
    }

    @VisibleForTesting
    static boolean compare(ExpressionValue value, ExpressionValue otherValue) throws EvaluationException {
        ExpressionValue.KindCase valueKind = value.getKindCase();
        ExpressionValue.KindCase otherKind = otherValue.getKindCase();
        if (valueKind == ExpressionValue.KindCase.UNDEFINED) {
            throw ExpressionValueUtils.propagateUndefined(value);
        }
        if (otherKind == ExpressionValue.KindCase.UNDEFINED) {
            throw ExpressionValueUtils.propagateUndefined(otherValue);
        }
        switch (valueKind) {
            case FLOAT_VALUE: {
                return value.getFloatValue() == otherValue.getFloatValue();
            }
            case NULL_VALUE: {
                return true;
            }
            case STRING_VALUE: {
                return value.getStringValue().equals(otherValue.getStringValue());
            }
            case BYTES_VALUE: {
                return value.getBytesValue().equals(otherValue.getBytesValue());
            }
            case BOOL_VALUE: {
                return value.getBoolValue() == otherValue.getBoolValue();
            }
            case INT_VALUE: {
                return value.getIntValue() == otherValue.getIntValue();
            }
            case DURATION_VALUE: 
            case TIMESTAMP_VALUE: 
            case LATLNG_VALUE: {
                return value.equals(otherValue);
            }
            case LIST_VALUE: {
                ExpressionValueUtils.assertDefined(value.getListValue().getValuesList());
                ExpressionValueUtils.assertDefined(otherValue.getListValue().getValuesList());
                return !ExpressionValueUtils.hasNaN(value.getListValue().getValuesList()) && value.equals(otherValue);
            }
            case MAP_VALUE: {
                ExpressionValueUtils.assertDefined(value.getMapValue().getFieldsMap().values());
                ExpressionValueUtils.assertDefined(otherValue.getMapValue().getFieldsMap().values());
                return !ExpressionValueUtils.hasNaN(otherValue.getMapValue().getFieldsMap().values()) && value.equals(otherValue);
            }
            case PATH_VALUE: {
                return ExpressionValueUtils.comparePaths(value.getPathValue(), otherValue.getPathValue());
            }
        }
        String string = String.valueOf(value);
        String string2 = String.valueOf(otherValue);
        throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot compare ").append(string).append(" and ").append(string2).toString());
    }

    public static <T> ExpressionValue transformList(List<T> list, Function<T, ExpressionValue> transformer) {
        ExpressionListValue.Builder listValueBuilder = ExpressionListValue.newBuilder();
        listValueBuilder.addAllValues(Iterables.transform(list, transformer));
        return ExpressionValue.newBuilder().setListValue(listValueBuilder).build();
    }

    public static Object getObjectValue(ExpressionValue value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case DURATION_VALUE: {
                return value.getDurationValue();
            }
            case FLOAT_VALUE: {
                return value.getFloatValue();
            }
            case INT_VALUE: {
                return value.getIntValue();
            }
            case LATLNG_VALUE: {
                return value.getLatlngValue();
            }
            case LIST_VALUE: {
                return value.getListValue();
            }
            case MAP_VALUE: {
                return value.getMapValue();
            }
            case NULL_VALUE: {
                return null;
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BYTES_VALUE: {
                return value.getBytesValue();
            }
            case TIMESTAMP_VALUE: {
                return value.getTimestampValue();
            }
        }
        return value;
    }

    public static boolean isNull(ExpressionValue value) {
        return value == null || value.getKindCase() == ExpressionValue.KindCase.NULL_VALUE;
    }

    public static boolean isFloat(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.FLOAT_VALUE;
    }

    public static boolean isInt(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.INT_VALUE;
    }

    public static boolean isList(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.LIST_VALUE;
    }

    public static boolean isPath(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.PATH_VALUE;
    }

    public static boolean isMap(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.MAP_VALUE;
    }

    public static boolean isConstraint(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.CONSTRAINT_VALUE;
    }

    public static boolean isString(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.STRING_VALUE;
    }

    public static boolean isBytes(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.BYTES_VALUE;
    }

    public static boolean isBool(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.BOOL_VALUE;
    }

    public static boolean isUndefined(ExpressionValue value) {
        return value.getKindCase() == ExpressionValue.KindCase.UNDEFINED;
    }

    public static EvaluationException propagateUndefined(ExpressionValue value) {
        return ExpressionValueUtils.propagateUndefined(value, null);
    }

    public static EvaluationException propagateUndefined(ExpressionValue value, @Nullable Throwable cause) {
        Preconditions.checkArgument(ExpressionValueUtils.isUndefined(value));
        Undefined undefined = value.getUndefined();
        return new EvaluationException(undefined.getSourcePosition(), undefined.getCauseMessage(), cause);
    }

    public static SimpleConstraint makeSimpleConstraint(SimpleConstraint.Comparator comparator, ExpressionValue expressionValue, SourcePosition sourcePosition) throws EvaluationException {
        SimpleConstraint simpleConstraint = SimpleConstraint.newBuilder().setComparator(comparator).setValue(expressionValue).build();
        ConstraintValueUtils.validate(simpleConstraint, sourcePosition);
        return simpleConstraint;
    }

    private static void assertDefined(Collection<ExpressionValue> values) throws EvaluationException {
        for (ExpressionValue value : values) {
            if (value.getKindCase() == ExpressionValue.KindCase.UNDEFINED) {
                throw ExpressionValueUtils.propagateUndefined(value);
            }
            if (value.getKindCase() == ExpressionValue.KindCase.LIST_VALUE) {
                ExpressionValueUtils.assertDefined(value.getListValue().getValuesList());
                continue;
            }
            if (value.getKindCase() != ExpressionValue.KindCase.MAP_VALUE) continue;
            ExpressionValueUtils.assertDefined(value.getMapValue().getFieldsMap().values());
        }
    }

    private static boolean hasNaN(Collection<ExpressionValue> values) throws EvaluationException {
        for (ExpressionValue value : values) {
            if (!(value.getKindCase() == ExpressionValue.KindCase.FLOAT_VALUE ? Double.isNaN(value.getFloatValue()) : (value.getKindCase() == ExpressionValue.KindCase.LIST_VALUE ? ExpressionValueUtils.hasNaN(value.getListValue().getValuesList()) : value.getKindCase() == ExpressionValue.KindCase.MAP_VALUE && ExpressionValueUtils.hasNaN(value.getMapValue().getFieldsMap().values())))) continue;
            return true;
        }
        return false;
    }

    static boolean comparePaths(ExpressionPathValue pathValue1, ExpressionPathValue pathValue2) {
        try {
            return ExpressionValueUtils.getPathSegments(SourcePosition.getDefaultInstance(), pathValue1).equals(ExpressionValueUtils.getPathSegments(SourcePosition.getDefaultInstance(), pathValue2));
        }
        catch (EvaluationException e) {
            return false;
        }
    }

    public static ImmutableList<String> getPathSegments(SourcePosition sourcePosition, ExpressionPathValue pathValue) throws EvaluationException {
        ImmutableList.Builder segments = ImmutableList.builder();
        block5: for (ExpressionPathSegmentValue segmentValue : pathValue.getSegmentsList()) {
            switch (segmentValue.getKindCase()) {
                case SIMPLE: {
                    segments.add(segmentValue.getSimple());
                    continue block5;
                }
                case CAPTURE: {
                    ExpressionPathSegmentValue.Capture capture = segmentValue.getCapture();
                    if (Strings.isNullOrEmpty(capture.getBoundValue())) {
                        throw EvaluationException.makeUnboundVariableError(sourcePosition, capture.getVariableName());
                    }
                    segments.add(capture.getBoundValue());
                    continue block5;
                }
                case GLOB_CAPTURE: {
                    ExpressionPathSegmentValue.GlobCapture globCapture = segmentValue.getGlobCapture();
                    if (!globCapture.hasBoundValue()) {
                        throw EvaluationException.makeUnboundVariableError(sourcePosition, globCapture.getVariableName());
                    }
                    segments.addAll(ExpressionValueUtils.getPathSegments(sourcePosition, globCapture.getBoundValue()));
                    continue block5;
                }
            }
            String string = String.valueOf(segmentValue.getKindCase());
            throw new RuntimeException(new StringBuilder(31 + String.valueOf(string).length()).append("Unknown path template segment: ").append(string).toString());
        }
        return segments.build();
    }

    public static ExpressionValue segmentsToPathExpressions(Iterable<String> segments) {
        ExpressionPathValue.Builder builder = ExpressionPathValue.newBuilder();
        for (String segment : segments) {
            builder.addSegments(ExpressionPathSegmentValue.newBuilder().setSimple(segment));
        }
        return ExpressionValue.newBuilder().setPathValue(builder).build();
    }

    public static ExecutionRequest swapArguments(ExecutionRequest executionRequest) {
        Preconditions.checkArgument(executionRequest.getArgumentsCount() == 2);
        return executionRequest.toBuilder().clearArguments().addArguments(executionRequest.getArguments(1)).addArguments(executionRequest.getArguments(0)).build();
    }

    private ExpressionValueUtils() {
    }

    private static enum OrderOp {
        GT,
        GTE,
        LT,
        LTE;

    }

    private static class IntegerCache {
        static final int LOW = -128;
        static final int HIGH = 127;
        static final ExpressionValue[] cache = new ExpressionValue[256];

        private IntegerCache() {
        }

        static {
            int j = -128;
            for (int k = 0; k < cache.length; ++k) {
                IntegerCache.cache[k] = ExpressionValue.newBuilder().setIntValue(j++).build();
            }
        }
    }
}

