/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.common.base.Pair;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public final class ListView<T>
extends AbstractList<T> {
    private final ImmutableList<T> underlying;

    private ListView(ImmutableList<T> underlying) {
        this.underlying = underlying;
    }

    public static <T> ListView<T> empty() {
        return new ListView(ImmutableList.of());
    }

    public static <T> ListView<T> of(List<T> elements) {
        return new ListView<T>(ImmutableList.copyOf(elements));
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public T get(int i) {
        return (T)this.underlying.get(i);
    }

    @Override
    public Iterator<T> iterator() {
        return this.underlying.iterator();
    }

    public T head() {
        return (T)this.underlying.get(0);
    }

    public ListView<T> slice(int start, int end) {
        return new ListView<T>(this.underlying.subList(start, end));
    }

    public ListView<T> tail() {
        return this.slice(1, this.size());
    }

    public ListView<T> take(int count) {
        return this.slice(0, count);
    }

    public ListView<T> drop(int count) {
        return this.slice(count, this.size());
    }

    public Pair<ListView<T>, ListView<T>> splitAt(Predicate<T> predicate) {
        int idx = Iterables.indexOf(this.underlying, predicate);
        if (idx < 0) {
            idx = this.size();
        }
        return Pair.of(this.take(idx), this.drop(idx));
    }
}

