/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.firebase.rules.lang.common.UrlEncoder;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import javax.annotation.Nullable;

public class PathUtils {
    public static final String SLASH = "/";
    private static final String CAPTURE_PATTERN = "*";
    private static final String GLOB_PATTERN = "**";
    private static final ExpressionPathSegmentValue CAPTURE = ExpressionPathSegmentValue.newBuilder().setCapture(ExpressionPathSegmentValue.Capture.newBuilder()).build();
    private static final ExpressionPathSegmentValue GLOB = ExpressionPathSegmentValue.newBuilder().setGlobCapture(ExpressionPathSegmentValue.GlobCapture.newBuilder()).build();
    private static final TransformPathSegment TRANSFORM_SEGMENT = new TransformPathSegment();
    private static final Splitter SEGMENT_SPLITTER = Splitter.on('/');
    private static final Joiner SEGMENT_JOINER = Joiner.on('/');

    @VisibleForTesting
    public static ExpressionPathValue parseForTesting(String pathString) {
        pathString = PathUtils.sanitizePath(pathString);
        Builder builder = new Builder();
        block10: for (String segment : SEGMENT_SPLITTER.split(pathString)) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(segment), "Path segment cannot be empty");
            switch (segment) {
                case "*": {
                    builder.appendCapture();
                    continue block10;
                }
                case "**": {
                    builder.appendGlob();
                    continue block10;
                }
            }
            try {
                builder.appendSegment(UrlEncoder.decode(segment));
            }
            catch (UrlEncoder.UrlDecodingException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return builder.build();
    }

    public static ExpressionPathValue parse(String pathString) {
        pathString = PathUtils.sanitizePath(Preconditions.checkNotNull(pathString));
        Builder builder = new Builder();
        for (String pathSegment : SEGMENT_SPLITTER.split(pathString)) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(pathSegment), "Path segment cannot be empty");
            try {
                builder.appendSegment(UrlEncoder.decode(pathSegment));
            }
            catch (UrlEncoder.UrlDecodingException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return builder.build();
    }

    @Nullable
    public static String toString(@Nullable ExpressionPathValue path) {
        if (path == null) {
            return null;
        }
        String string = String.valueOf(SLASH);
        String string2 = String.valueOf(SEGMENT_JOINER.join(Iterables.transform(path.getSegmentsList(), TRANSFORM_SEGMENT)));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @Nullable
    public static String toString(@Nullable ExpressionPathSegmentValue segmentValue) {
        if (segmentValue == null) {
            return null;
        }
        switch (segmentValue.getKindCase()) {
            case SIMPLE: {
                return UrlEncoder.encode(segmentValue.getSimple());
            }
            case CAPTURE: {
                return CAPTURE_PATTERN;
            }
            case GLOB_CAPTURE: {
                return GLOB_PATTERN;
            }
        }
        return null;
    }

    public static Builder pathBuilder() {
        return new Builder();
    }

    private static String sanitizePath(String pathString) {
        if (pathString.startsWith(SLASH)) {
            pathString = pathString.substring(SLASH.length());
        }
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pathString), "Path cannot be empty");
        return pathString;
    }

    private static class TransformPathSegment
    implements Function<ExpressionPathSegmentValue, String> {
        private TransformPathSegment() {
        }

        @Override
        @Nullable
        public String apply(@Nullable ExpressionPathSegmentValue segmentValue) {
            return PathUtils.toString(segmentValue);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<ExpressionPathSegmentValue> parts = ImmutableList.builder();
        private boolean globAdded;

        private Builder() {
        }

        public Builder appendCapture() {
            this.parts.add((Object)CAPTURE);
            return this;
        }

        public Builder appendGlob() {
            this.checkContainsGlobSegment();
            this.globAdded = true;
            this.parts.add((Object)GLOB);
            return this;
        }

        public Builder appendSegment(String part) {
            this.parts.add((Object)ExpressionPathSegmentValue.newBuilder().setSimple(part).build());
            return this;
        }

        private void checkContainsGlobSegment() {
            Preconditions.checkArgument(!this.globAdded, "Cannot add a path segment after a glob (**) match.");
        }

        public ExpressionPathValue build() {
            return ExpressionPathValue.newBuilder().addAllSegments(this.parts.build()).build();
        }
    }
}

