/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.units;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.firebase.rules.units.UnitConverter;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.concurrent.TimeUnit;

public class DurationUnitConverter
implements UnitConverter<Duration> {
    @Override
    public boolean matches(String suffix) {
        return Unit.find(suffix) != null;
    }

    @Override
    public Duration convert(long value, String suffix) {
        Unit unit = Preconditions.checkNotNull(Unit.find(suffix));
        return unit.makeDuration(value);
    }

    private static enum Unit {
        WEEK("w", TimeUnit.DAYS.toSeconds(1L) * 7L, 0),
        DAY("d", TimeUnit.DAYS.toSeconds(1L), 0),
        HOUR("h", TimeUnit.HOURS.toSeconds(1L), 0),
        MINUTE("m", TimeUnit.MINUTES.toSeconds(1L), 0),
        SECOND("s", 1L, 0),
        MILLIS("ms", 0L, 1000000),
        NANOS("ns", 0L, 1);

        private final int nanoSecondsMultiplier;
        private final long secondsMultiplier;
        private final String suffix;

        private Unit(String suffix, long secondsMultiplier, int nanoSecondsMultiplier) {
            this.suffix = suffix;
            Preconditions.checkArgument(nanoSecondsMultiplier != 0 ^ secondsMultiplier != 0L, "nanoSecondsMultiplier and secondsMultiplier are mutually exclusive.");
            this.secondsMultiplier = secondsMultiplier;
            this.nanoSecondsMultiplier = nanoSecondsMultiplier;
        }

        Duration makeDuration(long value) {
            if (this.nanoSecondsMultiplier != 0) {
                return Durations.fromNanos(LongMath.checkedMultiply(value, this.nanoSecondsMultiplier));
            }
            Duration duration = Duration.newBuilder().setSeconds(LongMath.checkedMultiply(value, this.secondsMultiplier)).build();
            Preconditions.checkArgument(Durations.isValid(duration), "Invalid duration");
            return duration;
        }

        private static Unit find(String suffix) {
            for (Unit unit : Unit.values()) {
                if (!unit.suffix.equals(suffix)) continue;
                return unit;
            }
            return null;
        }
    }
}

