/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.units;

import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.concurrent.TimeUnit;

public final class DurationUtil {
    private DurationUtil() {
    }

    public static Duration negate(Duration duration) {
        Preconditions.checkArgument(Durations.isValid(duration));
        return Duration.newBuilder().setSeconds(-duration.getSeconds()).setNanos(-duration.getNanos()).build();
    }

    public static Duration abs(Duration duration) {
        Preconditions.checkArgument(Durations.isValid(duration));
        if (duration.getSeconds() > 0L) {
            return duration;
        }
        if (duration.getSeconds() < 0L) {
            return DurationUtil.negate(duration);
        }
        if (duration.getNanos() >= 0) {
            return duration;
        }
        return DurationUtil.negate(duration);
    }

    public static Duration makeDuration(long hours, long minutes, long seconds, long nanos) {
        Duration h = Durations.fromMillis(DurationUtil.checkedToMillis(hours, TimeUnit.HOURS));
        Duration m = Durations.fromMillis(DurationUtil.checkedToMillis(minutes, TimeUnit.MINUTES));
        Duration s = Durations.fromSeconds(seconds);
        Duration n = Durations.fromNanos(nanos);
        return Durations.add(Durations.add(h, m), Durations.add(s, n));
    }

    private static long checkedToMillis(long value, TimeUnit timeUnit) {
        long l = timeUnit.toMillis(value);
        if (l == Long.MIN_VALUE || l == Long.MAX_VALUE) {
            throw new ArithmeticException("Overflow");
        }
        return l;
    }
}

