/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.units;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.concurrent.TimeUnit;

public class TimestampUtil {
    private static final long ONE_DAY_IN_SECONDS = TimeUnit.DAYS.toSeconds(1L);

    private TimestampUtil() {
    }

    public static boolean isValidYear(long year) {
        return year >= 1L && year <= 9999L;
    }

    public static Timestamp beginningOfTheDay(Timestamp timestamp) {
        long seconds;
        Timestamps.checkValid(timestamp);
        if (timestamp.getSeconds() % ONE_DAY_IN_SECONDS == 0L) {
            seconds = timestamp.getSeconds();
            if (timestamp.getNanos() > 0 && timestamp.getSeconds() < 0L) {
                seconds += ONE_DAY_IN_SECONDS;
            }
        } else {
            seconds = timestamp.getSeconds() / ONE_DAY_IN_SECONDS * ONE_DAY_IN_SECONDS;
            if (timestamp.getSeconds() < 0L) {
                seconds -= ONE_DAY_IN_SECONDS;
            }
        }
        return Timestamp.newBuilder().setSeconds(seconds).build();
    }
}

