/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.utils;

import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.Map;

public class ProtoUtils {
    private ProtoUtils() {
    }

    public static Value makeProtoValue(Object input) {
        Value.Builder value = Value.newBuilder();
        if (input instanceof Map) {
            value.setStructValue(ProtoUtils.makeStruct((Map)input));
        } else if (input instanceof Iterable) {
            value.setListValue(ProtoUtils.makeListValue((Iterable)input));
        } else if (input instanceof Number) {
            value.setNumberValue(((Number)input).doubleValue());
        } else if (input instanceof String) {
            value.setStringValue((String)input);
        } else if (input instanceof Boolean) {
            value.setBoolValue((Boolean)input);
        } else if (input instanceof Value) {
            value = Value.newBuilder((Value)input);
        } else if (input instanceof ListValue) {
            value.setListValue((ListValue)input);
        } else if (input instanceof Struct) {
            value.setStructValue((Struct)input);
        } else if (input == null || input == NullValue.NULL_VALUE) {
            value.setNullValue(NullValue.NULL_VALUE);
        } else {
            throw new IllegalArgumentException(String.format("Cannot construct proto value from input. input class=%s", input.getClass()));
        }
        return value.build();
    }

    private static Struct makeStruct(Map<?, ?> value) {
        Struct.Builder struct = Struct.newBuilder();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            String fieldName = entry.getKey().toString();
            struct.putFields(fieldName, ProtoUtils.makeProtoValue(entry.getValue()));
        }
        return struct.build();
    }

    private static ListValue makeListValue(Iterable<?> value) {
        ListValue.Builder listValue = ListValue.newBuilder();
        for (Object val : value) {
            listValue.addValues(ProtoUtils.makeProtoValue(val));
        }
        return listValue.build();
    }
}

