/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.utils;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.firebase.rules.utils.AutoValue_ResourceNameUtils_FlowReference;
import com.google.firebase.rules.utils.AutoValue_ResourceNameUtils_ProjectReference;
import com.google.firebase.rules.utils.AutoValue_ResourceNameUtils_ReleaseReference;
import com.google.firebase.rules.utils.AutoValue_ResourceNameUtils_RulesetReference;
import com.google.firebase.rules.utils.AutoValue_ResourceNameUtils_TestRulesetReference;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.firebase.rules.validations.ValidationException;
import com.google.firebase.rules.validations.Validator;
import io.gapi.gax.protobuf.PathTemplate;
import java.util.List;

public class ResourceNameUtils {
    private static final PathTemplate PROJECT_TEMPLATE = PathTemplate.create("projects/*");
    private static final PathTemplate RULESET_TEMPLATE = PathTemplate.create("projects/*/rulesets/*");
    private static final PathTemplate RELEASE_TEMPLATE = PathTemplate.create("projects/*/releases/**");
    private static final PathTemplate FLOW_TEMPLATE = PathTemplate.create("projects/*/flows/**");
    private static final String PROJECT_FORMAT = "projects/%s";
    private static final String RULESET_FORMAT = "%s/rulesets/%s";
    private static final String RELEASE_FORMAT = "%s/releases/%s";
    private static final String FLOW_FORMAT = "%s/flows/%s";

    private ResourceNameUtils() {
    }

    @AutoValue
    public static abstract class FlowReference
    implements ResourceReference {
        @Override
        public abstract String projectId();

        public abstract String flowId();

        public String toString() {
            return FlowReference.formatName(this.projectId(), this.flowId());
        }

        @Override
        public String name() {
            return this.toString();
        }

        public static FlowReference of(String projectId, String flowId) {
            return new AutoValue_ResourceNameUtils_FlowReference(Preconditions.checkNotNull(projectId), Preconditions.checkNotNull(flowId));
        }

        public static FlowReference parse(String flowName) {
            List<String> resourceIds = FLOW_TEMPLATE.decode(flowName);
            Preconditions.checkArgument(resourceIds.size() == 2, new StringBuilder(25 + String.valueOf(flowName).length()).append("Invalid flow resource [").append(flowName).append("].").toString());
            return new AutoValue_ResourceNameUtils_FlowReference(resourceIds.get(0), resourceIds.get(1));
        }

        public static FlowReference parse(String flowName, Validator validator) throws ValidationException {
            try {
                return FlowReference.parse(flowName);
            }
            catch (IllegalArgumentException eex) {
                throw validator.fail(FirebaseRulesMessages.INVALID_EVENT_FLOW_NAME_FORMAT, flowName);
            }
        }

        public static String formatName(String projectId, String flowId) {
            return String.format(ResourceNameUtils.FLOW_FORMAT, ProjectReference.formatName(projectId), flowId);
        }
    }

    @AutoValue
    public static abstract class TestRulesetReference
    implements ResourceReference {
        @Override
        public abstract String projectId();

        public abstract String rulesetId();

        public String toString() {
            if (!this.rulesetId().isEmpty()) {
                return RulesetReference.formatName(this.projectId(), this.rulesetId());
            }
            return ProjectReference.formatName(this.projectId());
        }

        @Override
        public String name() {
            return this.toString();
        }

        public static TestRulesetReference parse(String resourceName, Validator validator) throws ValidationException {
            try {
                return TestRulesetReference.parse(resourceName);
            }
            catch (IllegalArgumentException e) {
                throw validator.fail(FirebaseRulesMessages.INVALID_RULESET_NAME_FORMAT, resourceName);
            }
        }

        public static TestRulesetReference parse(String resourceName) {
            String projectId;
            String rulesetId = "";
            if (RulesetReference.matches(resourceName)) {
                RulesetReference rulesetReference = RulesetReference.parse(resourceName);
                projectId = rulesetReference.projectId();
                rulesetId = rulesetReference.rulesetId();
            } else {
                ProjectReference project = ProjectReference.parse(resourceName);
                projectId = project.projectId();
            }
            return new AutoValue_ResourceNameUtils_TestRulesetReference(projectId, rulesetId);
        }
    }

    @AutoValue
    public static abstract class ReleaseReference
    implements ResourceReference {
        @Override
        public abstract String projectId();

        public abstract String releaseId();

        public String toString() {
            return ReleaseReference.formatName(this.projectId(), this.releaseId());
        }

        @Override
        public String name() {
            return this.toString();
        }

        public static ReleaseReference parse(String resourceName) {
            List<String> resourceIds = RELEASE_TEMPLATE.decode(resourceName);
            Preconditions.checkArgument(resourceIds.size() == 2, new StringBuilder(28 + String.valueOf(resourceName).length()).append("Invalid release resource [").append(resourceName).append("].").toString());
            return new AutoValue_ResourceNameUtils_ReleaseReference(resourceIds.get(0), resourceIds.get(1));
        }

        public static ReleaseReference of(String projectId, String releaseId) {
            return new AutoValue_ResourceNameUtils_ReleaseReference(Preconditions.checkNotNull(projectId), Preconditions.checkNotNull(releaseId));
        }

        public static ReleaseReference parse(String resourceName, Validator validator) throws ValidationException {
            try {
                return ReleaseReference.parse(resourceName);
            }
            catch (IllegalArgumentException eex) {
                throw validator.fail(FirebaseRulesMessages.INVALID_RELEASE_NAME_FORMAT, resourceName);
            }
        }

        public static String formatName(String projectId, String releaseId) {
            return String.format(ResourceNameUtils.RELEASE_FORMAT, ProjectReference.formatName(projectId), releaseId);
        }
    }

    @AutoValue
    public static abstract class RulesetReference
    implements ResourceReference {
        @Override
        public abstract String projectId();

        public abstract String rulesetId();

        public String toString() {
            return RulesetReference.formatName(this.projectId(), this.rulesetId());
        }

        @Override
        public String name() {
            return this.toString();
        }

        public static RulesetReference parse(String resourceName) {
            List<String> resourceIds = RULESET_TEMPLATE.decode(resourceName);
            Preconditions.checkArgument(resourceIds.size() == 2, new StringBuilder(28 + String.valueOf(resourceName).length()).append("Invalid ruleset resource [").append(resourceName).append("].").toString());
            return new AutoValue_ResourceNameUtils_RulesetReference(resourceIds.get(0), resourceIds.get(1));
        }

        public static RulesetReference of(String projectId, String rulesetId) {
            return new AutoValue_ResourceNameUtils_RulesetReference(Preconditions.checkNotNull(projectId), Preconditions.checkNotNull(rulesetId));
        }

        public static boolean matches(String resourceName) {
            return RULESET_TEMPLATE.matches(resourceName);
        }

        public static RulesetReference parse(String resourceName, Validator validator) throws ValidationException {
            try {
                return RulesetReference.parse(resourceName);
            }
            catch (IllegalArgumentException eex) {
                throw validator.fail(FirebaseRulesMessages.INVALID_RULESET_NAME_FORMAT, resourceName);
            }
        }

        public static String formatName(String projectId, String rulesetId) {
            return String.format(ResourceNameUtils.RULESET_FORMAT, ProjectReference.formatName(projectId), rulesetId);
        }
    }

    @AutoValue
    public static abstract class ProjectReference
    implements ResourceReference {
        @Override
        public abstract String projectId();

        public String toString() {
            return ProjectReference.formatName(this.projectId());
        }

        @Override
        public String name() {
            return this.toString();
        }

        public ReleaseReference release(String releaseId) {
            return ReleaseReference.of(this.projectId(), releaseId);
        }

        public RulesetReference ruleset(String rulesetId) {
            return RulesetReference.of(this.projectId(), rulesetId);
        }

        public FlowReference flow(String flowId) {
            return FlowReference.of(this.projectId(), flowId);
        }

        public static ProjectReference parse(String resourceName, Validator validator) throws ValidationException {
            try {
                return ProjectReference.parse(resourceName);
            }
            catch (IllegalArgumentException e) {
                throw validator.fail(FirebaseRulesMessages.INVALID_PROJECT_NAME_FORMAT, resourceName);
            }
        }

        public static ProjectReference parse(String resourceName) {
            List<String> resourceIds = PROJECT_TEMPLATE.decode(resourceName);
            Preconditions.checkArgument(resourceIds.size() == 1, new StringBuilder(22 + String.valueOf(resourceName).length()).append("Invalid project id [").append(resourceName).append("].").toString());
            return new AutoValue_ResourceNameUtils_ProjectReference(resourceIds.get(0));
        }

        public static String formatName(String projectId) {
            return String.format(ResourceNameUtils.PROJECT_FORMAT, projectId);
        }

        public static ProjectReference of(String projectId) {
            return new AutoValue_ResourceNameUtils_ProjectReference(projectId);
        }

        public String rulesetCollectionName() {
            return String.valueOf(this.name()).concat("/rulesets");
        }

        public String releaseCollectionName() {
            return String.valueOf(this.name()).concat("/releases");
        }

        public String flowCollectionName() {
            return String.valueOf(this.name()).concat("/flows");
        }
    }

    public static interface ResourceReference {
        public String projectId();

        public String name();
    }
}

