/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.v1;

import com.google.firebase.rules.v1.FirebaseRulesProto;
import com.google.firebase.rules.v1.ListReleaseExecutablesRequestOrBuilder;
import com.google.firebase.rules.v1.ReleaseExecutableVersion;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ListReleaseExecutablesRequest
extends GeneratedMessage
implements ListReleaseExecutablesRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int EXECUTABLE_VERSIONS_FIELD_NUMBER = 1;
    private List<Integer> executableVersions_;
    private static final Internal.ListAdapter.Converter<Integer, ReleaseExecutableVersion> executableVersions_converter_ = new Internal.ListAdapter.Converter<Integer, ReleaseExecutableVersion>(){

        @Override
        public ReleaseExecutableVersion convert(Integer from) {
            ReleaseExecutableVersion result = ReleaseExecutableVersion.forNumber(from);
            return result == null ? ReleaseExecutableVersion.UNRECOGNIZED : result;
        }
    };
    private int executableVersionsMemoizedSerializedSize;
    public static final int PAGE_SIZE_FIELD_NUMBER = 2;
    private int pageSize_;
    public static final int START_TIME_FIELD_NUMBER = 3;
    private Timestamp startTime_;
    public static final int RELEASES_FILTER_FIELD_NUMBER = 4;
    private ExistenceFilter releasesFilter_;
    public static final int EXCLUDE_RELEASE_UPDATES_FIELD_NUMBER = 5;
    private List<ReleaseUpdateId> excludeReleaseUpdates_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ListReleaseExecutablesRequest DEFAULT_INSTANCE = new ListReleaseExecutablesRequest();
    private static final Parser<ListReleaseExecutablesRequest> PARSER = new AbstractParser<ListReleaseExecutablesRequest>(){

        @Override
        public ListReleaseExecutablesRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            if (usingExperimentalRuntime) {
                ListReleaseExecutablesRequest msg = new ListReleaseExecutablesRequest();
                msg.mergeFromInternal(input, extensionRegistry);
                msg.makeImmutableInternal();
                return msg;
            }
            return new ListReleaseExecutablesRequest(input, extensionRegistry);
        }
    };

    private ListReleaseExecutablesRequest(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private ListReleaseExecutablesRequest() {
        this.executableVersions_ = Collections.emptyList();
        this.excludeReleaseUpdates_ = Collections.emptyList();
    }

    @Override
    protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
        return new ListReleaseExecutablesRequest();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private ListReleaseExecutablesRequest(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block15: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block15;
                    }
                    case 8: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.executableVersions_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 1;
                        }
                        this.executableVersions_.add(rawValue);
                        continue block15;
                    }
                    case 10: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            int rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 1) == 0) {
                                this.executableVersions_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 1;
                            }
                            this.executableVersions_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block15;
                    }
                    case 16: {
                        this.pageSize_ = input.readInt32();
                        continue block15;
                    }
                    case 26: {
                        Timestamp.Builder subBuilder = null;
                        if (this.startTime_ != null) {
                            subBuilder = this.startTime_.toBuilder();
                        }
                        this.startTime_ = input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block15;
                        subBuilder.mergeFrom(this.startTime_);
                        this.startTime_ = subBuilder.buildPartial();
                        continue block15;
                    }
                    case 34: {
                        ExistenceFilter.Builder subBuilder = null;
                        if (this.releasesFilter_ != null) {
                            subBuilder = this.releasesFilter_.toBuilder();
                        }
                        this.releasesFilter_ = input.readMessage(ExistenceFilter.parser(), extensionRegistry);
                        if (subBuilder == null) continue block15;
                        subBuilder.mergeFrom(this.releasesFilter_);
                        this.releasesFilter_ = subBuilder.buildPartial();
                        continue block15;
                    }
                    case 42: {
                        if ((mutable_bitField0_ & 0x10) == 0) {
                            this.excludeReleaseUpdates_ = new ArrayList<ReleaseUpdateId>();
                            mutable_bitField0_ |= 0x10;
                        }
                        this.excludeReleaseUpdates_.add(input.readMessage(ReleaseUpdateId.parser(), extensionRegistry));
                        continue block15;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.executableVersions_ = Collections.unmodifiableList(this.executableVersions_);
            }
            if ((mutable_bitField0_ & 0x10) != 0) {
                this.excludeReleaseUpdates_ = Collections.unmodifiableList(this.excludeReleaseUpdates_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_descriptor;
    }

    @Override
    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ListReleaseExecutablesRequest.class, Builder.class);
    }

    @Override
    public List<ReleaseExecutableVersion> getExecutableVersionsList() {
        return new Internal.ListAdapter<Integer, ReleaseExecutableVersion>(this.executableVersions_, executableVersions_converter_);
    }

    @Override
    public int getExecutableVersionsCount() {
        return this.executableVersions_.size();
    }

    @Override
    public ReleaseExecutableVersion getExecutableVersions(int index) {
        return executableVersions_converter_.convert(this.executableVersions_.get(index));
    }

    @Override
    public List<Integer> getExecutableVersionsValueList() {
        return this.executableVersions_;
    }

    @Override
    public int getExecutableVersionsValue(int index) {
        return this.executableVersions_.get(index);
    }

    @Override
    public int getPageSize() {
        return this.pageSize_;
    }

    @Override
    public boolean hasStartTime() {
        return this.startTime_ != null;
    }

    @Override
    public Timestamp getStartTime() {
        return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
    }

    @Override
    public TimestampOrBuilder getStartTimeOrBuilder() {
        return this.getStartTime();
    }

    @Override
    public boolean hasReleasesFilter() {
        return this.releasesFilter_ != null;
    }

    @Override
    public ExistenceFilter getReleasesFilter() {
        return this.releasesFilter_ == null ? ExistenceFilter.getDefaultInstance() : this.releasesFilter_;
    }

    @Override
    public ExistenceFilterOrBuilder getReleasesFilterOrBuilder() {
        return this.getReleasesFilter();
    }

    @Override
    public List<ReleaseUpdateId> getExcludeReleaseUpdatesList() {
        return this.excludeReleaseUpdates_;
    }

    @Override
    public List<? extends ReleaseUpdateIdOrBuilder> getExcludeReleaseUpdatesOrBuilderList() {
        return this.excludeReleaseUpdates_;
    }

    @Override
    public int getExcludeReleaseUpdatesCount() {
        return this.excludeReleaseUpdates_.size();
    }

    @Override
    public ReleaseUpdateId getExcludeReleaseUpdates(int index) {
        return this.excludeReleaseUpdates_.get(index);
    }

    @Override
    public ReleaseUpdateIdOrBuilder getExcludeReleaseUpdatesOrBuilder(int index) {
        return this.excludeReleaseUpdates_.get(index);
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (usingExperimentalRuntime) {
            this.writeToInternal(output);
            return;
        }
        this.getSerializedSize();
        if (this.getExecutableVersionsList().size() > 0) {
            output.writeUInt32NoTag(10);
            output.writeUInt32NoTag(this.executableVersionsMemoizedSerializedSize);
        }
        for (i = 0; i < this.executableVersions_.size(); ++i) {
            output.writeEnumNoTag(this.executableVersions_.get(i));
        }
        if (this.pageSize_ != 0) {
            output.writeInt32(2, this.pageSize_);
        }
        if (this.startTime_ != null) {
            output.writeMessage(3, this.getStartTime());
        }
        if (this.releasesFilter_ != null) {
            output.writeMessage(4, this.getReleasesFilter());
        }
        for (i = 0; i < this.excludeReleaseUpdates_.size(); ++i) {
            output.writeMessage(5, this.excludeReleaseUpdates_.get(i));
        }
        this.unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        if (usingExperimentalRuntime) {
            this.memoizedSize = this.getSerializedSizeInternal();
            return this.memoizedSize;
        }
        size = 0;
        int dataSize = 0;
        for (int i = 0; i < this.executableVersions_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag(this.executableVersions_.get(i));
        }
        size += dataSize;
        if (!this.getExecutableVersionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        this.executableVersionsMemoizedSerializedSize = dataSize;
        if (this.pageSize_ != 0) {
            size += CodedOutputStream.computeInt32Size(2, this.pageSize_);
        }
        if (this.startTime_ != null) {
            size += CodedOutputStream.computeMessageSize(3, this.getStartTime());
        }
        if (this.releasesFilter_ != null) {
            size += CodedOutputStream.computeMessageSize(4, this.getReleasesFilter());
        }
        for (int i = 0; i < this.excludeReleaseUpdates_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(5, this.excludeReleaseUpdates_.get(i));
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListReleaseExecutablesRequest)) {
            return super.equals(obj);
        }
        ListReleaseExecutablesRequest other = (ListReleaseExecutablesRequest)obj;
        if (!this.executableVersions_.equals(other.executableVersions_)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.hasStartTime() != other.hasStartTime()) {
            return false;
        }
        if (this.hasStartTime() && !this.getStartTime().equals(other.getStartTime())) {
            return false;
        }
        if (this.hasReleasesFilter() != other.hasReleasesFilter()) {
            return false;
        }
        if (this.hasReleasesFilter() && !this.getReleasesFilter().equals(other.getReleasesFilter())) {
            return false;
        }
        if (!this.getExcludeReleaseUpdatesList().equals(other.getExcludeReleaseUpdatesList())) {
            return false;
        }
        return this.unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ListReleaseExecutablesRequest.getDescriptor().hashCode();
        if (this.getExecutableVersionsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.executableVersions_.hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getPageSize();
        if (this.hasStartTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getStartTime().hashCode();
        }
        if (this.hasReleasesFilter()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getReleasesFilter().hashCode();
        }
        if (this.getExcludeReleaseUpdatesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getExcludeReleaseUpdatesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    @Override
    protected MutableMessage internalMutableDefault() {
        return MutableDefaultLoader.get();
    }

    public static ListReleaseExecutablesRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ListReleaseExecutablesRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListReleaseExecutablesRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ListReleaseExecutablesRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListReleaseExecutablesRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ListReleaseExecutablesRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ListReleaseExecutablesRequest parseFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static ListReleaseExecutablesRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static ListReleaseExecutablesRequest parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static ListReleaseExecutablesRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static ListReleaseExecutablesRequest parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static ListReleaseExecutablesRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return ListReleaseExecutablesRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ListReleaseExecutablesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ListReleaseExecutablesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ListReleaseExecutablesRequest> parser() {
        return PARSER;
    }

    public Parser<ListReleaseExecutablesRequest> getParserForType() {
        return PARSER;
    }

    @Override
    public ListReleaseExecutablesRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements ListReleaseExecutablesRequestOrBuilder {
        private int bitField0_;
        private List<Integer> executableVersions_ = Collections.emptyList();
        private int pageSize_;
        private Timestamp startTime_;
        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> startTimeBuilder_;
        private ExistenceFilter releasesFilter_;
        private SingleFieldBuilder<ExistenceFilter, ExistenceFilter.Builder, ExistenceFilterOrBuilder> releasesFilterBuilder_;
        private List<ReleaseUpdateId> excludeReleaseUpdates_ = Collections.emptyList();
        private RepeatedFieldBuilder<ReleaseUpdateId, ReleaseUpdateId.Builder, ReleaseUpdateIdOrBuilder> excludeReleaseUpdatesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ListReleaseExecutablesRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getExcludeReleaseUpdatesFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.executableVersions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.pageSize_ = 0;
            if (this.startTimeBuilder_ == null) {
                this.startTime_ = null;
            } else {
                this.startTime_ = null;
                this.startTimeBuilder_ = null;
            }
            if (this.releasesFilterBuilder_ == null) {
                this.releasesFilter_ = null;
            } else {
                this.releasesFilter_ = null;
                this.releasesFilterBuilder_ = null;
            }
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.excludeReleaseUpdates_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
            } else {
                this.excludeReleaseUpdatesBuilder_.clear();
            }
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_descriptor;
        }

        @Override
        public ListReleaseExecutablesRequest getDefaultInstanceForType() {
            return ListReleaseExecutablesRequest.getDefaultInstance();
        }

        @Override
        public ListReleaseExecutablesRequest build() {
            ListReleaseExecutablesRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public ListReleaseExecutablesRequest buildPartial() {
            ListReleaseExecutablesRequest result = new ListReleaseExecutablesRequest(this);
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((this.bitField0_ & 1) != 0) {
                this.executableVersions_ = Collections.unmodifiableList(this.executableVersions_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.executableVersions_ = this.executableVersions_;
            result.pageSize_ = this.pageSize_;
            if (this.startTimeBuilder_ == null) {
                result.startTime_ = this.startTime_;
            } else {
                result.startTime_ = this.startTimeBuilder_.build();
            }
            if (this.releasesFilterBuilder_ == null) {
                result.releasesFilter_ = this.releasesFilter_;
            } else {
                result.releasesFilter_ = this.releasesFilterBuilder_.build();
            }
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.excludeReleaseUpdates_ = Collections.unmodifiableList(this.excludeReleaseUpdates_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.excludeReleaseUpdates_ = this.excludeReleaseUpdates_;
            } else {
                result.excludeReleaseUpdates_ = this.excludeReleaseUpdatesBuilder_.build();
            }
            result.bitField0_ = to_bitField0_;
            this.onBuilt();
            return result;
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof ListReleaseExecutablesRequest) {
                return this.mergeFrom((ListReleaseExecutablesRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ListReleaseExecutablesRequest other) {
            if (other == ListReleaseExecutablesRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.executableVersions_.isEmpty()) {
                if (this.executableVersions_.isEmpty()) {
                    this.executableVersions_ = other.executableVersions_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureExecutableVersionsIsMutable();
                    this.executableVersions_.addAll(other.executableVersions_);
                }
                this.onChanged();
            }
            if (other.getPageSize() != 0) {
                this.setPageSize(other.getPageSize());
            }
            if (other.hasStartTime()) {
                this.mergeStartTime(other.getStartTime());
            }
            if (other.hasReleasesFilter()) {
                this.mergeReleasesFilter(other.getReleasesFilter());
            }
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                if (!other.excludeReleaseUpdates_.isEmpty()) {
                    if (this.excludeReleaseUpdates_.isEmpty()) {
                        this.excludeReleaseUpdates_ = other.excludeReleaseUpdates_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensureExcludeReleaseUpdatesIsMutable();
                        this.excludeReleaseUpdates_.addAll(other.excludeReleaseUpdates_);
                    }
                    this.onChanged();
                }
            } else if (!other.excludeReleaseUpdates_.isEmpty()) {
                if (this.excludeReleaseUpdatesBuilder_.isEmpty()) {
                    this.excludeReleaseUpdatesBuilder_.dispose();
                    this.excludeReleaseUpdatesBuilder_ = null;
                    this.excludeReleaseUpdates_ = other.excludeReleaseUpdates_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.excludeReleaseUpdatesBuilder_ = alwaysUseFieldBuilders ? this.getExcludeReleaseUpdatesFieldBuilder() : null;
                } else {
                    this.excludeReleaseUpdatesBuilder_.addAllMessages(other.excludeReleaseUpdates_);
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            ListReleaseExecutablesRequest parsedMessage = null;
            try {
                parsedMessage = (ListReleaseExecutablesRequest)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (ListReleaseExecutablesRequest)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        private void ensureExecutableVersionsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.executableVersions_ = new ArrayList<Integer>(this.executableVersions_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<ReleaseExecutableVersion> getExecutableVersionsList() {
            return new Internal.ListAdapter(this.executableVersions_, executableVersions_converter_);
        }

        @Override
        public int getExecutableVersionsCount() {
            return this.executableVersions_.size();
        }

        @Override
        public ReleaseExecutableVersion getExecutableVersions(int index) {
            return (ReleaseExecutableVersion)executableVersions_converter_.convert(this.executableVersions_.get(index));
        }

        public Builder setExecutableVersions(int index, ReleaseExecutableVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExecutableVersionsIsMutable();
            this.executableVersions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addExecutableVersions(ReleaseExecutableVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExecutableVersionsIsMutable();
            this.executableVersions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllExecutableVersions(Iterable<? extends ReleaseExecutableVersion> values) {
            this.ensureExecutableVersionsIsMutable();
            for (ReleaseExecutableVersion releaseExecutableVersion : values) {
                this.executableVersions_.add(releaseExecutableVersion.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearExecutableVersions() {
            this.executableVersions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getExecutableVersionsValueList() {
            return Collections.unmodifiableList(this.executableVersions_);
        }

        @Override
        public int getExecutableVersionsValue(int index) {
            return this.executableVersions_.get(index);
        }

        public Builder setExecutableVersionsValue(int index, int value) {
            this.ensureExecutableVersionsIsMutable();
            this.executableVersions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addExecutableVersionsValue(int value) {
            this.ensureExecutableVersionsIsMutable();
            this.executableVersions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllExecutableVersionsValue(Iterable<Integer> values) {
            this.ensureExecutableVersionsIsMutable();
            for (int value : values) {
                this.executableVersions_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public int getPageSize() {
            return this.pageSize_;
        }

        public Builder setPageSize(int value) {
            this.pageSize_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPageSize() {
            this.pageSize_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStartTime() {
            return this.startTimeBuilder_ != null || this.startTime_ != null;
        }

        @Override
        public Timestamp getStartTime() {
            if (this.startTimeBuilder_ == null) {
                return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
            }
            return this.startTimeBuilder_.getMessage();
        }

        public Builder setStartTime(Timestamp value) {
            if (this.startTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startTime_ = value;
                this.onChanged();
            } else {
                this.startTimeBuilder_.setMessage(value);
            }
            return this;
        }

        public Builder setStartTime(Timestamp.Builder builderForValue) {
            if (this.startTimeBuilder_ == null) {
                this.startTime_ = builderForValue.build();
                this.onChanged();
            } else {
                this.startTimeBuilder_.setMessage(builderForValue.build());
            }
            return this;
        }

        public Builder mergeStartTime(Timestamp value) {
            if (this.startTimeBuilder_ == null) {
                this.startTime_ = this.startTime_ != null ? Timestamp.newBuilder(this.startTime_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.startTimeBuilder_.mergeFrom(value);
            }
            return this;
        }

        public Builder clearStartTime() {
            if (this.startTimeBuilder_ == null) {
                this.startTime_ = null;
                this.onChanged();
            } else {
                this.startTime_ = null;
                this.startTimeBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getStartTimeBuilder() {
            this.onChanged();
            return this.getStartTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getStartTimeOrBuilder() {
            if (this.startTimeBuilder_ != null) {
                return this.startTimeBuilder_.getMessageOrBuilder();
            }
            return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
        }

        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> getStartTimeFieldBuilder() {
            if (this.startTimeBuilder_ == null) {
                this.startTimeBuilder_ = new SingleFieldBuilder(this.getStartTime(), this.getParentForChildren(), this.isClean());
                this.startTime_ = null;
            }
            return this.startTimeBuilder_;
        }

        @Override
        public boolean hasReleasesFilter() {
            return this.releasesFilterBuilder_ != null || this.releasesFilter_ != null;
        }

        @Override
        public ExistenceFilter getReleasesFilter() {
            if (this.releasesFilterBuilder_ == null) {
                return this.releasesFilter_ == null ? ExistenceFilter.getDefaultInstance() : this.releasesFilter_;
            }
            return this.releasesFilterBuilder_.getMessage();
        }

        public Builder setReleasesFilter(ExistenceFilter value) {
            if (this.releasesFilterBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.releasesFilter_ = value;
                this.onChanged();
            } else {
                this.releasesFilterBuilder_.setMessage(value);
            }
            return this;
        }

        public Builder setReleasesFilter(ExistenceFilter.Builder builderForValue) {
            if (this.releasesFilterBuilder_ == null) {
                this.releasesFilter_ = builderForValue.build();
                this.onChanged();
            } else {
                this.releasesFilterBuilder_.setMessage(builderForValue.build());
            }
            return this;
        }

        public Builder mergeReleasesFilter(ExistenceFilter value) {
            if (this.releasesFilterBuilder_ == null) {
                this.releasesFilter_ = this.releasesFilter_ != null ? ExistenceFilter.newBuilder(this.releasesFilter_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.releasesFilterBuilder_.mergeFrom(value);
            }
            return this;
        }

        public Builder clearReleasesFilter() {
            if (this.releasesFilterBuilder_ == null) {
                this.releasesFilter_ = null;
                this.onChanged();
            } else {
                this.releasesFilter_ = null;
                this.releasesFilterBuilder_ = null;
            }
            return this;
        }

        public ExistenceFilter.Builder getReleasesFilterBuilder() {
            this.onChanged();
            return this.getReleasesFilterFieldBuilder().getBuilder();
        }

        @Override
        public ExistenceFilterOrBuilder getReleasesFilterOrBuilder() {
            if (this.releasesFilterBuilder_ != null) {
                return this.releasesFilterBuilder_.getMessageOrBuilder();
            }
            return this.releasesFilter_ == null ? ExistenceFilter.getDefaultInstance() : this.releasesFilter_;
        }

        private SingleFieldBuilder<ExistenceFilter, ExistenceFilter.Builder, ExistenceFilterOrBuilder> getReleasesFilterFieldBuilder() {
            if (this.releasesFilterBuilder_ == null) {
                this.releasesFilterBuilder_ = new SingleFieldBuilder(this.getReleasesFilter(), this.getParentForChildren(), this.isClean());
                this.releasesFilter_ = null;
            }
            return this.releasesFilterBuilder_;
        }

        private void ensureExcludeReleaseUpdatesIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.excludeReleaseUpdates_ = new ArrayList<ReleaseUpdateId>(this.excludeReleaseUpdates_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<ReleaseUpdateId> getExcludeReleaseUpdatesList() {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                return Collections.unmodifiableList(this.excludeReleaseUpdates_);
            }
            return this.excludeReleaseUpdatesBuilder_.getMessageList();
        }

        @Override
        public int getExcludeReleaseUpdatesCount() {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                return this.excludeReleaseUpdates_.size();
            }
            return this.excludeReleaseUpdatesBuilder_.getCount();
        }

        @Override
        public ReleaseUpdateId getExcludeReleaseUpdates(int index) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                return this.excludeReleaseUpdates_.get(index);
            }
            return this.excludeReleaseUpdatesBuilder_.getMessage(index);
        }

        public Builder setExcludeReleaseUpdates(int index, ReleaseUpdateId value) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.set(index, value);
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setExcludeReleaseUpdates(int index, ReleaseUpdateId.Builder builderForValue) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addExcludeReleaseUpdates(ReleaseUpdateId value) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.add(value);
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addExcludeReleaseUpdates(int index, ReleaseUpdateId value) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.add(index, value);
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addExcludeReleaseUpdates(ReleaseUpdateId.Builder builderForValue) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addExcludeReleaseUpdates(int index, ReleaseUpdateId.Builder builderForValue) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllExcludeReleaseUpdates(Iterable<? extends ReleaseUpdateId> values) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.ensureExcludeReleaseUpdatesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.excludeReleaseUpdates_);
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearExcludeReleaseUpdates() {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.excludeReleaseUpdates_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.clear();
            }
            return this;
        }

        public Builder removeExcludeReleaseUpdates(int index) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.ensureExcludeReleaseUpdatesIsMutable();
                this.excludeReleaseUpdates_.remove(index);
                this.onChanged();
            } else {
                this.excludeReleaseUpdatesBuilder_.remove(index);
            }
            return this;
        }

        public ReleaseUpdateId.Builder getExcludeReleaseUpdatesBuilder(int index) {
            return this.getExcludeReleaseUpdatesFieldBuilder().getBuilder(index);
        }

        @Override
        public ReleaseUpdateIdOrBuilder getExcludeReleaseUpdatesOrBuilder(int index) {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                return this.excludeReleaseUpdates_.get(index);
            }
            return this.excludeReleaseUpdatesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ReleaseUpdateIdOrBuilder> getExcludeReleaseUpdatesOrBuilderList() {
            if (this.excludeReleaseUpdatesBuilder_ != null) {
                return this.excludeReleaseUpdatesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.excludeReleaseUpdates_);
        }

        public ReleaseUpdateId.Builder addExcludeReleaseUpdatesBuilder() {
            return this.getExcludeReleaseUpdatesFieldBuilder().addBuilder(ReleaseUpdateId.getDefaultInstance());
        }

        public ReleaseUpdateId.Builder addExcludeReleaseUpdatesBuilder(int index) {
            return this.getExcludeReleaseUpdatesFieldBuilder().addBuilder(index, ReleaseUpdateId.getDefaultInstance());
        }

        public List<ReleaseUpdateId.Builder> getExcludeReleaseUpdatesBuilderList() {
            return this.getExcludeReleaseUpdatesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<ReleaseUpdateId, ReleaseUpdateId.Builder, ReleaseUpdateIdOrBuilder> getExcludeReleaseUpdatesFieldBuilder() {
            if (this.excludeReleaseUpdatesBuilder_ == null) {
                this.excludeReleaseUpdatesBuilder_ = new RepeatedFieldBuilder(this.excludeReleaseUpdates_, (this.bitField0_ & 0x10) != 0, this.getParentForChildren(), this.isClean());
                this.excludeReleaseUpdates_ = null;
            }
            return this.excludeReleaseUpdatesBuilder_;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }
    }

    private static final class MutableDefaultLoader {
        private static final Object defaultOrRuntimeException;

        private MutableDefaultLoader() {
        }

        public static MutableMessage get() {
            if (defaultOrRuntimeException instanceof RuntimeException) {
                throw (RuntimeException)defaultOrRuntimeException;
            }
            return (MutableMessage)defaultOrRuntimeException;
        }

        static {
            Object local;
            try {
                local = ListReleaseExecutablesRequest.internalMutableDefault("com.google.firebase.rules.v1.proto1api.ListReleaseExecutablesRequest");
            }
            catch (RuntimeException e) {
                local = e;
            }
            defaultOrRuntimeException = local;
        }
    }

    public static final class ExistenceFilter
    extends GeneratedMessage
    implements ExistenceFilterOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int STRATEGY_FIELD_NUMBER = 1;
        private int strategy_;
        public static final int HASHES_FIELD_NUMBER = 2;
        private int hashes_;
        public static final int BITS_FIELD_NUMBER = 3;
        private Internal.LongList bits_;
        private int bitsMemoizedSerializedSize = -1;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ExistenceFilter DEFAULT_INSTANCE = new ExistenceFilter();
        private static final Parser<ExistenceFilter> PARSER = new AbstractParser<ExistenceFilter>(){

            @Override
            public ExistenceFilter parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                if (usingExperimentalRuntime) {
                    ExistenceFilter msg = new ExistenceFilter();
                    msg.mergeFromInternal(input, extensionRegistry);
                    msg.makeImmutableInternal();
                    return msg;
                }
                return new ExistenceFilter(input, extensionRegistry);
            }
        };

        private ExistenceFilter(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private ExistenceFilter() {
            this.strategy_ = 0;
            this.bits_ = ExistenceFilter.emptyLongList();
        }

        @Override
        protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
            return new ExistenceFilter();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private ExistenceFilter(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            int mutable_bitField0_ = 0;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 8: {
                            int rawValue;
                            this.strategy_ = rawValue = input.readEnum();
                            continue block13;
                        }
                        case 16: {
                            this.hashes_ = input.readUInt32();
                            continue block13;
                        }
                        case 25: {
                            if ((mutable_bitField0_ & 4) == 0) {
                                this.bits_ = ExistenceFilter.newLongList();
                                mutable_bitField0_ |= 4;
                            }
                            this.bits_.addLong(input.readFixed64());
                            continue block13;
                        }
                        case 26: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            if ((mutable_bitField0_ & 4) == 0 && input.getBytesUntilLimit() > 0) {
                                this.bits_ = ExistenceFilter.newLongList();
                                mutable_bitField0_ |= 4;
                            }
                            while (input.getBytesUntilLimit() > 0) {
                                this.bits_.addLong(input.readFixed64());
                            }
                            input.popLimit(limit);
                            continue block13;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
            }
            finally {
                if ((mutable_bitField0_ & 4) != 0) {
                    this.bits_.makeImmutable();
                }
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ExistenceFilter_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ExistenceFilter_fieldAccessorTable.ensureFieldAccessorsInitialized(ExistenceFilter.class, Builder.class);
        }

        @Override
        public int getStrategyValue() {
            return this.strategy_;
        }

        @Override
        public HashStrategy getStrategy() {
            HashStrategy result = HashStrategy.forNumber(this.strategy_);
            return result == null ? HashStrategy.UNRECOGNIZED : result;
        }

        @Override
        public int getHashes() {
            return this.hashes_;
        }

        @Override
        public List<Long> getBitsList() {
            return this.bits_;
        }

        @Override
        public int getBitsCount() {
            return this.bits_.size();
        }

        @Override
        public long getBits(int index) {
            return this.bits_.getLong(index);
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (usingExperimentalRuntime) {
                this.writeToInternal(output);
                return;
            }
            this.getSerializedSize();
            if (this.strategy_ != HashStrategy.UNSPECIFIED.getNumber()) {
                output.writeEnum(1, this.strategy_);
            }
            if (this.hashes_ != 0) {
                output.writeUInt32(2, this.hashes_);
            }
            if (this.getBitsList().size() > 0) {
                output.writeUInt32NoTag(26);
                output.writeUInt32NoTag(this.bitsMemoizedSerializedSize);
            }
            for (int i = 0; i < this.bits_.size(); ++i) {
                output.writeFixed64NoTag(this.bits_.getLong(i));
            }
            this.unknownFields.writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            if (usingExperimentalRuntime) {
                this.memoizedSize = this.getSerializedSizeInternal();
                return this.memoizedSize;
            }
            size = 0;
            if (this.strategy_ != HashStrategy.UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize(1, this.strategy_);
            }
            if (this.hashes_ != 0) {
                size += CodedOutputStream.computeUInt32Size(2, this.hashes_);
            }
            int dataSize = 0;
            dataSize = 8 * this.getBitsList().size();
            size += dataSize;
            if (!this.getBitsList().isEmpty()) {
                ++size;
                size += CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            this.bitsMemoizedSerializedSize = dataSize;
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExistenceFilter)) {
                return super.equals(obj);
            }
            ExistenceFilter other = (ExistenceFilter)obj;
            if (this.strategy_ != other.strategy_) {
                return false;
            }
            if (this.getHashes() != other.getHashes()) {
                return false;
            }
            if (!this.getBitsList().equals(other.getBitsList())) {
                return false;
            }
            return this.unknownFields.equals(other.unknownFields);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ExistenceFilter.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.strategy_;
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getHashes();
            if (this.getBitsCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getBitsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        @Override
        protected MutableMessage internalMutableDefault() {
            return MutableDefaultLoader.get();
        }

        public static ExistenceFilter parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ExistenceFilter parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ExistenceFilter parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ExistenceFilter parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ExistenceFilter parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ExistenceFilter parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ExistenceFilter parseFrom(InputStream input) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static ExistenceFilter parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static ExistenceFilter parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static ExistenceFilter parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static ExistenceFilter parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static ExistenceFilter parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return ExistenceFilter.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ExistenceFilter prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ExistenceFilter getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ExistenceFilter> parser() {
            return PARSER;
        }

        public Parser<ExistenceFilter> getParserForType() {
            return PARSER;
        }

        @Override
        public ExistenceFilter getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static /* synthetic */ Internal.LongList access$2700() {
            return ExistenceFilter.emptyLongList();
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements ExistenceFilterOrBuilder {
            private int bitField0_;
            private int strategy_ = 0;
            private int hashes_;
            private Internal.LongList bits_ = ExistenceFilter.access$2700();

            public static final Descriptors.Descriptor getDescriptor() {
                return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ExistenceFilter_descriptor;
            }

            @Override
            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ExistenceFilter_fieldAccessorTable.ensureFieldAccessorsInitialized(ExistenceFilter.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessage.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            @Override
            public Builder clear() {
                super.clear();
                this.strategy_ = 0;
                this.hashes_ = 0;
                this.bits_ = ExistenceFilter.emptyLongList();
                this.bitField0_ &= 0xFFFFFFFB;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ExistenceFilter_descriptor;
            }

            @Override
            public ExistenceFilter getDefaultInstanceForType() {
                return ExistenceFilter.getDefaultInstance();
            }

            @Override
            public ExistenceFilter build() {
                ExistenceFilter result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public ExistenceFilter buildPartial() {
                ExistenceFilter result = new ExistenceFilter(this);
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                result.strategy_ = this.strategy_;
                result.hashes_ = this.hashes_;
                if ((this.bitField0_ & 4) != 0) {
                    this.bits_.makeImmutable();
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.bits_ = this.bits_;
                result.bitField0_ = to_bitField0_;
                this.onBuilt();
                return result;
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof ExistenceFilter) {
                    return this.mergeFrom((ExistenceFilter)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ExistenceFilter other) {
                if (other == ExistenceFilter.getDefaultInstance()) {
                    return this;
                }
                if (other.strategy_ != 0) {
                    this.setStrategyValue(other.getStrategyValue());
                }
                if (other.getHashes() != 0) {
                    this.setHashes(other.getHashes());
                }
                if (!other.bits_.isEmpty()) {
                    if (this.bits_.isEmpty()) {
                        this.bits_ = other.bits_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureBitsIsMutable();
                        this.bits_.addAll(other.bits_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                ExistenceFilter parsedMessage = null;
                try {
                    parsedMessage = (ExistenceFilter)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (ExistenceFilter)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public int getStrategyValue() {
                return this.strategy_;
            }

            public Builder setStrategyValue(int value) {
                this.strategy_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public HashStrategy getStrategy() {
                HashStrategy result = HashStrategy.forNumber(this.strategy_);
                return result == null ? HashStrategy.UNRECOGNIZED : result;
            }

            public Builder setStrategy(HashStrategy value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.strategy_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearStrategy() {
                this.strategy_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public int getHashes() {
                return this.hashes_;
            }

            public Builder setHashes(int value) {
                this.hashes_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearHashes() {
                this.hashes_ = 0;
                this.onChanged();
                return this;
            }

            private void ensureBitsIsMutable() {
                if ((this.bitField0_ & 4) == 0) {
                    this.bits_ = ExistenceFilter.mutableCopy(this.bits_);
                    this.bitField0_ |= 4;
                }
            }

            @Override
            public List<Long> getBitsList() {
                return (this.bitField0_ & 4) != 0 ? Collections.unmodifiableList(this.bits_) : this.bits_;
            }

            @Override
            public int getBitsCount() {
                return this.bits_.size();
            }

            @Override
            public long getBits(int index) {
                return this.bits_.getLong(index);
            }

            public Builder setBits(int index, long value) {
                this.ensureBitsIsMutable();
                this.bits_.setLong(index, value);
                this.onChanged();
                return this;
            }

            public Builder addBits(long value) {
                this.ensureBitsIsMutable();
                this.bits_.addLong(value);
                this.onChanged();
                return this;
            }

            public Builder addAllBits(Iterable<? extends Long> values) {
                this.ensureBitsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.bits_);
                this.onChanged();
                return this;
            }

            public Builder clearBits() {
                this.bits_ = ExistenceFilter.emptyLongList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }
        }

        private static final class MutableDefaultLoader {
            private static final Object defaultOrRuntimeException;

            private MutableDefaultLoader() {
            }

            public static MutableMessage get() {
                if (defaultOrRuntimeException instanceof RuntimeException) {
                    throw (RuntimeException)defaultOrRuntimeException;
                }
                return (MutableMessage)defaultOrRuntimeException;
            }

            static {
                Object local;
                try {
                    local = ExistenceFilter.internalMutableDefault("com.google.firebase.rules.v1.proto1api.ListReleaseExecutablesRequest$ExistenceFilter");
                }
                catch (RuntimeException e) {
                    local = e;
                }
                defaultOrRuntimeException = local;
            }
        }

        public static enum HashStrategy implements ProtocolMessageEnum
        {
            UNSPECIFIED(0),
            MURMUR128_MITZ_64(1),
            UNRECOGNIZED(-1);

            public static final int UNSPECIFIED_VALUE = 0;
            public static final int MURMUR128_MITZ_64_VALUE = 1;
            private static final Internal.EnumLiteMap<HashStrategy> internalValueMap;
            private static final HashStrategy[] VALUES;
            private final int value;

            @Override
            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            public static HashStrategy forNumber(int value) {
                switch (value) {
                    case 0: {
                        return UNSPECIFIED;
                    }
                    case 1: {
                        return MURMUR128_MITZ_64;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<HashStrategy> internalGetValueMap() {
                return internalValueMap;
            }

            @Override
            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                return HashStrategy.getDescriptor().getValues().get(this.ordinal());
            }

            @Override
            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return HashStrategy.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return ExistenceFilter.getDescriptor().getEnumTypes().get(0);
            }

            public static HashStrategy valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != HashStrategy.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private HashStrategy(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<HashStrategy>(){

                    @Override
                    public HashStrategy findValueByNumber(int number) {
                        return HashStrategy.forNumber(number);
                    }
                };
                VALUES = HashStrategy.values();
            }
        }
    }

    public static interface ExistenceFilterOrBuilder
    extends MessageOrBuilder {
        public int getStrategyValue();

        public ExistenceFilter.HashStrategy getStrategy();

        public int getHashes();

        public List<Long> getBitsList();

        public int getBitsCount();

        public long getBits(int var1);
    }

    public static final class ReleaseUpdateId
    extends GeneratedMessage
    implements ReleaseUpdateIdOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int NAME_FIELD_NUMBER = 1;
        private volatile Object name_;
        public static final int UPDATE_TIME_FIELD_NUMBER = 2;
        private Timestamp updateTime_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ReleaseUpdateId DEFAULT_INSTANCE = new ReleaseUpdateId();
        private static final Parser<ReleaseUpdateId> PARSER = new AbstractParser<ReleaseUpdateId>(){

            @Override
            public ReleaseUpdateId parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                if (usingExperimentalRuntime) {
                    ReleaseUpdateId msg = new ReleaseUpdateId();
                    msg.mergeFromInternal(input, extensionRegistry);
                    msg.makeImmutableInternal();
                    return msg;
                }
                return new ReleaseUpdateId(input, extensionRegistry);
            }
        };

        private ReleaseUpdateId(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private ReleaseUpdateId() {
            this.name_ = "";
        }

        @Override
        protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
            return new ReleaseUpdateId();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private ReleaseUpdateId(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            boolean mutable_bitField0_ = false;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            String s = input.readStringRequireUtf8();
                            this.name_ = s;
                            continue block11;
                        }
                        case 18: {
                            Timestamp.Builder subBuilder = null;
                            if (this.updateTime_ != null) {
                                subBuilder = this.updateTime_.toBuilder();
                            }
                            this.updateTime_ = input.readMessage(Timestamp.parser(), extensionRegistry);
                            if (subBuilder == null) continue block11;
                            subBuilder.mergeFrom(this.updateTime_);
                            this.updateTime_ = subBuilder.buildPartial();
                            continue block11;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
            }
            finally {
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ReleaseUpdateId_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ReleaseUpdateId_fieldAccessorTable.ensureFieldAccessorsInitialized(ReleaseUpdateId.class, Builder.class);
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.name_ = s;
            return s;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasUpdateTime() {
            return this.updateTime_ != null;
        }

        @Override
        public Timestamp getUpdateTime() {
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            return this.getUpdateTime();
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (usingExperimentalRuntime) {
                this.writeToInternal(output);
                return;
            }
            if (!this.getNameBytes().isEmpty()) {
                GeneratedMessage.writeString(output, 1, this.name_);
            }
            if (this.updateTime_ != null) {
                output.writeMessage(2, this.getUpdateTime());
            }
            this.unknownFields.writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            if (usingExperimentalRuntime) {
                this.memoizedSize = this.getSerializedSizeInternal();
                return this.memoizedSize;
            }
            size = 0;
            if (!this.getNameBytes().isEmpty()) {
                size += GeneratedMessage.computeStringSize(1, this.name_);
            }
            if (this.updateTime_ != null) {
                size += CodedOutputStream.computeMessageSize(2, this.getUpdateTime());
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReleaseUpdateId)) {
                return super.equals(obj);
            }
            ReleaseUpdateId other = (ReleaseUpdateId)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (this.hasUpdateTime() != other.hasUpdateTime()) {
                return false;
            }
            if (this.hasUpdateTime() && !this.getUpdateTime().equals(other.getUpdateTime())) {
                return false;
            }
            return this.unknownFields.equals(other.unknownFields);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ReleaseUpdateId.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getName().hashCode();
            if (this.hasUpdateTime()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getUpdateTime().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        @Override
        protected MutableMessage internalMutableDefault() {
            return MutableDefaultLoader.get();
        }

        public static ReleaseUpdateId parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ReleaseUpdateId parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ReleaseUpdateId parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ReleaseUpdateId parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ReleaseUpdateId parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ReleaseUpdateId parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ReleaseUpdateId parseFrom(InputStream input) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static ReleaseUpdateId parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static ReleaseUpdateId parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static ReleaseUpdateId parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static ReleaseUpdateId parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static ReleaseUpdateId parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return ReleaseUpdateId.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ReleaseUpdateId prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ReleaseUpdateId getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ReleaseUpdateId> parser() {
            return PARSER;
        }

        public Parser<ReleaseUpdateId> getParserForType() {
            return PARSER;
        }

        @Override
        public ReleaseUpdateId getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements ReleaseUpdateIdOrBuilder {
            private Object name_ = "";
            private Timestamp updateTime_;
            private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ReleaseUpdateId_descriptor;
            }

            @Override
            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ReleaseUpdateId_fieldAccessorTable.ensureFieldAccessorsInitialized(ReleaseUpdateId.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessage.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            @Override
            public Builder clear() {
                super.clear();
                this.name_ = "";
                if (this.updateTimeBuilder_ == null) {
                    this.updateTime_ = null;
                } else {
                    this.updateTime_ = null;
                    this.updateTimeBuilder_ = null;
                }
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return FirebaseRulesProto.internal_static_google_firebase_rules_v1_ListReleaseExecutablesRequest_ReleaseUpdateId_descriptor;
            }

            @Override
            public ReleaseUpdateId getDefaultInstanceForType() {
                return ReleaseUpdateId.getDefaultInstance();
            }

            @Override
            public ReleaseUpdateId build() {
                ReleaseUpdateId result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public ReleaseUpdateId buildPartial() {
                ReleaseUpdateId result = new ReleaseUpdateId(this);
                result.name_ = this.name_;
                if (this.updateTimeBuilder_ == null) {
                    result.updateTime_ = this.updateTime_;
                } else {
                    result.updateTime_ = this.updateTimeBuilder_.build();
                }
                this.onBuilt();
                return result;
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof ReleaseUpdateId) {
                    return this.mergeFrom((ReleaseUpdateId)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ReleaseUpdateId other) {
                if (other == ReleaseUpdateId.getDefaultInstance()) {
                    return this;
                }
                if (!other.getName().isEmpty()) {
                    this.name_ = other.name_;
                    this.onChanged();
                }
                if (other.hasUpdateTime()) {
                    this.mergeUpdateTime(other.getUpdateTime());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                ReleaseUpdateId parsedMessage = null;
                try {
                    parsedMessage = (ReleaseUpdateId)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (ReleaseUpdateId)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public String getName() {
                Object ref = this.name_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.name_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNameBytes() {
                Object ref = this.name_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.name_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.name_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearName() {
                this.name_ = ReleaseUpdateId.getDefaultInstance().getName();
                this.onChanged();
                return this;
            }

            public Builder setNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ReleaseUpdateId.checkByteStringIsUtf8(value);
                this.name_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasUpdateTime() {
                return this.updateTimeBuilder_ != null || this.updateTime_ != null;
            }

            @Override
            public Timestamp getUpdateTime() {
                if (this.updateTimeBuilder_ == null) {
                    return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
                }
                return this.updateTimeBuilder_.getMessage();
            }

            public Builder setUpdateTime(Timestamp value) {
                if (this.updateTimeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.updateTime_ = value;
                    this.onChanged();
                } else {
                    this.updateTimeBuilder_.setMessage(value);
                }
                return this;
            }

            public Builder setUpdateTime(Timestamp.Builder builderForValue) {
                if (this.updateTimeBuilder_ == null) {
                    this.updateTime_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.updateTimeBuilder_.setMessage(builderForValue.build());
                }
                return this;
            }

            public Builder mergeUpdateTime(Timestamp value) {
                if (this.updateTimeBuilder_ == null) {
                    this.updateTime_ = this.updateTime_ != null ? Timestamp.newBuilder(this.updateTime_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else {
                    this.updateTimeBuilder_.mergeFrom(value);
                }
                return this;
            }

            public Builder clearUpdateTime() {
                if (this.updateTimeBuilder_ == null) {
                    this.updateTime_ = null;
                    this.onChanged();
                } else {
                    this.updateTime_ = null;
                    this.updateTimeBuilder_ = null;
                }
                return this;
            }

            public Timestamp.Builder getUpdateTimeBuilder() {
                this.onChanged();
                return this.getUpdateTimeFieldBuilder().getBuilder();
            }

            @Override
            public TimestampOrBuilder getUpdateTimeOrBuilder() {
                if (this.updateTimeBuilder_ != null) {
                    return this.updateTimeBuilder_.getMessageOrBuilder();
                }
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }

            private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
                if (this.updateTimeBuilder_ == null) {
                    this.updateTimeBuilder_ = new SingleFieldBuilder(this.getUpdateTime(), this.getParentForChildren(), this.isClean());
                    this.updateTime_ = null;
                }
                return this.updateTimeBuilder_;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }
        }

        private static final class MutableDefaultLoader {
            private static final Object defaultOrRuntimeException;

            private MutableDefaultLoader() {
            }

            public static MutableMessage get() {
                if (defaultOrRuntimeException instanceof RuntimeException) {
                    throw (RuntimeException)defaultOrRuntimeException;
                }
                return (MutableMessage)defaultOrRuntimeException;
            }

            static {
                Object local;
                try {
                    local = ReleaseUpdateId.internalMutableDefault("com.google.firebase.rules.v1.proto1api.ListReleaseExecutablesRequest$ReleaseUpdateId");
                }
                catch (RuntimeException e) {
                    local = e;
                }
                defaultOrRuntimeException = local;
            }
        }
    }

    public static interface ReleaseUpdateIdOrBuilder
    extends MessageOrBuilder {
        public String getName();

        public ByteString getNameBytes();

        public boolean hasUpdateTime();

        public Timestamp getUpdateTime();

        public TimestampOrBuilder getUpdateTimeOrBuilder();
    }
}

