/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.validations;

import com.google.common.base.Strings;
import com.google.firebase.rules.exceptions.PermissionDeniedException;
import com.google.firebase.rules.exceptions.ResourceExhaustedException;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.firebase.rules.validations.ValidationException;
import com.google.i18n.MessageReference;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;

public class Validator {
    private static final ConcurrentHashMap<Locale, Validator> validators = new ConcurrentHashMap();
    private final Locale locale;

    private Validator(Locale locale) {
        this.locale = locale;
    }

    public <T> T checkNotNull(T value, MessageReference messageReference, String ... params) throws ValidationException {
        if (value == null) {
            throw new ValidationException(messageReference.getMessage(this.locale).toString(params));
        }
        return value;
    }

    public String checkNotBlank(String value, MessageReference messageReference, String ... params) throws ValidationException {
        if (Strings.isNullOrEmpty(value)) {
            throw new ValidationException(messageReference.getMessage(this.locale).toString(params));
        }
        return value;
    }

    public void checkArgument(boolean bool, MessageReference messageReference, String ... params) throws ValidationException {
        if (!bool) {
            throw new ValidationException(messageReference.getMessage(this.locale).toString(params));
        }
    }

    @CheckReturnValue
    public ValidationException fail(MessageReference messageReference, String ... params) {
        return new ValidationException(messageReference.getMessage(this.locale).toString(params));
    }

    @CheckReturnValue
    public PermissionDeniedException permissionDenied() {
        return new PermissionDeniedException(FirebaseRulesMessages.ACCESS_DENIED.get(this.locale).toString());
    }

    @CheckReturnValue
    public ResourceExhaustedException resourceExhausted(MessageReference messageReference, String ... params) {
        return new ResourceExhaustedException(messageReference.getMessage(this.locale).toString(params));
    }

    public static Validator getValidator(Locale locale) {
        return validators.computeIfAbsent(locale, Validator::new);
    }
}

