/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1;

import com.google.common.inject.Providers;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.FirestoreProto;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.GetOrListDocumentsRequest;
import com.google.firestore.v1.GetOrListDocumentsResponse;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.net.rpc3.RpcException;
import com.google.net.rpc3.client.RpcCallback;
import com.google.net.rpc3.client.RpcClientContext;
import com.google.net.rpc3.client.RpcDefaultStubCreationFilter;
import com.google.net.rpc3.client.RpcFuture;
import com.google.net.rpc3.client.RpcStub;
import com.google.net.rpc3.client.RpcStubCreationFilter;
import com.google.net.rpc3.client.RpcStubDescriptor;
import com.google.net.rpc3.client.RpcStubParameters;
import com.google.net.rpc3.impl.RpcUtil;
import com.google.net.rpc3.impl.server.RpcApplicationHandler;
import com.google.net.rpc3.impl.server.RpcBlockingApplicationHandler;
import com.google.net.rpc3.impl.server.RpcStreamCreationHandler;
import com.google.net.rpc3.server.RpcServerContext;
import com.google.net.rpc3.server.RpcServiceMethodParameters;
import com.google.net.rpc3.server.RpcServiceParameters;
import com.google.net.rpc3.stream.RpcClientStreamContext;
import com.google.net.rpc3.stream.RpcServerStreamContext;
import com.google.net.ssl.SslSecurityLevel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import com.google.protobuf.MessageLite;
import javax.inject.Provider;

public final class Firestore {
    private static volatile RpcStubCreationFilter stubCreationFilter_ = new RpcDefaultStubCreationFilter();
    private static final RpcStubDescriptor stubDescriptor_ = new RpcStubDescriptor(){

        public RpcStubCreationFilter getStubCreationFilter() {
            return stubCreationFilter_;
        }

        public double getFailureDetectionDelay() {
            return -1.0;
        }

        public String getDefaultServiceName() {
            return "Firestore";
        }
    };

    private Firestore() {
    }

    public static void setStubCreationFilter(RpcStubCreationFilter filter) {
        stubCreationFilter_ = filter == null ? new RpcDefaultStubCreationFilter() : filter;
    }

    public static RpcStubDescriptor getStubDescriptor() {
        return stubDescriptor_;
    }

    public static Descriptors.ServiceDescriptor getServiceDescriptor() {
        return FirestoreProto.getDescriptor().findServiceByName("Firestore");
    }

    public static Stub newStub(RpcStubParameters params) {
        return new Stub(params);
    }

    public static Stub newStub(String serviceSpec) {
        return new Stub(serviceSpec);
    }

    public static ServiceParameters newService(ServerInterface impl) {
        return Firestore.newService(Providers.of((Object)impl));
    }

    public static ServiceParameters newService(Provider<? extends ServerInterface> provider) {
        return new ServiceParameters().exportMethodsForService(provider);
    }

    public static ServiceParameters newBlockingService(BlockingServerInterface impl) {
        return Firestore.newBlockingService(Providers.of((Object)impl));
    }

    public static ServiceParameters newBlockingService(Provider<? extends BlockingServerInterface> provider) {
        return new ServiceParameters().exportMethodsForBlockingService(provider);
    }

    public static final class ServiceParameters
    extends RpcServiceParameters {
        private final RpcServiceMethodParameters GetOrListDocuments_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters GetDocument_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters ListDocuments_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters CreateDocument_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters UpdateDocument_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters DeleteDocument_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters BeginTransaction_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters Commit_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters Rollback_parameters_ = new RpcServiceMethodParameters();
        private final RpcServiceMethodParameters ListCollectionIds_parameters_ = new RpcServiceMethodParameters();

        private ServiceParameters() {
            super("Firestore");
            this.setProtoPackageName("google.firestore.v1");
        }

        private ServiceParameters exportMethodsForService(final Provider<? extends ServerInterface> service) {
            this.registerMethod("GetOrListDocuments", GetOrListDocumentsRequest.getDefaultInstance(), GetOrListDocumentsResponse.getDefaultInstance(), null, this.GetOrListDocuments_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).getOrListDocuments(ctx, (GetOrListDocumentsRequest)request);
                }
            });
            this.registerMethod("GetDocument", GetDocumentRequest.getDefaultInstance(), Document.getDefaultInstance(), null, this.GetDocument_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).getDocument(ctx, (GetDocumentRequest)request);
                }
            });
            this.registerMethod("ListDocuments", ListDocumentsRequest.getDefaultInstance(), ListDocumentsResponse.getDefaultInstance(), null, this.ListDocuments_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).listDocuments(ctx, (ListDocumentsRequest)request);
                }
            });
            this.registerMethod("CreateDocument", CreateDocumentRequest.getDefaultInstance(), Document.getDefaultInstance(), null, this.CreateDocument_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).createDocument(ctx, (CreateDocumentRequest)request);
                }
            });
            this.registerMethod("UpdateDocument", UpdateDocumentRequest.getDefaultInstance(), Document.getDefaultInstance(), null, this.UpdateDocument_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).updateDocument(ctx, (UpdateDocumentRequest)request);
                }
            });
            this.registerMethod("DeleteDocument", DeleteDocumentRequest.getDefaultInstance(), Empty.getDefaultInstance(), null, this.DeleteDocument_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).deleteDocument(ctx, (DeleteDocumentRequest)request);
                }
            });
            this.registerMethod("BeginTransaction", BeginTransactionRequest.getDefaultInstance(), BeginTransactionResponse.getDefaultInstance(), null, this.BeginTransaction_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).beginTransaction(ctx, (BeginTransactionRequest)request);
                }
            });
            this.registerMethod("Commit", CommitRequest.getDefaultInstance(), CommitResponse.getDefaultInstance(), null, this.Commit_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).commit(ctx, (CommitRequest)request);
                }
            });
            this.registerMethod("Rollback", RollbackRequest.getDefaultInstance(), Empty.getDefaultInstance(), null, this.Rollback_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).rollback(ctx, (RollbackRequest)request);
                }
            });
            this.registerMethod("ListCollectionIds", ListCollectionIdsRequest.getDefaultInstance(), ListCollectionIdsResponse.getDefaultInstance(), null, this.ListCollectionIds_parameters_, new RpcApplicationHandler(this){

                public void handleRequest(RpcServerContext ctx, MessageLite request) {
                    ((ServerInterface)service.get()).listCollectionIds(ctx, (ListCollectionIdsRequest)request);
                }
            });
            this.registerStream("BatchGetDocuments", BatchGetDocumentsResponse.getDefaultInstance(), BatchGetDocumentsRequest.getDefaultInstance(), "byte", 0x300000L, -1L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((ServerInterface)service.get()).batchGetDocuments((RpcServerStreamContext<BatchGetDocumentsResponse, BatchGetDocumentsRequest>)ctx);
                }
            });
            this.registerStream("RunQuery", RunQueryResponse.getDefaultInstance(), RunQueryRequest.getDefaultInstance(), "byte", 0x300000L, -1L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((ServerInterface)service.get()).runQuery((RpcServerStreamContext<RunQueryResponse, RunQueryRequest>)ctx);
                }
            });
            this.registerStream("Write", WriteResponse.getDefaultInstance(), WriteRequest.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((ServerInterface)service.get()).write((RpcServerStreamContext<WriteResponse, WriteRequest>)ctx);
                }
            });
            this.registerStream("Listen", ListenResponse.getDefaultInstance(), ListenRequest.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((ServerInterface)service.get()).listen((RpcServerStreamContext<ListenResponse, ListenRequest>)ctx);
                }
            });
            return this;
        }

        private ServiceParameters exportMethodsForBlockingService(final Provider<? extends BlockingServerInterface> service) {
            this.registerMethod("GetOrListDocuments", GetOrListDocumentsRequest.getDefaultInstance(), GetOrListDocumentsResponse.getDefaultInstance(), null, this.GetOrListDocuments_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public GetOrListDocumentsResponse handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).getOrListDocuments(ctx, (GetOrListDocumentsRequest)request);
                }
            });
            this.registerMethod("GetDocument", GetDocumentRequest.getDefaultInstance(), Document.getDefaultInstance(), null, this.GetDocument_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public Document handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).getDocument(ctx, (GetDocumentRequest)request);
                }
            });
            this.registerMethod("ListDocuments", ListDocumentsRequest.getDefaultInstance(), ListDocumentsResponse.getDefaultInstance(), null, this.ListDocuments_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public ListDocumentsResponse handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).listDocuments(ctx, (ListDocumentsRequest)request);
                }
            });
            this.registerMethod("CreateDocument", CreateDocumentRequest.getDefaultInstance(), Document.getDefaultInstance(), null, this.CreateDocument_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public Document handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).createDocument(ctx, (CreateDocumentRequest)request);
                }
            });
            this.registerMethod("UpdateDocument", UpdateDocumentRequest.getDefaultInstance(), Document.getDefaultInstance(), null, this.UpdateDocument_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public Document handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).updateDocument(ctx, (UpdateDocumentRequest)request);
                }
            });
            this.registerMethod("DeleteDocument", DeleteDocumentRequest.getDefaultInstance(), Empty.getDefaultInstance(), null, this.DeleteDocument_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public Empty handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).deleteDocument(ctx, (DeleteDocumentRequest)request);
                }
            });
            this.registerMethod("BeginTransaction", BeginTransactionRequest.getDefaultInstance(), BeginTransactionResponse.getDefaultInstance(), null, this.BeginTransaction_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public BeginTransactionResponse handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).beginTransaction(ctx, (BeginTransactionRequest)request);
                }
            });
            this.registerMethod("Commit", CommitRequest.getDefaultInstance(), CommitResponse.getDefaultInstance(), null, this.Commit_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public CommitResponse handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).commit(ctx, (CommitRequest)request);
                }
            });
            this.registerMethod("Rollback", RollbackRequest.getDefaultInstance(), Empty.getDefaultInstance(), null, this.Rollback_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public Empty handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).rollback(ctx, (RollbackRequest)request);
                }
            });
            this.registerMethod("ListCollectionIds", ListCollectionIdsRequest.getDefaultInstance(), ListCollectionIdsResponse.getDefaultInstance(), null, this.ListCollectionIds_parameters_, (RpcApplicationHandler)new RpcBlockingApplicationHandler(this){

                public ListCollectionIdsResponse handleBlockingRequest(RpcServerContext ctx, MessageLite request) throws RpcException {
                    return ((BlockingServerInterface)service.get()).listCollectionIds(ctx, (ListCollectionIdsRequest)request);
                }
            });
            this.registerStream("BatchGetDocuments", BatchGetDocumentsResponse.getDefaultInstance(), BatchGetDocumentsRequest.getDefaultInstance(), "byte", 0x300000L, -1L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((BlockingServerInterface)service.get()).batchGetDocuments((RpcServerStreamContext<BatchGetDocumentsResponse, BatchGetDocumentsRequest>)ctx);
                }
            });
            this.registerStream("RunQuery", RunQueryResponse.getDefaultInstance(), RunQueryRequest.getDefaultInstance(), "byte", 0x300000L, -1L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((BlockingServerInterface)service.get()).runQuery((RpcServerStreamContext<RunQueryResponse, RunQueryRequest>)ctx);
                }
            });
            this.registerStream("Write", WriteResponse.getDefaultInstance(), WriteRequest.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((BlockingServerInterface)service.get()).write((RpcServerStreamContext<WriteResponse, WriteRequest>)ctx);
                }
            });
            this.registerStream("Listen", ListenResponse.getDefaultInstance(), ListenRequest.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, null, -1, new RpcStreamCreationHandler(this){

                public void newStream(RpcServerStreamContext ctx) {
                    ((BlockingServerInterface)service.get()).listen((RpcServerStreamContext<ListenResponse, ListenRequest>)ctx);
                }
            });
            return this;
        }

        public RpcServiceMethodParameters getMethod_GetOrListDocuments() {
            return this.GetOrListDocuments_parameters_;
        }

        public RpcServiceMethodParameters getMethod_GetDocument() {
            return this.GetDocument_parameters_;
        }

        public RpcServiceMethodParameters getMethod_ListDocuments() {
            return this.ListDocuments_parameters_;
        }

        public RpcServiceMethodParameters getMethod_CreateDocument() {
            return this.CreateDocument_parameters_;
        }

        public RpcServiceMethodParameters getMethod_UpdateDocument() {
            return this.UpdateDocument_parameters_;
        }

        public RpcServiceMethodParameters getMethod_DeleteDocument() {
            return this.DeleteDocument_parameters_;
        }

        public RpcServiceMethodParameters getMethod_BeginTransaction() {
            return this.BeginTransaction_parameters_;
        }

        public RpcServiceMethodParameters getMethod_Commit() {
            return this.Commit_parameters_;
        }

        public RpcServiceMethodParameters getMethod_Rollback() {
            return this.Rollback_parameters_;
        }

        public RpcServiceMethodParameters getMethod_ListCollectionIds() {
            return this.ListCollectionIds_parameters_;
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return Firestore.getServiceDescriptor();
        }
    }

    public static abstract class BaseServerImpl
    implements ServerInterface {
        @Override
        public void getOrListDocuments(RpcServerContext ctx, GetOrListDocumentsRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void getDocument(RpcServerContext ctx, GetDocumentRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void listDocuments(RpcServerContext ctx, ListDocumentsRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void createDocument(RpcServerContext ctx, CreateDocumentRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void updateDocument(RpcServerContext ctx, UpdateDocumentRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void deleteDocument(RpcServerContext ctx, DeleteDocumentRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void beginTransaction(RpcServerContext ctx, BeginTransactionRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void commit(RpcServerContext ctx, CommitRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void rollback(RpcServerContext ctx, RollbackRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void listCollectionIds(RpcServerContext ctx, ListCollectionIdsRequest req) {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
        }

        @Override
        public void batchGetDocuments(RpcServerStreamContext<BatchGetDocumentsResponse, BatchGetDocumentsRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void runQuery(RpcServerStreamContext<RunQueryResponse, RunQueryRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void write(RpcServerStreamContext<WriteResponse, WriteRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void listen(RpcServerStreamContext<ListenResponse, ListenRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static abstract class BaseBlockingServerImpl
    implements BlockingServerInterface {
        @Override
        public GetOrListDocumentsResponse getOrListDocuments(RpcServerContext ctx, GetOrListDocumentsRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public Document getDocument(RpcServerContext ctx, GetDocumentRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public ListDocumentsResponse listDocuments(RpcServerContext ctx, ListDocumentsRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public Document createDocument(RpcServerContext ctx, CreateDocumentRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public Document updateDocument(RpcServerContext ctx, UpdateDocumentRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public Empty deleteDocument(RpcServerContext ctx, DeleteDocumentRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public BeginTransactionResponse beginTransaction(RpcServerContext ctx, BeginTransactionRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public CommitResponse commit(RpcServerContext ctx, CommitRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public Empty rollback(RpcServerContext ctx, RollbackRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public ListCollectionIdsResponse listCollectionIds(RpcServerContext ctx, ListCollectionIdsRequest req) throws RpcException {
            RpcUtil.serviceMethodNotImplemented((RpcServerContext)ctx);
            return null;
        }

        @Override
        public void batchGetDocuments(RpcServerStreamContext<BatchGetDocumentsResponse, BatchGetDocumentsRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void runQuery(RpcServerStreamContext<RunQueryResponse, RunQueryRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void write(RpcServerStreamContext<WriteResponse, WriteRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void listen(RpcServerStreamContext<ListenResponse, ListenRequest> ctx) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static interface ServerInterface {
        public void getOrListDocuments(RpcServerContext var1, GetOrListDocumentsRequest var2);

        public void getDocument(RpcServerContext var1, GetDocumentRequest var2);

        public void listDocuments(RpcServerContext var1, ListDocumentsRequest var2);

        public void createDocument(RpcServerContext var1, CreateDocumentRequest var2);

        public void updateDocument(RpcServerContext var1, UpdateDocumentRequest var2);

        public void deleteDocument(RpcServerContext var1, DeleteDocumentRequest var2);

        public void beginTransaction(RpcServerContext var1, BeginTransactionRequest var2);

        public void commit(RpcServerContext var1, CommitRequest var2);

        public void rollback(RpcServerContext var1, RollbackRequest var2);

        public void listCollectionIds(RpcServerContext var1, ListCollectionIdsRequest var2);

        public void batchGetDocuments(RpcServerStreamContext<BatchGetDocumentsResponse, BatchGetDocumentsRequest> var1);

        public void runQuery(RpcServerStreamContext<RunQueryResponse, RunQueryRequest> var1);

        public void write(RpcServerStreamContext<WriteResponse, WriteRequest> var1);

        public void listen(RpcServerStreamContext<ListenResponse, ListenRequest> var1);
    }

    public static interface BlockingServerInterface {
        public GetOrListDocumentsResponse getOrListDocuments(RpcServerContext var1, GetOrListDocumentsRequest var2) throws RpcException;

        public Document getDocument(RpcServerContext var1, GetDocumentRequest var2) throws RpcException;

        public ListDocumentsResponse listDocuments(RpcServerContext var1, ListDocumentsRequest var2) throws RpcException;

        public Document createDocument(RpcServerContext var1, CreateDocumentRequest var2) throws RpcException;

        public Document updateDocument(RpcServerContext var1, UpdateDocumentRequest var2) throws RpcException;

        public Empty deleteDocument(RpcServerContext var1, DeleteDocumentRequest var2) throws RpcException;

        public BeginTransactionResponse beginTransaction(RpcServerContext var1, BeginTransactionRequest var2) throws RpcException;

        public CommitResponse commit(RpcServerContext var1, CommitRequest var2) throws RpcException;

        public Empty rollback(RpcServerContext var1, RollbackRequest var2) throws RpcException;

        public ListCollectionIdsResponse listCollectionIds(RpcServerContext var1, ListCollectionIdsRequest var2) throws RpcException;

        public void batchGetDocuments(RpcServerStreamContext<BatchGetDocumentsResponse, BatchGetDocumentsRequest> var1);

        public void runQuery(RpcServerStreamContext<RunQueryResponse, RunQueryRequest> var1);

        public void write(RpcServerStreamContext<WriteResponse, WriteRequest> var1);

        public void listen(RpcServerStreamContext<ListenResponse, ListenRequest> var1);
    }

    public static class Stub
    extends RpcStub
    implements ClientInterface {
        private final FutureInterface futureInterface = new FutureInterface(){

            @Override
            public RpcFuture<GetOrListDocumentsResponse> getOrListDocuments(RpcClientContext ctx, GetOrListDocumentsRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.GetOrListDocuments_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<Document> getDocument(RpcClientContext ctx, GetDocumentRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.GetDocument_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<ListDocumentsResponse> listDocuments(RpcClientContext ctx, ListDocumentsRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.ListDocuments_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<Document> createDocument(RpcClientContext ctx, CreateDocumentRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.CreateDocument_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<Document> updateDocument(RpcClientContext ctx, UpdateDocumentRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.UpdateDocument_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<Empty> deleteDocument(RpcClientContext ctx, DeleteDocumentRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.DeleteDocument_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<BeginTransactionResponse> beginTransaction(RpcClientContext ctx, BeginTransactionRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.BeginTransaction_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<CommitResponse> commit(RpcClientContext ctx, CommitRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.Commit_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<Empty> rollback(RpcClientContext ctx, RollbackRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.Rollback_method_, ctx, req, (RpcCallback)future);
                return future;
            }

            @Override
            public RpcFuture<ListCollectionIdsResponse> listCollectionIds(RpcClientContext ctx, ListCollectionIdsRequest req) {
                RpcStub.RpcFutureImpl future = new RpcStub.RpcFutureImpl(ctx);
                Stub.this.startNonBlockingRpc(Stub.this.ListCollectionIds_method_, ctx, req, (RpcCallback)future);
                return future;
            }
        };
        protected final RpcStub.MethodDef GetOrListDocuments_method_ = this.newMethodDef("GetOrListDocuments", Method.GetOrListDocuments, GetOrListDocumentsResponse.getDefaultInstance(), null);
        protected final RpcStub.MethodDef GetDocument_method_;
        protected final RpcStub.MethodDef ListDocuments_method_;
        protected final RpcStub.MethodDef CreateDocument_method_;
        protected final RpcStub.MethodDef UpdateDocument_method_;
        protected final RpcStub.MethodDef DeleteDocument_method_;
        protected final RpcStub.MethodDef BeginTransaction_method_;
        protected final RpcStub.MethodDef Commit_method_;
        protected final RpcStub.MethodDef Rollback_method_;
        protected final RpcStub.MethodDef ListCollectionIds_method_;
        protected final RpcStub.StreamDef BatchGetDocuments_stream_;
        protected final RpcStub.StreamDef RunQuery_stream_;
        protected final RpcStub.StreamDef Write_stream_;
        protected final RpcStub.StreamDef Listen_stream_;

        Stub(RpcStubParameters params) {
            super(stubDescriptor_, params, Method.class);
            this.GetOrListDocuments_method_.setProtoPackageName("google.firestore.v1");
            this.GetDocument_method_ = this.newMethodDef("GetDocument", Method.GetDocument, Document.getDefaultInstance(), null);
            this.GetDocument_method_.setProtoPackageName("google.firestore.v1");
            this.ListDocuments_method_ = this.newMethodDef("ListDocuments", Method.ListDocuments, ListDocumentsResponse.getDefaultInstance(), null);
            this.ListDocuments_method_.setProtoPackageName("google.firestore.v1");
            this.CreateDocument_method_ = this.newMethodDef("CreateDocument", Method.CreateDocument, Document.getDefaultInstance(), null);
            this.CreateDocument_method_.setProtoPackageName("google.firestore.v1");
            this.UpdateDocument_method_ = this.newMethodDef("UpdateDocument", Method.UpdateDocument, Document.getDefaultInstance(), null);
            this.UpdateDocument_method_.setProtoPackageName("google.firestore.v1");
            this.DeleteDocument_method_ = this.newMethodDef("DeleteDocument", Method.DeleteDocument, Empty.getDefaultInstance(), null);
            this.DeleteDocument_method_.setProtoPackageName("google.firestore.v1");
            this.BeginTransaction_method_ = this.newMethodDef("BeginTransaction", Method.BeginTransaction, BeginTransactionResponse.getDefaultInstance(), null);
            this.BeginTransaction_method_.setProtoPackageName("google.firestore.v1");
            this.Commit_method_ = this.newMethodDef("Commit", Method.Commit, CommitResponse.getDefaultInstance(), null);
            this.Commit_method_.setProtoPackageName("google.firestore.v1");
            this.Rollback_method_ = this.newMethodDef("Rollback", Method.Rollback, Empty.getDefaultInstance(), null);
            this.Rollback_method_.setProtoPackageName("google.firestore.v1");
            this.ListCollectionIds_method_ = this.newMethodDef("ListCollectionIds", Method.ListCollectionIds, ListCollectionIdsResponse.getDefaultInstance(), null);
            this.ListCollectionIds_method_.setProtoPackageName("google.firestore.v1");
            this.BatchGetDocuments_stream_ = this.newStreamDef("BatchGetDocuments", BatchGetDocumentsRequest.getDefaultInstance(), BatchGetDocumentsResponse.getDefaultInstance(), "byte", -1L, 0x300000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.BatchGetDocuments_stream_.setProtoPackageName("google.firestore.v1");
            this.RunQuery_stream_ = this.newStreamDef("RunQuery", RunQueryRequest.getDefaultInstance(), RunQueryResponse.getDefaultInstance(), "byte", -1L, 0x300000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.RunQuery_stream_.setProtoPackageName("google.firestore.v1");
            this.Write_stream_ = this.newStreamDef("Write", WriteRequest.getDefaultInstance(), WriteResponse.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.Write_stream_.setProtoPackageName("google.firestore.v1");
            this.Listen_stream_ = this.newStreamDef("Listen", ListenRequest.getDefaultInstance(), ListenResponse.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.Listen_stream_.setProtoPackageName("google.firestore.v1");
        }

        Stub(String serviceSpec) {
            super(stubDescriptor_, Stub.createParamsForVstub((String)serviceSpec), Method.class);
            this.GetOrListDocuments_method_.setProtoPackageName("google.firestore.v1");
            this.GetDocument_method_ = this.newMethodDef("GetDocument", Method.GetDocument, Document.getDefaultInstance(), null);
            this.GetDocument_method_.setProtoPackageName("google.firestore.v1");
            this.ListDocuments_method_ = this.newMethodDef("ListDocuments", Method.ListDocuments, ListDocumentsResponse.getDefaultInstance(), null);
            this.ListDocuments_method_.setProtoPackageName("google.firestore.v1");
            this.CreateDocument_method_ = this.newMethodDef("CreateDocument", Method.CreateDocument, Document.getDefaultInstance(), null);
            this.CreateDocument_method_.setProtoPackageName("google.firestore.v1");
            this.UpdateDocument_method_ = this.newMethodDef("UpdateDocument", Method.UpdateDocument, Document.getDefaultInstance(), null);
            this.UpdateDocument_method_.setProtoPackageName("google.firestore.v1");
            this.DeleteDocument_method_ = this.newMethodDef("DeleteDocument", Method.DeleteDocument, Empty.getDefaultInstance(), null);
            this.DeleteDocument_method_.setProtoPackageName("google.firestore.v1");
            this.BeginTransaction_method_ = this.newMethodDef("BeginTransaction", Method.BeginTransaction, BeginTransactionResponse.getDefaultInstance(), null);
            this.BeginTransaction_method_.setProtoPackageName("google.firestore.v1");
            this.Commit_method_ = this.newMethodDef("Commit", Method.Commit, CommitResponse.getDefaultInstance(), null);
            this.Commit_method_.setProtoPackageName("google.firestore.v1");
            this.Rollback_method_ = this.newMethodDef("Rollback", Method.Rollback, Empty.getDefaultInstance(), null);
            this.Rollback_method_.setProtoPackageName("google.firestore.v1");
            this.ListCollectionIds_method_ = this.newMethodDef("ListCollectionIds", Method.ListCollectionIds, ListCollectionIdsResponse.getDefaultInstance(), null);
            this.ListCollectionIds_method_.setProtoPackageName("google.firestore.v1");
            this.BatchGetDocuments_stream_ = this.newStreamDef("BatchGetDocuments", BatchGetDocumentsRequest.getDefaultInstance(), BatchGetDocumentsResponse.getDefaultInstance(), "byte", -1L, 0x300000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.BatchGetDocuments_stream_.setProtoPackageName("google.firestore.v1");
            this.RunQuery_stream_ = this.newStreamDef("RunQuery", RunQueryRequest.getDefaultInstance(), RunQueryResponse.getDefaultInstance(), "byte", -1L, 0x300000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.RunQuery_stream_.setProtoPackageName("google.firestore.v1");
            this.Write_stream_ = this.newStreamDef("Write", WriteRequest.getDefaultInstance(), WriteResponse.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.Write_stream_.setProtoPackageName("google.firestore.v1");
            this.Listen_stream_ = this.newStreamDef("Listen", ListenRequest.getDefaultInstance(), ListenResponse.getDefaultInstance(), "byte", 0xA00000L, 0xA00000L, SslSecurityLevel.INTEGRITY, -1.0, false, false, -1);
            this.Listen_stream_.setProtoPackageName("google.firestore.v1");
        }

        @Override
        public GetOrListDocumentsResponse getOrListDocuments(RpcClientContext ctx, GetOrListDocumentsRequest req) throws RpcException {
            return (GetOrListDocumentsResponse)this.startBlockingRpc(this.GetOrListDocuments_method_, ctx, req, null);
        }

        @Override
        public Document getDocument(RpcClientContext ctx, GetDocumentRequest req) throws RpcException {
            return (Document)this.startBlockingRpc(this.GetDocument_method_, ctx, req, null);
        }

        @Override
        public ListDocumentsResponse listDocuments(RpcClientContext ctx, ListDocumentsRequest req) throws RpcException {
            return (ListDocumentsResponse)this.startBlockingRpc(this.ListDocuments_method_, ctx, req, null);
        }

        @Override
        public Document createDocument(RpcClientContext ctx, CreateDocumentRequest req) throws RpcException {
            return (Document)this.startBlockingRpc(this.CreateDocument_method_, ctx, req, null);
        }

        @Override
        public Document updateDocument(RpcClientContext ctx, UpdateDocumentRequest req) throws RpcException {
            return (Document)this.startBlockingRpc(this.UpdateDocument_method_, ctx, req, null);
        }

        @Override
        public Empty deleteDocument(RpcClientContext ctx, DeleteDocumentRequest req) throws RpcException {
            return (Empty)this.startBlockingRpc(this.DeleteDocument_method_, ctx, req, null);
        }

        @Override
        public BeginTransactionResponse beginTransaction(RpcClientContext ctx, BeginTransactionRequest req) throws RpcException {
            return (BeginTransactionResponse)this.startBlockingRpc(this.BeginTransaction_method_, ctx, req, null);
        }

        @Override
        public CommitResponse commit(RpcClientContext ctx, CommitRequest req) throws RpcException {
            return (CommitResponse)this.startBlockingRpc(this.Commit_method_, ctx, req, null);
        }

        @Override
        public Empty rollback(RpcClientContext ctx, RollbackRequest req) throws RpcException {
            return (Empty)this.startBlockingRpc(this.Rollback_method_, ctx, req, null);
        }

        @Override
        public ListCollectionIdsResponse listCollectionIds(RpcClientContext ctx, ListCollectionIdsRequest req) throws RpcException {
            return (ListCollectionIdsResponse)this.startBlockingRpc(this.ListCollectionIds_method_, ctx, req, null);
        }

        @Override
        public void getOrListDocuments(RpcClientContext ctx, GetOrListDocumentsRequest req, RpcCallback<GetOrListDocumentsResponse> cb) {
            this.startNonBlockingRpc(this.GetOrListDocuments_method_, ctx, req, cb);
        }

        @Override
        public void getDocument(RpcClientContext ctx, GetDocumentRequest req, RpcCallback<Document> cb) {
            this.startNonBlockingRpc(this.GetDocument_method_, ctx, req, cb);
        }

        @Override
        public void listDocuments(RpcClientContext ctx, ListDocumentsRequest req, RpcCallback<ListDocumentsResponse> cb) {
            this.startNonBlockingRpc(this.ListDocuments_method_, ctx, req, cb);
        }

        @Override
        public void createDocument(RpcClientContext ctx, CreateDocumentRequest req, RpcCallback<Document> cb) {
            this.startNonBlockingRpc(this.CreateDocument_method_, ctx, req, cb);
        }

        @Override
        public void updateDocument(RpcClientContext ctx, UpdateDocumentRequest req, RpcCallback<Document> cb) {
            this.startNonBlockingRpc(this.UpdateDocument_method_, ctx, req, cb);
        }

        @Override
        public void deleteDocument(RpcClientContext ctx, DeleteDocumentRequest req, RpcCallback<Empty> cb) {
            this.startNonBlockingRpc(this.DeleteDocument_method_, ctx, req, cb);
        }

        @Override
        public void beginTransaction(RpcClientContext ctx, BeginTransactionRequest req, RpcCallback<BeginTransactionResponse> cb) {
            this.startNonBlockingRpc(this.BeginTransaction_method_, ctx, req, cb);
        }

        @Override
        public void commit(RpcClientContext ctx, CommitRequest req, RpcCallback<CommitResponse> cb) {
            this.startNonBlockingRpc(this.Commit_method_, ctx, req, cb);
        }

        @Override
        public void rollback(RpcClientContext ctx, RollbackRequest req, RpcCallback<Empty> cb) {
            this.startNonBlockingRpc(this.Rollback_method_, ctx, req, cb);
        }

        @Override
        public void listCollectionIds(RpcClientContext ctx, ListCollectionIdsRequest req, RpcCallback<ListCollectionIdsResponse> cb) {
            this.startNonBlockingRpc(this.ListCollectionIds_method_, ctx, req, cb);
        }

        @Override
        public RpcClientStreamContext<BatchGetDocumentsRequest, BatchGetDocumentsResponse> createBatchGetDocuments() {
            return this.createClientStreamContext(this.BatchGetDocuments_stream_);
        }

        @Override
        public RpcClientStreamContext<RunQueryRequest, RunQueryResponse> createRunQuery() {
            return this.createClientStreamContext(this.RunQuery_stream_);
        }

        @Override
        public RpcClientStreamContext<WriteRequest, WriteResponse> createWrite() {
            return this.createClientStreamContext(this.Write_stream_);
        }

        @Override
        public RpcClientStreamContext<ListenRequest, ListenResponse> createListen() {
            return this.createClientStreamContext(this.Listen_stream_);
        }

        public FutureInterface futureInterface() {
            return this.futureInterface;
        }
    }

    public static interface FutureInterface {
        public RpcFuture<GetOrListDocumentsResponse> getOrListDocuments(RpcClientContext var1, GetOrListDocumentsRequest var2);

        public RpcFuture<Document> getDocument(RpcClientContext var1, GetDocumentRequest var2);

        public RpcFuture<ListDocumentsResponse> listDocuments(RpcClientContext var1, ListDocumentsRequest var2);

        public RpcFuture<Document> createDocument(RpcClientContext var1, CreateDocumentRequest var2);

        public RpcFuture<Document> updateDocument(RpcClientContext var1, UpdateDocumentRequest var2);

        public RpcFuture<Empty> deleteDocument(RpcClientContext var1, DeleteDocumentRequest var2);

        public RpcFuture<BeginTransactionResponse> beginTransaction(RpcClientContext var1, BeginTransactionRequest var2);

        public RpcFuture<CommitResponse> commit(RpcClientContext var1, CommitRequest var2);

        public RpcFuture<Empty> rollback(RpcClientContext var1, RollbackRequest var2);

        public RpcFuture<ListCollectionIdsResponse> listCollectionIds(RpcClientContext var1, ListCollectionIdsRequest var2);
    }

    public static interface ClientInterface {
        public GetOrListDocumentsResponse getOrListDocuments(RpcClientContext var1, GetOrListDocumentsRequest var2) throws RpcException;

        public Document getDocument(RpcClientContext var1, GetDocumentRequest var2) throws RpcException;

        public ListDocumentsResponse listDocuments(RpcClientContext var1, ListDocumentsRequest var2) throws RpcException;

        public Document createDocument(RpcClientContext var1, CreateDocumentRequest var2) throws RpcException;

        public Document updateDocument(RpcClientContext var1, UpdateDocumentRequest var2) throws RpcException;

        public Empty deleteDocument(RpcClientContext var1, DeleteDocumentRequest var2) throws RpcException;

        public BeginTransactionResponse beginTransaction(RpcClientContext var1, BeginTransactionRequest var2) throws RpcException;

        public CommitResponse commit(RpcClientContext var1, CommitRequest var2) throws RpcException;

        public Empty rollback(RpcClientContext var1, RollbackRequest var2) throws RpcException;

        public ListCollectionIdsResponse listCollectionIds(RpcClientContext var1, ListCollectionIdsRequest var2) throws RpcException;

        public void getOrListDocuments(RpcClientContext var1, GetOrListDocumentsRequest var2, RpcCallback<GetOrListDocumentsResponse> var3);

        public void getDocument(RpcClientContext var1, GetDocumentRequest var2, RpcCallback<Document> var3);

        public void listDocuments(RpcClientContext var1, ListDocumentsRequest var2, RpcCallback<ListDocumentsResponse> var3);

        public void createDocument(RpcClientContext var1, CreateDocumentRequest var2, RpcCallback<Document> var3);

        public void updateDocument(RpcClientContext var1, UpdateDocumentRequest var2, RpcCallback<Document> var3);

        public void deleteDocument(RpcClientContext var1, DeleteDocumentRequest var2, RpcCallback<Empty> var3);

        public void beginTransaction(RpcClientContext var1, BeginTransactionRequest var2, RpcCallback<BeginTransactionResponse> var3);

        public void commit(RpcClientContext var1, CommitRequest var2, RpcCallback<CommitResponse> var3);

        public void rollback(RpcClientContext var1, RollbackRequest var2, RpcCallback<Empty> var3);

        public void listCollectionIds(RpcClientContext var1, ListCollectionIdsRequest var2, RpcCallback<ListCollectionIdsResponse> var3);

        public RpcClientStreamContext<BatchGetDocumentsRequest, BatchGetDocumentsResponse> createBatchGetDocuments();

        public RpcClientStreamContext<RunQueryRequest, RunQueryResponse> createRunQuery();

        public RpcClientStreamContext<WriteRequest, WriteResponse> createWrite();

        public RpcClientStreamContext<ListenRequest, ListenResponse> createListen();
    }

    public static enum Streams {
        BatchGetDocuments,
        RunQuery,
        Write,
        Listen;

    }

    public static enum Method {
        GetOrListDocuments,
        GetDocument,
        ListDocuments,
        CreateDocument,
        UpdateDocument,
        DeleteDocument,
        BeginTransaction,
        Commit,
        Rollback,
        ListCollectionIds;

    }
}

