/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.StringUtil;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.impl.IdentifierFactories;
import com.ibm.icu.lang.UCharacter;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BidiUtils {
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    private static final Pattern URL_START_PATTERN = Pattern.compile("https?://");
    private static final Pattern TEXT_BRACKET_GUARD_PATTERN = Pattern.compile("(\\(.*?\\)+)|(\\[.*?\\]+)|(\\{.*?\\}+)|(<.*?>+)");
    private static final Pattern OPEN_ELEMENT_PATTERN = Pattern.compile("<\\w+");
    private static final Pattern DIMENSIONS_PATTERN = Pattern.compile(":\\s*([-+]?(?:\\d*\\.)?\\d+(?:%|\\w*))\\s+([-+]?(?:\\d*\\.)?\\d+(?:%|\\w*))\\s+([-+]?(?:\\d*\\.)?\\d+(?:%|\\w*))\\s+([-+]?(?:\\d*\\.)?\\d+(?:%|\\w*))");
    private static final String PREV = "([^#\\.\\w](bottom|top)?)";
    private static final Pattern LEFT_PATTERN = Pattern.compile("([^#\\.\\w](bottom|top)?)left", 2);
    private static final Pattern RIGHT_PATTERN = Pattern.compile("([^#\\.\\w](bottom|top)?)right", 2);
    private static final Pattern PERCENT_SIGNS_PATTERN = Pattern.compile("%%%%");
    private static final Pattern DOUBLE_QUOTE_SUBSTITUTE_PATTERN = Pattern.compile("([\u0591-\u05f2])\"");
    private static final Pattern SINGLE_QUOTE_SUBSTITUTE_PATTERN = Pattern.compile("([\u0591-\u05f2])'");
    private static final Pattern BIDI_HTML_PATTERN = Pattern.compile("^[^<]*<[^>]+(dir\\s*=\\s*['\"]?(ltr|rtl)\\W|style\\s*=\\s*['\"]?[^'\"]*direction\\s*:\\s*(ltr|rtl)).*", 32);

    private BidiUtils() {
    }

    public static Dir languageDir(String languageCodeString) throws LanguageCode.IllFormedLanguageCode, LanguageCode.InvalidLanguageCode {
        return BidiUtils.isRtlLanguage(languageCodeString) ? Dir.RTL : Dir.LTR;
    }

    public static Dir languageDir(LanguageCode languageCode) {
        return BidiUtils.isRtlLanguage(languageCode) ? Dir.RTL : Dir.LTR;
    }

    public static boolean isRtlLanguage(String languageCodeString) throws LanguageCode.IllFormedLanguageCode, LanguageCode.InvalidLanguageCode {
        return IdentifierFactories.getLanguageInfo().isRightToLeftLanguage(LanguageCode.forString(languageCodeString));
    }

    public static boolean isRtlLanguage(LanguageCode languageCode) {
        return IdentifierFactories.getLanguageInfo().isRightToLeftLanguage(languageCode);
    }

    public static boolean isRtlLanguage(Locale locale) {
        return BidiUtils.isRtlLanguage(JavaLocaleConverter.CONVERTER.fromOther(locale));
    }

    public static boolean hasAnyLtr(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).hasAnyLtr(false);
    }

    public static boolean hasAnyLtr(String str) {
        return BidiUtils.hasAnyLtr(str, false);
    }

    public static boolean hasAnyRtl(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).hasAnyRtl(false);
    }

    public static boolean hasAnyRtl(String str) {
        return BidiUtils.hasAnyRtl(str, false);
    }

    @Deprecated
    public static boolean hasRtlChar(String str) {
        return BidiUtils.hasAnyRtl(str);
    }

    public static Dir getUnicodeDir(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).getUnicodeDir();
    }

    public static Dir getUnicodeDir(String str) {
        return BidiUtils.getUnicodeDir(str, false);
    }

    public static boolean isNeutralText(String str) {
        return URL_START_PATTERN.matcher(str).lookingAt() || BidiUtils.getUnicodeDir(str) == Dir.NEUTRAL;
    }

    public static Dir getExitDir(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).getExitDir();
    }

    public static Dir getExitDir(String str) {
        return BidiUtils.getExitDir(str, false);
    }

    public static Dir getEntryDir(String str, boolean isHtml, Dir europeanNumberDir) {
        return new DirectionalityEstimator(str, isHtml).getEntryDir(europeanNumberDir);
    }

    public static Dir getEntryDir(String str, boolean isHtml) {
        return BidiUtils.getEntryDir(str, isHtml, Dir.NEUTRAL);
    }

    public static Dir getEntryDir(String str) {
        return BidiUtils.getEntryDir(str, false);
    }

    public static String guardBracketInText(String str, boolean isRtlContext) {
        if (isRtlContext) {
            return TEXT_BRACKET_GUARD_PATTERN.matcher(str).replaceAll("\u200f$0\u200f");
        }
        return TEXT_BRACKET_GUARD_PATTERN.matcher(str).replaceAll("\u200e$0\u200e");
    }

    public static String guardBracketInText(String str) {
        return BidiUtils.guardBracketInText(str, BidiUtils.hasAnyRtl(str));
    }

    public static String enforceRtlInHtml(String html) {
        if (html.charAt(0) == '<') {
            return OPEN_ELEMENT_PATTERN.matcher(html).replaceFirst("$0 dir=rtl");
        }
        return new StringBuilder(22 + String.valueOf(html).length()).append("\n<span dir=rtl>").append(html).append("</span>").toString();
    }

    public static String enforceRtlInText(String text) {
        return new StringBuilder(2 + String.valueOf(text).length()).append('\u200f').append(text).append('\u200f').toString();
    }

    public static String enforceLtrInHtml(String html) {
        if (html.charAt(0) == '<') {
            return OPEN_ELEMENT_PATTERN.matcher(html).replaceFirst("$0 dir=ltr");
        }
        return new StringBuilder(22 + String.valueOf(html).length()).append("\n<span dir=ltr>").append(html).append("</span>").toString();
    }

    public static String enforceLtrInText(String text) {
        return new StringBuilder(2 + String.valueOf(text).length()).append('\u200e').append(text).append('\u200e').toString();
    }

    public static String mirrorCss(String cssStr) {
        cssStr = DIMENSIONS_PATTERN.matcher(cssStr).replaceAll(":$1 $4 $3 $2");
        cssStr = LEFT_PATTERN.matcher(cssStr).replaceAll("$1%%%%");
        cssStr = RIGHT_PATTERN.matcher(cssStr).replaceAll("$1left");
        cssStr = PERCENT_SIGNS_PATTERN.matcher(cssStr).replaceAll(RIGHT);
        return cssStr;
    }

    public static String normalizeHebrewQuote(String str) {
        str = DOUBLE_QUOTE_SUBSTITUTE_PATTERN.matcher(str).replaceAll("$1\u05f4");
        str = SINGLE_QUOTE_SUBSTITUTE_PATTERN.matcher(str).replaceAll("$1\u05f3");
        return str;
    }

    public static Dir estimateDirection(String str) {
        return BidiUtils.estimateDirection(str, false);
    }

    public static Dir estimateDirection(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).estimateDirectionByWordCount();
    }

    public static boolean detectRtlDirectionality(String str, boolean isHtml) {
        return BidiUtils.estimateDirection(str, isHtml) == Dir.RTL;
    }

    public static boolean detectRtlDirectionality(String str) {
        return BidiUtils.estimateDirection(str) == Dir.RTL;
    }

    public static String bidifyHtml(String html, @Nullable String defaultDir) {
        if (!BIDI_HTML_PATTERN.matcher(html).matches()) {
            String dir;
            String text = StringUtil.stripHtmlTags(html);
            String string = dir = BidiUtils.detectRtlDirectionality(text = StringUtil.unescapeHTML(text)) ? "rtl" : "ltr";
            if (!dir.equals(defaultDir)) {
                String string2 = html;
                html = new StringBuilder(18 + String.valueOf(dir).length() + String.valueOf(string2).length()).append("<div dir='").append(dir).append("'>").append(string2).append("</div>").toString();
            }
        }
        return html;
    }

    public static String bidifyHtml(String html) {
        return BidiUtils.bidifyHtml(html, null);
    }

    public static boolean areBidiControlCharsValid(String str, boolean allowOverrides) {
        return new DirectionalityEstimator(str, false).areBidiControlCharsValid(allowOverrides);
    }

    public static String normalizeBidiControlChars(String text) {
        int mask = 8232;
        StringBuilder result = null;
        int charIndex = 0;
        int rangeStart = 0;
        int embeddingLevel = 0;
        block4: for (charIndex = 0; charIndex < text.length(); ++charIndex) {
            char lastChar = text.charAt(charIndex);
            if ((lastChar & 0x2028) == 0) continue;
            switch (lastChar) {
                case '\u202a': 
                case '\u202b': 
                case '\u202d': 
                case '\u202e': {
                    ++embeddingLevel;
                    continue block4;
                }
                case '\u202c': {
                    if (embeddingLevel > 0) {
                        --embeddingLevel;
                        continue block4;
                    }
                    if (result == null) {
                        result = new StringBuilder(text.length());
                    }
                    result.append(text, rangeStart, charIndex);
                    rangeStart = charIndex + 1;
                    continue block4;
                }
            }
        }
        if (rangeStart == 0 && embeddingLevel == 0) {
            return text;
        }
        if (result == null) {
            result = new StringBuilder(text);
        } else {
            result.append(text, rangeStart, charIndex);
        }
        while (embeddingLevel-- > 0) {
            result.append('\u202c');
        }
        return result.toString();
    }

    @VisibleForTesting
    static class DirectionalityEstimator {
        private static final int DIR_TYPE_CACHE_SIZE = 1792;
        private static final byte[] DIR_TYPE_CACHE = new byte[1792];
        private static final double RTL_THRESHOLD = 0.4;
        private final String text;
        private final boolean isHtml;
        private final int length;
        private int charIndex;
        private char lastChar;
        private int ltrWordCount;
        private int rtlWordCount;
        private int urlWordCount;
        private int enWordCount;
        private int signedEnWordCount;
        private int plusAnWordCount;
        private int minusAnWordCount;
        private int wordType;

        DirectionalityEstimator(String text, boolean isHtml) {
            this.text = text;
            this.isHtml = isHtml;
            this.length = text.length();
        }

        boolean hasAnyLtr(boolean countEmbedding) {
            this.charIndex = 0;
            int embeddingLevel = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        if (embeddingLevel != 0) break;
                        return true;
                    }
                    case 11: 
                    case 12: {
                        if (!countEmbedding || embeddingLevel++ != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                        break;
                    }
                    case 16: {
                        if (!countEmbedding) break;
                        --embeddingLevel;
                    }
                }
            }
            return false;
        }

        boolean hasAnyRtl(boolean countEmbedding) {
            this.charIndex = 0;
            int embeddingLevel = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 13: {
                        if (embeddingLevel != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding || embeddingLevel++ != 0) break;
                        return true;
                    }
                    case 11: 
                    case 12: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                        break;
                    }
                    case 16: {
                        if (!countEmbedding) break;
                        --embeddingLevel;
                    }
                }
            }
            return false;
        }

        Dir getUnicodeDir() {
            this.charIndex = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        return Dir.LTR;
                    }
                    case 1: 
                    case 13: {
                        return Dir.RTL;
                    }
                }
            }
            return Dir.NEUTRAL;
        }

        Dir getEntryDir(Dir europeanNumberDir) {
            Preconditions.checkArgument(europeanNumberDir != null);
            this.charIndex = 0;
            int embeddingLevel = 0;
            Dir embeddingLevelDir = null;
            int firstNonEmptyEmbeddingLevel = 0;
            block14: while (this.charIndex < this.length && firstNonEmptyEmbeddingLevel == 0) {
                switch (this.dirTypeForward()) {
                    case 11: 
                    case 12: {
                        ++embeddingLevel;
                        embeddingLevelDir = Dir.LTR;
                        continue block14;
                    }
                    case 14: 
                    case 15: {
                        ++embeddingLevel;
                        embeddingLevelDir = Dir.RTL;
                        continue block14;
                    }
                    case 16: {
                        --embeddingLevel;
                        embeddingLevelDir = null;
                        continue block14;
                    }
                    case 18: {
                        continue block14;
                    }
                    case 0: {
                        if (embeddingLevel == 0) {
                            return Dir.LTR;
                        }
                        firstNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block14;
                    }
                    case 1: 
                    case 5: 
                    case 13: {
                        if (embeddingLevel == 0) {
                            return Dir.RTL;
                        }
                        firstNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block14;
                    }
                    case 2: {
                        if (europeanNumberDir == Dir.NEUTRAL || embeddingLevel != 0) break;
                        return europeanNumberDir;
                    }
                }
                firstNonEmptyEmbeddingLevel = embeddingLevel;
            }
            if (firstNonEmptyEmbeddingLevel == 0) {
                return Dir.NEUTRAL;
            }
            if (embeddingLevelDir != null) {
                return embeddingLevelDir;
            }
            while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    case 11: 
                    case 12: {
                        if (firstNonEmptyEmbeddingLevel == embeddingLevel) {
                            return Dir.LTR;
                        }
                        --embeddingLevel;
                        break;
                    }
                    case 14: 
                    case 15: {
                        if (firstNonEmptyEmbeddingLevel == embeddingLevel) {
                            return Dir.RTL;
                        }
                        --embeddingLevel;
                        break;
                    }
                    case 16: {
                        ++embeddingLevel;
                    }
                }
            }
            return Dir.NEUTRAL;
        }

        Dir getExitDir() {
            this.charIndex = this.length;
            int embeddingLevel = 0;
            int lastNonEmptyEmbeddingLevel = 0;
            block8: while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    case 0: {
                        if (embeddingLevel == 0) {
                            return Dir.LTR;
                        }
                        if (lastNonEmptyEmbeddingLevel != 0) continue block8;
                        lastNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block8;
                    }
                    case 11: 
                    case 12: {
                        if (lastNonEmptyEmbeddingLevel == embeddingLevel) {
                            return Dir.LTR;
                        }
                        --embeddingLevel;
                        continue block8;
                    }
                    case 1: 
                    case 5: 
                    case 13: {
                        if (embeddingLevel == 0) {
                            return Dir.RTL;
                        }
                        if (lastNonEmptyEmbeddingLevel != 0) continue block8;
                        lastNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block8;
                    }
                    case 14: 
                    case 15: {
                        if (lastNonEmptyEmbeddingLevel == embeddingLevel) {
                            return Dir.RTL;
                        }
                        --embeddingLevel;
                        continue block8;
                    }
                    case 16: {
                        ++embeddingLevel;
                        continue block8;
                    }
                    case 18: {
                        continue block8;
                    }
                }
                if (lastNonEmptyEmbeddingLevel != 0) continue;
                lastNonEmptyEmbeddingLevel = embeddingLevel;
            }
            return Dir.NEUTRAL;
        }

        boolean areBidiControlCharsValid(boolean allowOverrides) {
            this.charIndex = 0;
            int embeddingLevel = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 12: 
                    case 15: {
                        if (!allowOverrides) {
                            return false;
                        }
                    }
                    case 11: 
                    case 14: {
                        ++embeddingLevel;
                        break;
                    }
                    case 16: {
                        if (--embeddingLevel >= 0) break;
                        return false;
                    }
                }
            }
            return embeddingLevel == 0;
        }

        Dir estimateDirectionByWordCount() {
            this.charIndex = 0;
            this.ltrWordCount = 0;
            this.rtlWordCount = 0;
            this.urlWordCount = 0;
            this.enWordCount = 0;
            this.signedEnWordCount = 0;
            this.plusAnWordCount = 0;
            this.minusAnWordCount = 0;
            int embedLevel = 0;
            this.wordType = 0;
            while (this.charIndex < this.length) {
                byte dirType = this.dirTypeForward();
                if (dirType == 0) {
                    this.processStrong(false);
                    continue;
                }
                block0 : switch (dirType) {
                    case 1: 
                    case 13: {
                        this.processStrong(true);
                        break;
                    }
                    case 2: {
                        this.processEuropeanDigit();
                        break;
                    }
                    case 5: {
                        this.processArabicDigit();
                        break;
                    }
                    case 3: {
                        if (this.wordType >= 8) break;
                        if (this.wordType <= 2) {
                            switch (this.lastChar) {
                                case '+': 
                                case '\u207a': 
                                case '\u208a': 
                                case '\ufb29': 
                                case '\ufe62': 
                                case '\uff0b': {
                                    this.wordType = 1;
                                    break block0;
                                }
                            }
                            this.wordType = 2;
                            break;
                        }
                        this.wordType = 0;
                        break;
                    }
                    case 6: {
                        if (this.wordType >= 8 || this.wordType > 2 && this.lastChar != '/') break;
                        this.wordType = 0;
                        break;
                    }
                    case 4: 
                    case 10: {
                        if (this.wordType >= 8) break;
                        this.wordType = 0;
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (this.wordType >= 10) break;
                        this.wordType = 0;
                        break;
                    }
                    case 7: {
                        embedLevel = 0;
                        this.wordType = 0;
                        break;
                    }
                    case 12: {
                        this.processStrong(false);
                    }
                    case 11: {
                        if (embedLevel++ != 0) break;
                        this.wordType = 10;
                        break;
                    }
                    case 15: {
                        this.processStrong(true);
                    }
                    case 14: {
                        if (embedLevel++ != 0) break;
                        this.wordType = 10;
                        break;
                    }
                    case 16: {
                        if (--embedLevel != 0) break;
                        this.wordType = 0;
                        break;
                    }
                }
            }
            return this.compareCounts();
        }

        Dir compareCounts() {
            if ((double)this.rtlWordCount > (double)(this.ltrWordCount + this.rtlWordCount) * 0.4) {
                return Dir.RTL;
            }
            if (this.ltrWordCount + this.urlWordCount + this.signedEnWordCount > 0 || this.enWordCount > 1) {
                return Dir.LTR;
            }
            if (this.minusAnWordCount > 0) {
                return Dir.RTL;
            }
            if (this.plusAnWordCount > 0) {
                return Dir.LTR;
            }
            return Dir.NEUTRAL;
        }

        private void processStrong(boolean isRtl) {
            if (this.wordType >= 8) {
                return;
            }
            switch (this.wordType) {
                case 0: {
                    if (isRtl || this.lastChar != 'h' || !this.matchForward("ttp://", true) && !this.matchForward("ttps://", true)) break;
                    this.wordType = 9;
                    ++this.urlWordCount;
                    return;
                }
                case 5: {
                    --this.signedEnWordCount;
                    break;
                }
                case 6: {
                    --this.plusAnWordCount;
                    break;
                }
                case 7: {
                    --this.minusAnWordCount;
                    break;
                }
                case 3: {
                    --this.enWordCount;
                    break;
                }
            }
            this.wordType = 8;
            if (isRtl) {
                ++this.rtlWordCount;
            } else {
                ++this.ltrWordCount;
            }
        }

        private void processEuropeanDigit() {
            switch (this.wordType) {
                case 0: {
                    ++this.enWordCount;
                    this.wordType = 3;
                    break;
                }
                case 1: 
                case 2: {
                    ++this.signedEnWordCount;
                    this.wordType = 5;
                    break;
                }
            }
        }

        private void processArabicDigit() {
            switch (this.wordType) {
                case 0: {
                    this.wordType = 4;
                    break;
                }
                case 1: {
                    ++this.plusAnWordCount;
                    this.wordType = 6;
                    break;
                }
                case 2: {
                    ++this.minusAnWordCount;
                    this.wordType = 7;
                    break;
                }
            }
        }

        @VisibleForTesting
        boolean matchForward(String match, boolean advance) {
            int matchLength = match.length();
            if (matchLength > this.length - this.charIndex) {
                return false;
            }
            for (int checkIndex = 0; checkIndex < matchLength; ++checkIndex) {
                if (this.text.charAt(this.charIndex + checkIndex) == match.charAt(checkIndex)) continue;
                return false;
            }
            if (advance) {
                this.charIndex += matchLength;
            }
            return true;
        }

        private static byte getCachedDirectionality(char c) {
            return c < '\u0700' ? DIR_TYPE_CACHE[c] : UCharacter.getDirectionality((int)c);
        }

        @VisibleForTesting
        byte dirTypeForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            if (UCharacter.isHighSurrogate((char)this.lastChar)) {
                int codePoint = UCharacter.codePointAt((CharSequence)this.text, (int)this.charIndex);
                this.charIndex += UCharacter.charCount((int)codePoint);
                return UCharacter.getDirectionality((int)codePoint);
            }
            ++this.charIndex;
            byte dirType = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '<') {
                    dirType = this.skipTagForward();
                } else if (this.lastChar == '&') {
                    dirType = this.skipEntityForward();
                }
            }
            return dirType;
        }

        @VisibleForTesting
        byte dirTypeBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            if (UCharacter.isLowSurrogate((char)this.lastChar)) {
                int codePoint = UCharacter.codePointBefore((CharSequence)this.text, (int)this.charIndex);
                this.charIndex -= UCharacter.charCount((int)codePoint);
                return UCharacter.getDirectionality((int)codePoint);
            }
            --this.charIndex;
            byte dirType = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '>') {
                    dirType = this.skipTagBackward();
                } else if (this.lastChar == ';') {
                    dirType = this.skipEntityBackward();
                }
            }
            return dirType;
        }

        private byte skipTagForward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex < this.length) {
                this.lastChar = this.text.charAt(this.charIndex++);
                if (this.lastChar == '>') {
                    return 18;
                }
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char quote = this.lastChar;
                while (this.charIndex < this.length && (this.lastChar = this.text.charAt(this.charIndex++)) != quote) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)60;
            return 10;
        }

        private byte skipTagBackward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex > 0) {
                this.lastChar = this.text.charAt(--this.charIndex);
                if (this.lastChar == '<') {
                    return 18;
                }
                if (this.lastChar == '>') break;
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char quote = this.lastChar;
                while (this.charIndex > 0 && (this.lastChar = this.text.charAt(--this.charIndex)) != quote) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)62;
            return 10;
        }

        private byte skipEntityForward() {
            while (this.charIndex < this.length && (this.lastChar = this.text.charAt(this.charIndex++)) != ';') {
            }
            return 9;
        }

        private byte skipEntityBackward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex > 0) {
                this.lastChar = this.text.charAt(--this.charIndex);
                if (this.lastChar == '&') {
                    return 9;
                }
                if (this.lastChar != ';') continue;
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)59;
            return 10;
        }

        static {
            for (int i = 0; i < 1792; ++i) {
                DirectionalityEstimator.DIR_TYPE_CACHE[i] = UCharacter.getDirectionality((int)i);
            }
        }

        private static class WordType {
            public static final int NEUTRAL = 0;
            public static final int PLUS = 1;
            public static final int MINUS = 2;
            public static final int EN = 3;
            public static final int AN = 4;
            public static final int SIGNED_EN = 5;
            public static final int PLUS_AN = 6;
            public static final int MINUS_AN = 7;
            public static final int STRONG = 8;
            public static final int URL = 9;
            public static final int EMBEDDED = 10;

            private WordType() {
            }
        }
    }

    public static final class Format {
        public static final char LRE = '\u202a';
        public static final char RLE = '\u202b';
        public static final char PDF = '\u202c';
        public static final char LRO = '\u202d';
        public static final char RLO = '\u202e';
        public static final char LRM = '\u200e';
        public static final char RLM = '\u200f';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }

    public static enum Dir {
        LTR(1),
        RTL(-1),
        NEUTRAL(0);

        public final int ord;

        private Dir(int ord) {
            this.ord = ord;
        }

        public boolean isOppositeTo(Dir dir) {
            return this.ord * dir.ord < 0;
        }
    }
}

