/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.identifiers.RegionCode;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public final class CharacterSets {
    private static final Map<String, BitSet> REGION_BIT_SETS = new HashMap<String, BitSet>();
    private static final BitSet ASCII = new BitSet();
    private static final BitSet NUMBERS;
    private static final BitSet ENGLISH_ALPHABET;
    private static final BitSet ISO_LATIN_1;
    private static final BitSet RU_CYRILLIC;
    private static final BitSet CHINESE;
    private static final BitSet KOREAN;
    private static final BitSet UA_CYRILLIC;

    private CharacterSets() {
    }

    public static BitSet getNumbersBitSet() {
        return (BitSet)NUMBERS.clone();
    }

    public static BitSet getEnglishAlphabetBitSet() {
        return (BitSet)ENGLISH_ALPHABET.clone();
    }

    public static BitSet getAsciiBitSet() {
        return (BitSet)ASCII.clone();
    }

    public static BitSet getRegionBitSet(String regionCode) {
        if (regionCode == null) {
            return null;
        }
        BitSet bitSet = REGION_BIT_SETS.get(regionCode);
        if (bitSet != null) {
            return (BitSet)bitSet.clone();
        }
        return null;
    }

    public static BitSet getRegionBitSet(RegionCode regionCode) {
        if (regionCode == null) {
            return null;
        }
        return CharacterSets.getRegionBitSet(regionCode.toString());
    }

    public static BitSet toBitSet(CharSequence string) {
        BitSet bitSet = new BitSet();
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            bitSet.set(string.charAt(i));
        }
        return bitSet;
    }

    static {
        ASCII.set(32, 127);
        NUMBERS = new BitSet();
        NUMBERS.set(48, 58);
        ENGLISH_ALPHABET = new BitSet();
        ENGLISH_ALPHABET.set(97, 123);
        ENGLISH_ALPHABET.set(65, 91);
        ISO_LATIN_1 = new BitSet();
        ISO_LATIN_1.set(32, 256);
        ISO_LATIN_1.clear(127, 160);
        REGION_BIT_SETS.put(RegionCode.US.toString(), ISO_LATIN_1);
        RU_CYRILLIC = new BitSet();
        RU_CYRILLIC.set(1040, 1104);
        RU_CYRILLIC.set(1025);
        RU_CYRILLIC.set(1105);
        REGION_BIT_SETS.put(RegionCode.RU.toString(), RU_CYRILLIC);
        UA_CYRILLIC = new BitSet();
        UA_CYRILLIC.set(1028);
        UA_CYRILLIC.set(1030, 1032);
        UA_CYRILLIC.set(1040, 1066);
        UA_CYRILLIC.set(1068);
        UA_CYRILLIC.set(1070, 1098);
        UA_CYRILLIC.set(1100);
        UA_CYRILLIC.set(1102, 1104);
        UA_CYRILLIC.set(1108);
        UA_CYRILLIC.set(1110, 1112);
        UA_CYRILLIC.set(1168, 1170);
        REGION_BIT_SETS.put(RegionCode.UA.toString(), UA_CYRILLIC);
        CHINESE = new BitSet();
        CHINESE.set(19968, 40870);
        CHINESE.set(63744, 64046);
        REGION_BIT_SETS.put(RegionCode.CN.toString(), CHINESE);
        KOREAN = new BitSet();
        KOREAN.set(4352, 4608);
        KOREAN.set(12592, 12688);
        KOREAN.set(44032, 55204);
        REGION_BIT_SETS.put(RegionCode.KR.toString(), KOREAN);
    }
}

