/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.Sets;
import com.google.common.util.TypesafeEnum;
import java.io.UnsupportedEncodingException;
import java.util.Set;

public class Charset
extends TypesafeEnum {
    public static final Charset US_ASCII = new Charset("US-ASCII", "ASCII");
    public static final Charset BIG5 = new Charset("Big5", "Big5");
    public static final Charset GB2312 = new Charset("GB2312", "GBK");
    public static final Charset ISO_8859_1 = new Charset("ISO-8859-1", "ISO8859_1");
    public static final Charset ISO_8859_2 = new Charset("ISO-8859-2", "ISO8859_2");
    public static final Charset ISO_8859_4 = new Charset("ISO-8859-4", "ISO8859_4");
    public static final Charset ISO_8859_5 = new Charset("ISO-8859-5", "ISO8859_5");
    public static final Charset ISO_8859_6 = new Charset("ISO-8859-6", "ISO8859_6");
    public static final Charset ISO_8859_7 = new Charset("ISO-8859-7", "ISO8859_7");
    public static final Charset ISO_8859_8 = new Charset("ISO-8859-8", "ISO8859_8");
    public static final Charset ISO_8859_9 = new Charset("ISO-8859-9", "ISO8859_9");
    public static final Charset ISO_8859_11 = new Charset("ISO-8859-11", "ISO8859_11");
    public static final Charset ISO_8859_13 = new Charset("ISO-8859-13", "ISO8859_13");
    public static final Charset ISO_8859_15 = new Charset("ISO-8859-15", "ISO8859_15");
    public static final Charset ISO_2022_JP = new Charset("ISO-2022-JP", "ISO2022JP");
    public static final Charset EUC_JP = new Charset("EUC-JP", "EUC_JP");
    public static final Charset EUC_KR = new Charset("EUC-KR", "EUC_KR");
    public static final Charset SJIS = new Charset("Shift_JIS", "SJIS");
    public static final Charset UTF_8 = new Charset("UTF-8", "UTF8");
    public static final Charset UTF16_LE = new Charset("UTF-16LE", "UnicodeLittle");
    public static final Charset KOI8_R = new Charset("KOI8-R", "KOI8_R");
    public static final Charset WIN1250 = new Charset("windows-1250", "WINDOWS_1250");
    public static final Charset WIN1251 = new Charset("windows-1251", "WINDOWS_1251");
    public static final Charset WIN1252 = new Charset("windows-1252", "WINDOWS_1252");
    public static final Charset WIN1253 = new Charset("windows-1253", "WINDOWS_1253");
    public static final Charset WIN1254 = new Charset("windows-1254", "WINDOWS_1254");
    public static final Charset WIN1255 = new Charset("windows-1255", "WINDOWS_1255");
    public static final Charset WIN1256 = new Charset("windows-1256", "WINDOWS_1256");
    public static final Charset WIN1257 = new Charset("windows-1257", "WINDOWS_1257");
    public static final Charset WIN874 = new Charset("windows-874", "WINDOWS_874");
    public static final Set<String> SAFE_CHARSETS = Sets.newHashSet();
    private String javaName;
    private static final long serialVersionUID = 1L;

    private static void addSafeCharset(Charset charset) {
        SAFE_CHARSETS.add(charset.javaName.toLowerCase());
        SAFE_CHARSETS.add(charset.toString().toLowerCase());
    }

    private Charset(String name, String javaName) {
        super(name);
        this.javaName = javaName;
    }

    public String getName() {
        return this.toString();
    }

    public String getJavaName() {
        return this.javaName;
    }

    public boolean contains(String text) {
        if (text == null) {
            return true;
        }
        try {
            byte[] raw = text.getBytes(this.getName());
            String text1 = new String(raw, this.getName());
            return text1.equals(text);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public static boolean containedEntirelyByAny(Iterable<Charset> charsets, String text) {
        if (charsets == null) {
            return false;
        }
        for (Charset charset : charsets) {
            if (charset == null || !charset.contains(text)) continue;
            return true;
        }
        return false;
    }

    public static Charset valueOf(String s) {
        return (Charset)Charset.valueOf(Charset.class, (String)s);
    }

    public static boolean isCharsetSafe(String charset) {
        return SAFE_CHARSETS.contains(charset.toLowerCase());
    }

    static {
        Charset.addSafeCharset(BIG5);
        Charset.addSafeCharset(EUC_JP);
        Charset.addSafeCharset(EUC_KR);
        Charset.addSafeCharset(GB2312);
        Charset.addSafeCharset(ISO_8859_1);
        Charset.addSafeCharset(ISO_8859_11);
        Charset.addSafeCharset(ISO_8859_15);
        Charset.addSafeCharset(ISO_8859_2);
        Charset.addSafeCharset(ISO_8859_5);
        Charset.addSafeCharset(ISO_8859_6);
        Charset.addSafeCharset(ISO_8859_7);
        Charset.addSafeCharset(ISO_8859_9);
        Charset.addSafeCharset(KOI8_R);
        Charset.addSafeCharset(SJIS);
        Charset.addSafeCharset(US_ASCII);
        Charset.addSafeCharset(UTF_8);
        Charset.addSafeCharset(WIN1250);
        Charset.addSafeCharset(WIN1251);
        Charset.addSafeCharset(WIN1252);
        Charset.addSafeCharset(WIN1253);
        Charset.addSafeCharset(WIN1254);
        Charset.addSafeCharset(WIN1255);
        Charset.addSafeCharset(WIN1256);
        Charset.addSafeCharset(WIN1257);
        Charset.addSafeCharset(WIN874);
    }
}

