/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.util.TypesafeEnum;
import com.google.i18n.Localizable;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.impl.StandardRegionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class CountryInfo
extends TypesafeEnum
implements Localizable {
    private static HashMap<String, CountryInfo> domainMap = new HashMap();
    private static HashMap<String, CountryInfo> codeMap = new HashMap();
    private static List<CountryInfo> nations = new ArrayList<CountryInfo>();
    private String language;
    private List<String> domains;
    private String localizedName;
    private static final RegionInfo regionInfo = StandardRegionInfo.getInstance();
    private static final long serialVersionUID = 1L;
    public static final CountryInfo ANDORRA = new CountryInfo("AD", "ca", "google.ad", null, true);
    public static final CountryInfo UNITED_ARAB_EMIRATES = new CountryInfo("AE", "ar", "google.ae", "\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0651\u0629 \u0627\u0644\u0645\u062a\u0651\u062d\u062f\u0629", true);
    public static final CountryInfo AFGHANISTAN = new CountryInfo("AF", "fa", "google.com.af", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646", true);
    public static final CountryInfo ANTIGUA_AND_BARBUDA = new CountryInfo("AG", "en", "google.com.ag", null, true);
    public static final CountryInfo ANGUILLA = new CountryInfo("AI", "en", "google.com.ai", null, true);
    public static final CountryInfo ALBANIA = new CountryInfo("AL", "al", "google.al", "Shqip\u00ebria", true);
    public static final CountryInfo ARMENIA = new CountryInfo("AM", "hy", "google.am", "\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576", true);
    public static final CountryInfo NETHERLANDS_ANTILLES = new CountryInfo("AN", "nl", null, null, true);
    public static final CountryInfo ANGOLA = new CountryInfo("AO", "pt", "google.co.ao", null, true);
    public static final CountryInfo ANTARCTICA = new CountryInfo("AQ", "en", null, null, true);
    public static final CountryInfo ARGENTINA = new CountryInfo("AR", "es", "google.com.ar", null, true);
    public static final CountryInfo AMERICAN_SAMOA = new CountryInfo("AS", "en", "google.as", null, true);
    public static final CountryInfo AUSTRIA = new CountryInfo("AT", "de", "google.at", "\u00d6sterreich", true);
    public static final CountryInfo AUSTRALIA = new CountryInfo("AU", "en", "google.com.au", null, true);
    public static final CountryInfo ARUBA = new CountryInfo("AW", "nl", null, null, true);
    public static final CountryInfo ALAND_ISLANDS = new CountryInfo("AX", "sv", null, null, true);
    public static final CountryInfo AZERBAIJAN = new CountryInfo("AZ", "az", "google.az", "Az\u0259rbaycan", true);
    public static final CountryInfo BOSNIA_AND_HERZEGOVINA = new CountryInfo("BA", "bs", "google.ba", "Bosna i Hercegovina", true);
    public static final CountryInfo BARBADOS = new CountryInfo("BB", "en", null, null, true);
    public static final CountryInfo BANGLADESH = new CountryInfo("BD", "bn", "google.com.bd", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6", true);
    public static final CountryInfo BELGIUM = new CountryInfo("BE", "nl", "google.be", "Belgi\u00eb", true);
    public static final CountryInfo BURKINA_FASO = new CountryInfo("BF", "fr", "google.bf", null, true);
    public static final CountryInfo BULGARIA = new CountryInfo("BG", "bg", "google.bg", "\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f", true);
    public static final CountryInfo BAHRAIN = new CountryInfo("BH", "ar", "google.com.bh", "\u0627\u0644\u0628\u062d\u0631\u064a\u0646", true);
    public static final CountryInfo BURUNDI = new CountryInfo("BI", "fr", "google.bi", "Uburundi", true);
    public static final CountryInfo BENIN = new CountryInfo("BJ", "fr", "google.bj", "B\u00e9nin", true);
    public static final CountryInfo BERMUDA = new CountryInfo("BM", "en", null, null, true);
    public static final CountryInfo BRUNEI = new CountryInfo("BN", "ms", "google.com.bn", "Brunei Darussalam", true);
    public static final CountryInfo BOLIVIA = new CountryInfo("BO", "es", "google.com.bo", null, true);
    public static final CountryInfo BRAZIL = new CountryInfo("BR", "pt", "google.com.br", "Brasil", true);
    public static final CountryInfo BAHAMAS = new CountryInfo("BS", "en", "google.bs", null, true);
    public static final CountryInfo BHUTAN = new CountryInfo("BT", "dz", "google.bt", "\u0f60\u0f56\u0fb2\u0f74\u0f42\u0f0b\u0f61\u0f74\u0f63", true);
    public static final CountryInfo BOUVET_ISLAND = new CountryInfo("BV", "no", null, null, true);
    public static final CountryInfo BOTSWANA = new CountryInfo("BW", "en", "google.co.bw", null, true);
    public static final CountryInfo BELARUS = new CountryInfo("BY", "be", "google.by", "\u0411\u0435\u043b\u0430\u0440\u0443\u0301\u0441\u044c", true);
    public static final CountryInfo BELIZE = new CountryInfo("BZ", "en", "google.com.bz", null, true);
    public static final CountryInfo CANADA = new CountryInfo("CA", "en", "google.ca", null, true);
    public static final CountryInfo COCOS_ISLANDS = new CountryInfo("CC", "en", null, null, true);
    public static final CountryInfo CONGO_DEMOCRATIC_REPUBLIC_OF_THE = new CountryInfo("CD", "fr", "google.cd", null, true);
    public static final CountryInfo CENTRAL_AFRICAN_REPUBLIC = new CountryInfo("CF", "fr", "google.cf", "R\u00e9publique Centrafricaine", true);
    public static final CountryInfo CONGO = new CountryInfo("CG", "fr", "google.cg", null, true);
    public static final CountryInfo SWITZERLAND = new CountryInfo("CH", "de", "google.ch", "Schweiz", true);
    public static final CountryInfo C_TE_D_IVOIRE = new CountryInfo("CI", "fr", "google.ci", null, true);
    public static final CountryInfo COOK_ISLANDS = new CountryInfo("CK", "en", "google.co.ck", null, true);
    public static final CountryInfo CHILE = new CountryInfo("CL", "es", "google.cl", null, true);
    public static final CountryInfo CAMEROON = new CountryInfo("CM", "fr", "google.cm", "Cameroun", true);
    public static final CountryInfo CHINA = new CountryInfo("CN", "zh", "google.cn google.com.cn", "\u4e2d\u56fd", true);
    public static final CountryInfo COLOMBIA = new CountryInfo("CO", "es", "google.com.co", null, true);
    public static final CountryInfo COSTA_RICA = new CountryInfo("CR", "es", "google.co.cr", null, true);
    public static final CountryInfo SERBIA_AND_MONTENEGRO = new CountryInfo("CS", "sr", null, "\u0421\u0440\u0431\u0438\u0458\u0430 \u0438 \u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430", true);
    public static final CountryInfo CUBA = new CountryInfo("CU", "es", "google.com.cu", null, true);
    public static final CountryInfo CAPE_VERDE = new CountryInfo("CV", "pt", "google.cv", "Cabo Verde", true);
    public static final CountryInfo CHRISTMAS_ISLAND = new CountryInfo("CX", "en", null, null, true);
    public static final CountryInfo CYPRUS = new CountryInfo("CY", "el", "google.com.cy", "\u039a\u03c5\u03c0\u03c1\u03bf\u03c2", true);
    public static final CountryInfo CZECH_REPUBLIC = new CountryInfo("CZ", "cs", "google.cz", "\u010cesko", true);
    public static final CountryInfo GERMANY = new CountryInfo("DE", "de", "google.de", "Deutschland", true);
    public static final CountryInfo DJIBOUTI = new CountryInfo("DJ", "fr", "google.dj", null, true);
    public static final CountryInfo DENMARK = new CountryInfo("DK", "da", "google.dk", "Danmark", true);
    public static final CountryInfo DOMINICA = new CountryInfo("DM", "en", "google.dm", null, true);
    public static final CountryInfo DOMINICAN_REPUBLIC = new CountryInfo("DO", "es", "google.com.do", null, true);
    public static final CountryInfo ALGERIA = new CountryInfo("DZ", "fr", "google.dz", "\u0627\u0644\u062c\u0632\u0627\u0626\u0631", true);
    public static final CountryInfo ECUADOR = new CountryInfo("EC", "es", "google.com.ec", null, true);
    public static final CountryInfo ESTONIA = new CountryInfo("EE", "et", "google.ee", "Eesti", true);
    public static final CountryInfo EGYPT = new CountryInfo("EG", "ar", "google.com.eg", "\u0645\u0635\u0631", true);
    public static final CountryInfo WESTERN_SAHARA = new CountryInfo("EH", "ar", null, "\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629", true);
    public static final CountryInfo ERITREA = new CountryInfo("ER", "ar", null, "Ertra", true);
    public static final CountryInfo SPAIN = new CountryInfo("ES", "es", "google.es", "Espa\u00f1a", true);
    public static final CountryInfo ETHIOPIA = new CountryInfo("ET", "am", "google.com.et", "Ityop'iya", true);
    public static final CountryInfo FINLAND = new CountryInfo("FI", "fi", "google.fi", "Suomi", true);
    public static final CountryInfo FIJI = new CountryInfo("FJ", "en", "google.com.fj", null, true);
    public static final CountryInfo FALKLAND_ISLANDS = new CountryInfo("FK", "en", null, null, true);
    public static final CountryInfo MICRONESIA = new CountryInfo("FM", "en", "google.fm", null, true);
    public static final CountryInfo FAROE_ISLANDS = new CountryInfo("FO", "fo", null, null, true);
    public static final CountryInfo FRANCE = new CountryInfo("FR", "fr", "google.fr", null, true);
    public static final CountryInfo GABON = new CountryInfo("GA", "fr", "google.ga", null, true);
    public static final CountryInfo UNITED_KINGDOM = new CountryInfo("GB", "en", "google.co.uk", null, true);
    public static final CountryInfo GRENADA = new CountryInfo("GD", "en", null, null, true);
    public static final CountryInfo GEORGIA = new CountryInfo("GE", "ka", "google.ge", "\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd", true);
    public static final CountryInfo FRENCH_GUIANA = new CountryInfo("GF", "fr", null, null, true);
    public static final CountryInfo GUERNSEY = new CountryInfo("GG", "en", "google.gg", null, true);
    public static final CountryInfo GHANA = new CountryInfo("GH", "en", "google.com.gh", null, true);
    public static final CountryInfo GIBRALTAR = new CountryInfo("GI", "en", "google.com.gi", null, true);
    public static final CountryInfo GREENLAND = new CountryInfo("GL", "da", "google.gl", null, true);
    public static final CountryInfo GAMBIA = new CountryInfo("GM", "en", "google.gm", null, true);
    public static final CountryInfo GUINEA = new CountryInfo("GN", "fr", null, "Guin\u00e9e", true);
    public static final CountryInfo GUADELOUPE = new CountryInfo("GP", "fr", "google.gp", null, true);
    public static final CountryInfo EQUATORIAL_GUINEA = new CountryInfo("GQ", "es", null, "Guinea Ecuatorial", true);
    public static final CountryInfo GREECE = new CountryInfo("GR", "el", "google.gr", "\u0395\u03bb\u03bb\u03ac\u03c2", true);
    public static final CountryInfo SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = new CountryInfo("GS", "en", null, null, true);
    public static final CountryInfo GUATEMALA = new CountryInfo("GT", "es", "google.com.gt", null, true);
    public static final CountryInfo GUAM = new CountryInfo("GU", "en", null, null, true);
    public static final CountryInfo GUINEA_BISSAU = new CountryInfo("GW", "pt", null, "Guin\u00e9-Bissau", true);
    public static final CountryInfo GUYANA = new CountryInfo("GY", "en", "google.gy", null, true);
    public static final CountryInfo HONG_KONG = new CountryInfo("HK", "zh", "google.com.hk google.hk", null, true);
    public static final CountryInfo HEARD_ISLAND_AND_MCDONALD_ISLANDS = new CountryInfo("HM", "en", null, null, true);
    public static final CountryInfo HONDURAS = new CountryInfo("HN", "es", "google.hn", null, true);
    public static final CountryInfo CROATIA = new CountryInfo("HR", "hr", "google.hr", "Hrvatska", true);
    public static final CountryInfo HAITI = new CountryInfo("HT", "fr", "google.ht", "Ha\u00efti", true);
    public static final CountryInfo HUNGARY = new CountryInfo("HU", "hu", "google.hu", "Magyarorsz\u00e1g", true);
    public static final CountryInfo INDONESIA = new CountryInfo("ID", "id", "google.co.id", null, true);
    public static final CountryInfo IRELAND = new CountryInfo("IE", "en", "google.ie", null, true);
    public static final CountryInfo ISRAEL = new CountryInfo("IL", "iw", "google.co.il", "\u05d9\u05e9\u05e8\u05d0\u05dc", true);
    public static final CountryInfo ISLE_OF_MAN = new CountryInfo("IM", "en", "google.im google.co.im", null, true);
    public static final CountryInfo INDIA = new CountryInfo("IN", "en", "google.co.in", null, true);
    public static final CountryInfo BRITISH_INDIAN_OCEAN_TERRITORY = new CountryInfo("IO", "en", null, null, true);
    public static final CountryInfo IRAQ = new CountryInfo("IQ", "ar", "google.iq", "\u0627\u0644\u0639\u0631\u0627\u0642", true);
    public static final CountryInfo IRAN = new CountryInfo("IR", "ir", null, "\u0627\u06cc\u0631\u0627\u0646", true);
    public static final CountryInfo ICELAND = new CountryInfo("IS", "is", "google.is", "\u00cdsland", true);
    public static final CountryInfo ITALY = new CountryInfo("IT", "it", "google.it", "Italia", true);
    public static final CountryInfo JERSEY = new CountryInfo("JE", "en", "google.co.je google.je", null, true);
    public static final CountryInfo JAMAICA = new CountryInfo("JM", "en", "google.com.jm", null, true);
    public static final CountryInfo JORDAN = new CountryInfo("JO", "ar", "google.jo", "\u0627\u0644\u0627\u0631\u062f\u0646", true);
    public static final CountryInfo JAPAN = new CountryInfo("JP", "ja", "google.co.jp", "\u65e5\u672c", true);
    public static final CountryInfo KENYA = new CountryInfo("KE", "en", "google.co.ke", null, true);
    public static final CountryInfo KYRGYZSTAN = new CountryInfo("KG", "ky", "google.kg", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d", true);
    public static final CountryInfo CAMBODIA = new CountryInfo("KH", "km", "google.com.kh", "Kampuchea", true);
    public static final CountryInfo KIRIBATI = new CountryInfo("KI", "en", "google.ki", null, true);
    public static final CountryInfo COMOROS = new CountryInfo("KM", "ar", null, "Comores", true);
    public static final CountryInfo SAINT_KITTS_AND_NEVIS = new CountryInfo("KN", "en", null, null, true);
    public static final CountryInfo NORTH_KOREA = new CountryInfo("KP", "ko", null, "\uc870\uc120", true);
    public static final CountryInfo SOUTH_KOREA = new CountryInfo("KR", "ko", "google.co.kr", "\ud55c\uad6d", true);
    public static final CountryInfo KUWAIT = new CountryInfo("KW", "ar", "google.com.kw", "\u0627\u0644\u0643\u0648\u064a\u062a", true);
    public static final CountryInfo CAYMAN_ISLANDS = new CountryInfo("KY", "en", null, null, true);
    public static final CountryInfo KAZAKHSTAN = new CountryInfo("KZ", "ru", "google.kz", "\u049a\u0430\u0437\u0430\u049b\u0441\u0442\u0430\u043d", true);
    public static final CountryInfo LAOS = new CountryInfo("LA", "lo", "google.la", "\u0ea5\u0eb2\u0ea7", true);
    public static final CountryInfo LEBANON = new CountryInfo("LB", "ar", "google.com.lb", "\u0644\u0628\u0646\u0627\u0646", true);
    public static final CountryInfo SAINT_LUCIA = new CountryInfo("LC", "en", null, null, true);
    public static final CountryInfo LIECHTENSTEIN = new CountryInfo("LI", "de", "google.li", null, true);
    public static final CountryInfo SRI_LANKA = new CountryInfo("LK", "si", "google.lk", null, true);
    public static final CountryInfo LIBERIA = new CountryInfo("LR", "en", null, null, true);
    public static final CountryInfo LESOTHO = new CountryInfo("LS", "en", "google.co.ls", null, true);
    public static final CountryInfo LITHUANIA = new CountryInfo("LT", "lt", "google.lt", "Lietuva", true);
    public static final CountryInfo LUXEMBOURG = new CountryInfo("LU", "de", "google.lu", "L\u00ebtzebuerg", true);
    public static final CountryInfo LATVIA = new CountryInfo("LV", "lv", "google.lv", "Latvija", true);
    public static final CountryInfo LIBYA = new CountryInfo("LY", "ar", "google.com.ly", "\u0644\u064a\u0628\u064a\u0627", true);
    public static final CountryInfo MOROCCO = new CountryInfo("MA", "fr", "google.co.ma", "\u0627\u0644\u0645\u063a\u0631\u0628", true);
    public static final CountryInfo MONACO = new CountryInfo("MC", "fr", null, null, true);
    public static final CountryInfo MOLDOVA = new CountryInfo("MD", "mo", "google.md", null, true);
    public static final CountryInfo MONTENEGRO = new CountryInfo("ME", "sr-ME", "google.me", "\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430", true);
    public static final CountryInfo MADAGASCAR = new CountryInfo("MG", "mg", "google.mg", "Madagasikara", true);
    public static final CountryInfo MARSHALL_ISLANDS = new CountryInfo("MH", "en", null, null, true);
    public static final CountryInfo MACEDONIA = new CountryInfo("MK", "mk", "google.mk", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430", true);
    public static final CountryInfo MALI = new CountryInfo("ML", "fr", "google.ml", null, true);
    public static final CountryInfo MYANMAR = new CountryInfo("MM", "my", "google.com.mm", "Myanmar (Burma)", true);
    public static final CountryInfo MONGOLIA = new CountryInfo("MN", "mn", "google.mn", "\u041c\u043e\u043d\u0433\u043e\u043b \u0423\u043b\u0441", true);
    public static final CountryInfo MACAO = new CountryInfo("MO", "zh", null, null, true);
    public static final CountryInfo NORTHERN_MARIANA_ISLANDS = new CountryInfo("MP", "en", null, null, true);
    public static final CountryInfo MARTINIQUE = new CountryInfo("MQ", "fr", null, null, true);
    public static final CountryInfo MAURITANIA = new CountryInfo("MR", "ar", null, "\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627", true);
    public static final CountryInfo MONTSERRAT = new CountryInfo("MS", "en", "google.ms", null, true);
    public static final CountryInfo MALTA = new CountryInfo("MT", "en", "google.com.mt", null, true);
    public static final CountryInfo MAURITIUS = new CountryInfo("MU", "en", "google.mu", null, true);
    public static final CountryInfo MALDIVES = new CountryInfo("MV", "dv", "google.mv", "\u078e\u07aa\u0796\u07ad\u0787\u07b0\u0783\u07a7 \u0794\u07a7\u0787\u07b0\u0783\u07a8\u0780\u07ab\u0789\u07b0\u0796", true);
    public static final CountryInfo MALAWI = new CountryInfo("MW", "en", "google.mw", null, true);
    public static final CountryInfo MEXICO = new CountryInfo("MX", "es", "google.com.mx", "M\u00e9xico", true);
    public static final CountryInfo MALAYSIA = new CountryInfo("MY", "en", "google.com.my", null, true);
    public static final CountryInfo MOZAMBIQUE = new CountryInfo("MZ", "pt", "google.co.mz", "Mo\u00e7ambique", true);
    public static final CountryInfo NAMIBIA = new CountryInfo("NA", "en", "google.com.na", null, true);
    public static final CountryInfo NEW_CALEDONIA = new CountryInfo("NC", "fr", null, null, true);
    public static final CountryInfo NIGER = new CountryInfo("NE", "fr", "google.ne", null, true);
    public static final CountryInfo NORFOLK_ISLAND = new CountryInfo("NF", "en", null, null, true);
    public static final CountryInfo NIGERIA = new CountryInfo("NG", "en", "google.com.ng google.ng", null, true);
    public static final CountryInfo NICARAGUA = new CountryInfo("NI", "es", "google.com.ni", null, true);
    public static final CountryInfo NETHERLANDS = new CountryInfo("NL", "nl", "google.nl", "Nederland", true);
    public static final CountryInfo NORWAY = new CountryInfo("NO", "no", "google.no", "Norge", true);
    public static final CountryInfo NEPAL = new CountryInfo("NP", "ne", "google.com.np", "\u0928\u0947\u092a\u093e\u0932", true);
    public static final CountryInfo NAURU = new CountryInfo("NR", "en", "google.nr", "Naoero", true);
    public static final CountryInfo NIUE = new CountryInfo("NU", "en", "google.nu", null, true);
    public static final CountryInfo NEW_ZEALAND = new CountryInfo("NZ", "en", "google.co.nz", null, true);
    public static final CountryInfo OMAN = new CountryInfo("OM", "ar", "google.com.om", "\u0639\u0645\u0627\u0646", true);
    public static final CountryInfo PANAMA = new CountryInfo("PA", "es", "google.com.pa", "Panam\u00e1", true);
    public static final CountryInfo PERU = new CountryInfo("PE", "es", "google.com.pe", "Per\u00fa", true);
    public static final CountryInfo FRENCH_POLYNESIA = new CountryInfo("PF", "fr", null, null, true);
    public static final CountryInfo PAPUA_NEW_GUINEA = new CountryInfo("PG", "en", "google.com.pg", null, true);
    public static final CountryInfo PHILIPPINES = new CountryInfo("PH", "tl", "google.com.ph", "Pilipinas", true);
    public static final CountryInfo PAKISTAN = new CountryInfo("PK", "en", "google.com.pk", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646", true);
    public static final CountryInfo POLAND = new CountryInfo("PL", "pl", "google.pl", "Polska", true);
    public static final CountryInfo SAINT_PIERRE_AND_MIQUELON = new CountryInfo("PM", "fr", null, null, true);
    public static final CountryInfo PITCAIRN = new CountryInfo("PN", "en", "google.pn", null, true);
    public static final CountryInfo PUERTO_RICO = new CountryInfo("PR", "es", "google.com.pr", null, true);
    public static final CountryInfo PALESTINIAN_TERRITORIES = new CountryInfo("PS", "ar", "google.ps", null, true);
    public static final CountryInfo PORTUGAL = new CountryInfo("PT", "pt", "google.pt", null, true);
    public static final CountryInfo PALAU = new CountryInfo("PW", "en", null, "Belau", true);
    public static final CountryInfo PARAGUAY = new CountryInfo("PY", "es", "google.com.py", null, true);
    public static final CountryInfo QATAR = new CountryInfo("QA", "ar", "google.com.qa", "\u0642\u0637\u0631", true);
    public static final CountryInfo REUNION = new CountryInfo("RE", "fr", null, null, true);
    public static final CountryInfo ROMANIA = new CountryInfo("RO", "ro", "google.ro", "Rom\u00e2nia", true);
    public static final CountryInfo SERBIA = new CountryInfo("RS", "sr", "google.rs", "\u0421\u0440\u0431\u0438\u0458\u0430", true);
    public static final CountryInfo RUSSIA = new CountryInfo("RU", "ru", "google.ru", "\u0420\u043e\u0441\u0441\u0438\u044f", true);
    public static final CountryInfo RWANDA = new CountryInfo("RW", "fr", "google.rw", null, true);
    public static final CountryInfo SAUDI_ARABIA = new CountryInfo("SA", "ar", "google.com.sa", "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629", true);
    public static final CountryInfo SOLOMON_ISLANDS = new CountryInfo("SB", "en", "google.com.sb", null, true);
    public static final CountryInfo SEYCHELLES = new CountryInfo("SC", "en", "google.sc", null, true);
    public static final CountryInfo SUDAN = new CountryInfo("SD", "ar", null, "\u0627\u0644\u0633\u0648\u062f\u0627\u0646", true);
    public static final CountryInfo SWEDEN = new CountryInfo("SE", "sv", "google.se", "Sverige", true);
    public static final CountryInfo SINGAPORE = new CountryInfo("SG", "en", "google.com.sg", "Singapura", true);
    public static final CountryInfo SAINT_HELENA = new CountryInfo("SH", "en", "google.sh", null, true);
    public static final CountryInfo SLOVENIA = new CountryInfo("SI", "sl", "google.si", "Slovenija", true);
    public static final CountryInfo SVALBARD_AND_JAN_MAYEN = new CountryInfo("SJ", "no", null, null, true);
    public static final CountryInfo SLOVAKIA = new CountryInfo("SK", "sk", "google.sk", "Slovensko", true);
    public static final CountryInfo SIERRA_LEONE = new CountryInfo("SL", "en", "google.com.sl", null, true);
    public static final CountryInfo SAN_MARINO = new CountryInfo("SM", "it", "google.sm", null, true);
    public static final CountryInfo SENEGAL = new CountryInfo("SN", "fr", "google.sn", "S\u00e9n\u00e9gal", true);
    public static final CountryInfo SOMALIA = new CountryInfo("SO", "so", "google.so", "Soomaaliya", true);
    public static final CountryInfo SURINAME = new CountryInfo("SR", "nl", "google.sr", null, true);
    public static final CountryInfo S_O_TOM_AND_PR_NCIPE = new CountryInfo("ST", "pt", "google.st", "S\u00e3o Tom\u00e9 and Pr\u00edncipe", true);
    public static final CountryInfo EL_SALVADOR = new CountryInfo("SV", "es", "google.com.sv", null, true);
    public static final CountryInfo SYRIA = new CountryInfo("SY", "ar", null, "\u0633\u0648\u0631\u064a\u0627", true);
    public static final CountryInfo SWAZILAND = new CountryInfo("SZ", "en", null, null, true);
    public static final CountryInfo TURKS_AND_CAICOS_ISLANDS = new CountryInfo("TC", "en", null, null, true);
    public static final CountryInfo CHAD = new CountryInfo("TD", "fr", "google.td", "Tchad", true);
    public static final CountryInfo FRENCH_SOUTHERN_TERRITORIES = new CountryInfo("TF", "fr", null, null, true);
    public static final CountryInfo TOGO = new CountryInfo("TG", "fr", "google.tg", null, true);
    public static final CountryInfo THAILAND = new CountryInfo("TH", "th", "google.co.th", "\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23\u0e44\u0e17\u0e22", true);
    public static final CountryInfo TAJIKISTAN = new CountryInfo("TJ", "tg", "google.com.tj", "\u0422\u043e\u04b7\u0438\u043a\u0438\u0441\u0442\u043e\u043d", true);
    public static final CountryInfo TOKELAU = new CountryInfo("TK", "en", "google.tk", null, true);
    public static final CountryInfo TIMOR_LESTE = new CountryInfo("TL", "pt", "google.tl", "Timor-Leste", true);
    public static final CountryInfo TURKMENISTAN = new CountryInfo("TM", "tk", "google.tm", "T\u00fcrkmenistan", true);
    public static final CountryInfo TUNISIA = new CountryInfo("TN", "ar", "google.tn google.com.tn", "\u062a\u0648\u0646\u0633", true);
    public static final CountryInfo TONGA = new CountryInfo("TO", "en", "google.to", null, true);
    public static final CountryInfo TURKEY = new CountryInfo("TR", "tr", "google.com.tr", "T\u00fcrkiye", true);
    public static final CountryInfo TRINIDAD_AND_TOBAGO = new CountryInfo("TT", "en", "google.tt", null, true);
    public static final CountryInfo TUVALU = new CountryInfo("TV", "en", null, null, true);
    public static final CountryInfo TAIWAN = new CountryInfo("TW", "zh", "google.com.tw", "\u53f0\u7063", true);
    public static final CountryInfo TANZANIA = new CountryInfo("TZ", "sw", "google.co.tz", null, true);
    public static final CountryInfo UKRAINE = new CountryInfo("UA", "uk", "google.com.ua", "\u0423\u043a\u0440\u0430\u0457\u043d\u0430", true);
    public static final CountryInfo UGANDA = new CountryInfo("UG", "en", "google.co.ug", null, true);
    public static final CountryInfo UNITED_STATES_MINOR_OUTLYING_ISLANDS = new CountryInfo("UM", "en", null, null, true);
    public static final CountryInfo UNITED_STATES = new CountryInfo("US", "en", "google.com", null, true);
    public static final CountryInfo URUGUAY = new CountryInfo("UY", "es", "google.com.uy", null, true);
    public static final CountryInfo UZBEKISTAN = new CountryInfo("UZ", "uz", "google.co.uz", "O'zbekiston", true);
    public static final CountryInfo VATICAN_CITY = new CountryInfo("VA", "it", null, "Citt\u00e0 del Vaticano", true);
    public static final CountryInfo SAINT_VINCENT_AND_THE_GRENADINES = new CountryInfo("VC", "en", "google.com.vc", null, true);
    public static final CountryInfo VENEZUELA = new CountryInfo("VE", "es", "google.co.ve", null, true);
    public static final CountryInfo VIRGIN_ISLANDS_BRITISH = new CountryInfo("VG", "en", "google.vg", null, true);
    public static final CountryInfo VIRGIN_ISLANDS_U_S_ = new CountryInfo("VI", "en", "google.co.vi", null, true);
    public static final CountryInfo VIETNAM = new CountryInfo("VN", "vi", "google.com.vn", "Vi\u1ec7t Nam", true);
    public static final CountryInfo VANUATU = new CountryInfo("VU", "en", "google.vu", null, true);
    public static final CountryInfo WALLIS_AND_FUTUNA = new CountryInfo("WF", "fr", null, null, true);
    public static final CountryInfo SAMOA = new CountryInfo("WS", "en", "google.ws", null, true);
    public static final CountryInfo YEMEN = new CountryInfo("YE", "ar", null, "\u0627\u0644\u064a\u0645\u0646", true);
    public static final CountryInfo MAYOTTE = new CountryInfo("YT", "fr", null, null, true);
    public static final CountryInfo SOUTH_AFRICA = new CountryInfo("ZA", "en", "google.co.za", null, true);
    public static final CountryInfo ZAMBIA = new CountryInfo("ZM", "en", "google.co.zm", null, true);
    public static final CountryInfo ZIMBABWE = new CountryInfo("ZW", "en", "google.co.zw", null, true);

    protected CountryInfo(String countryCode, String lang, String domains, String localizedName, boolean isCountry) {
        super(countryCode);
        this.language = lang;
        this.domains = domains == null ? new LinkedList<String>() : Lists.newArrayList(Splitter.on(' ').trimResults().omitEmptyStrings().split(domains));
        for (String domain : this.domains) {
            domainMap.put(domain, this);
        }
        this.localizedName = localizedName;
        codeMap.put(countryCode, this);
        if (isCountry) {
            nations.add(this);
        }
    }

    public String getLanguageCode() {
        return this.language;
    }

    public String getCountryCode() {
        return super.toString();
    }

    public String getDomainName() {
        if (this.domains.size() > 0) {
            return this.domains.get(0);
        }
        return null;
    }

    public List<String> getDomainNames() {
        return Collections.unmodifiableList(this.domains);
    }

    public String getDisplayName(Locale inLocale) {
        if (inLocale == null) {
            if (this.localizedName != null) {
                return this.localizedName;
            }
            inLocale = Locale.getDefault();
        }
        RegionCode region = RegionCode.forString(this.getCountryCode());
        return regionInfo.getDisplayName(region, inLocale, Locale.ENGLISH);
    }

    public Localizable getDisplayName() {
        RegionCode region = RegionCode.forString(this.getCountryCode());
        return new LocalizedCountryName(region);
    }

    @Override
    public String toString(Locale locale) {
        return this.getDisplayName(locale);
    }

    public static CountryInfo valueOf(String country) {
        return (CountryInfo)CountryInfo.valueOf(CountryInfo.class, (String)country);
    }

    public static Collection<CountryInfo> getCountries() {
        return Collections.unmodifiableCollection(nations);
    }

    public static Collection<CountryInfo> getAllCountryEntities() {
        return Collections.unmodifiableCollection(codeMap.values());
    }

    public static CountryInfo getCountryInfoForHost(String host) {
        int index = host.lastIndexOf("google.");
        if (index == 0 || index > 0 && host.charAt(index - 1) == '.') {
            String domain = host.substring(index);
            if (domain.equals("google.com")) {
                return null;
            }
            return domainMap.get(domain);
        }
        return null;
    }

    public static CountryInfo getCountryInfoForCountryCode(String code) {
        return code != null ? codeMap.get(code.toUpperCase()) : null;
    }

    public static Set<String> getAllCountryDomains() {
        return Collections.unmodifiableSet(domainMap.keySet());
    }

    public static String getLanguageCodeForHost(String host) {
        CountryInfo cinfo = CountryInfo.getCountryInfoForHost(host);
        if (cinfo != null) {
            return cinfo.getLanguageCode();
        }
        return null;
    }

    public static String getLanguageCodeForCountry(String country) {
        CountryInfo info = CountryInfo.valueOf(country);
        if (info != null) {
            return info.getLanguageCode();
        }
        return null;
    }

    private static class LocalizedCountryName
    implements Localizable {
        private final RegionCode region;

        LocalizedCountryName(RegionCode region) {
            this.region = region;
        }

        @Override
        public String toString(Locale locale) {
            return regionInfo.getDisplayName(this.region, locale, Locale.ENGLISH);
        }
    }
}

