/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.DateFormatter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateFormatterFactory {
    private final ConcurrentMap<CacheKey, DateFormatter> cache = new ConcurrentHashMap<CacheKey, DateFormatter>();
    private static DateFormatterFactory SINGLETON = new DateFormatterFactory();

    public static DateFormatterFactory getSingleton() {
        return SINGLETON;
    }

    public DateFormatter makeForDate(Style dateStyle, Locale locale, java.util.TimeZone timeZone) {
        CacheKey cacheKey = new CacheKey(this, Kind.DATE_STYLE, locale, timeZone, dateStyle, Style.NONE);
        DateFormatter df = (DateFormatter)this.cache.get(cacheKey);
        if (null == df) {
            df = new ICUWrapper(this, DateFormat.getDateInstance((int)dateStyle.getJDKStyle(), (ULocale)ULocale.forLocale((Locale)locale)), timeZone);
            this.cache.put(cacheKey, df);
        }
        return df;
    }

    public DateFormatter makeForTime(Style timeStyle, Locale locale, java.util.TimeZone timeZone) {
        CacheKey cacheKey = new CacheKey(this, Kind.TIME_STYLE, locale, timeZone, Style.NONE, timeStyle);
        DateFormatter df = (DateFormatter)this.cache.get(cacheKey);
        if (null == df) {
            df = new ICUWrapper(this, DateFormat.getTimeInstance((int)timeStyle.getJDKStyle(), (ULocale)ULocale.forLocale((Locale)locale)), timeZone);
            this.cache.put(cacheKey, df);
        }
        return df;
    }

    public DateFormatter makeForDateTime(Style dateStyle, Style timeStyle, Locale locale, java.util.TimeZone timeZone) {
        CacheKey cacheKey = new CacheKey(this, Kind.DATE_TIME_STYLE, locale, timeZone, dateStyle, timeStyle);
        DateFormatter df = (DateFormatter)this.cache.get(cacheKey);
        if (null == df) {
            df = new ICUWrapper(this, DateFormat.getDateTimeInstance((int)dateStyle.getJDKStyle(), (int)timeStyle.getJDKStyle(), (ULocale)ULocale.forLocale((Locale)locale)), timeZone);
            this.cache.put(cacheKey, df);
        }
        return df;
    }

    public DateFormatter makeForMonthDay(Locale locale, java.util.TimeZone timeZone) {
        CacheKey cacheKey = new CacheKey(this, Kind.MONTH_DAY, locale, timeZone, Style.NONE, Style.NONE);
        DateFormatter df = (DateFormatter)this.cache.get(cacheKey);
        if (null == df) {
            df = this.makeForPattern(this.getMonthDayPattern(locale), locale, timeZone);
            this.cache.put(cacheKey, df);
        }
        return df;
    }

    public DateFormatter makeForPattern(String pattern, Locale locale, java.util.TimeZone timeZone) {
        return new ICUWrapper(this, (DateFormat)new SimpleDateFormat(pattern, ULocale.forLocale((Locale)locale)), timeZone);
    }

    public String getMonthDayPattern(Locale locale) {
        return DateTimePatternGenerator.getInstance((ULocale)ULocale.forLocale((Locale)locale)).getBestPattern("MMMd");
    }

    protected DateFormatterFactory() {
    }

    private class ICUWrapper
    implements DateFormatter {
        private final DateFormat delegate;

        public ICUWrapper(DateFormatterFactory dateFormatterFactory, DateFormat delegate, java.util.TimeZone timeZone) {
            this.delegate = delegate;
            this.delegate.setTimeZone(TimeZone.getTimeZone((String)timeZone.getID()));
        }

        @Override
        public synchronized String format(Date aDate) {
            return this.delegate.format(aDate);
        }
    }

    private class CacheKey {
        private Locale locale;
        private java.util.TimeZone timeZone;
        private Style dateStyle;
        private Style timeStyle;
        private Kind kind;

        CacheKey(DateFormatterFactory dateFormatterFactory, Kind kind, Locale locale, java.util.TimeZone timeZone, Style dateStyle, Style timeStyle) {
            this.kind = kind;
            this.locale = locale;
            this.timeZone = timeZone;
            this.dateStyle = dateStyle;
            this.timeStyle = timeStyle;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey key = (CacheKey)obj;
            return this.kind == key.kind && this.dateStyle == key.dateStyle && this.timeStyle == key.timeStyle && this.locale.equals(key.locale) && this.timeZone.equals(key.timeZone);
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + this.dateStyle.hashCode();
            result = result * 31 + this.timeStyle.hashCode();
            result = result * 31 + this.kind.hashCode();
            result = result * 31 + this.locale.hashCode();
            result = result * 31 + this.timeZone.hashCode();
            return result;
        }
    }

    private static enum Kind {
        DATE_STYLE,
        TIME_STYLE,
        DATE_TIME_STYLE,
        MONTH_DAY;

    }

    public static enum Style {
        FULL(0),
        LONG(1),
        MEDIUM(2),
        SHORT(3),
        NONE(0);

        private final int jdkStyle;

        private Style(int style) {
            this.jdkStyle = style;
        }

        public int getJDKStyle() {
            return this.jdkStyle;
        }
    }
}

