/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.ImmutableMap;
import com.google.i18n.DateTimeFormatterInterface;
import com.google.i18n.Locales;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class DateTimeFormatter
implements DateTimeFormatterInterface {
    private static final ImmutableMap<DateFormat.Field, String> ALLOWED_DATE_FORMAT_FIELDS = ImmutableMap.of(DateFormat.Field.MONTH, "M", DateFormat.Field.YEAR, "Y", DateFormat.Field.DAY_OF_MONTH, "D");
    private static final ImmutableMap<DateFormat.Field, String> ALLOWED_JAPANESE_DATE_FORMAT_FIELDS = ImmutableMap.of(DateFormat.Field.MONTH, "M", DateFormat.Field.YEAR, "Y", DateFormat.Field.DAY_OF_MONTH, "D", DateFormat.Field.ERA, "");
    private static final DateFormatSymbols JAPANESE_DATE_FORMAT_SYMBOLS = new DateFormatSymbols(Locale.JAPANESE){
        private static final long serialVersionUID = 1L;

        @Override
        public String[] getShortMonths() {
            return super.getMonths();
        }
    };
    private final DateFormat[] date_formatters = new DateFormat[4];
    private final DateFormat[] local_date_formatters = new DateFormat[4];
    private final DateFormat[] time_formatters = new DateFormat[4];
    private final DateFormat[] local_time_formatters = new DateFormat[4];
    private static final int DEFAULT_DATE_FORMAT = 2;
    private static final int DEFAULT_TIME_FORMAT = 1;
    private final Locale locale;
    private final DateFormatSymbols date_format_symbols;
    private final String ymd_order;
    private final boolean isChinese;
    private final boolean isJapanese;
    private final boolean isKorean;
    private final boolean isCzech;
    private final boolean isArabic;
    private final boolean isHebrew;

    public static DateTimeFormatter getInstance(Locale locale) {
        return new DateTimeFormatter(locale);
    }

    public String getDateString(Date date) {
        return this.getDateString(date, 2, false);
    }

    public String getDateString(Date date, int style, boolean localTime) {
        if (date == null) {
            return "";
        }
        DateFormat formatter = localTime ? this.local_date_formatters[style] : this.date_formatters[style];
        return formatter.format(date);
    }

    public String getTimeString(Date date) {
        return this.getTimeString(date, 1, false);
    }

    public String getTimeString(Date date, int style, boolean localTime) {
        if (date == null) {
            return "";
        }
        DateFormat formatter = localTime ? this.local_time_formatters[style] : this.time_formatters[style];
        String timeString = formatter.format(date);
        if (style == 1) {
            boolean isDaylight = TimeZone.getDefault().inDaylightTime(date);
            String timeZone = formatter.getTimeZone().getDisplayName(isDaylight, 0, this.locale);
            if (!timeString.endsWith(timeZone)) {
                String string = String.valueOf(timeString);
                timeString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(timeZone).length()).append(string).append(" ").append(timeZone).toString();
            }
        }
        return timeString;
    }

    public String getDateTimeString(Date date, int style, boolean localTime) {
        String string = this.getDateString(date, style, localTime);
        String string2 = this.getTimeString(date, style, localTime);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
    }

    public String getDateTimeString(Date date) {
        String string = this.getDateString(date);
        String string2 = this.getTimeString(date);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
    }

    public DateFormatSymbols getDateFormatSymbols() {
        if (this.isJapanese) {
            return JAPANESE_DATE_FORMAT_SYMBOLS;
        }
        return this.date_format_symbols;
    }

    @Override
    public String getYMDOrder() {
        return this.ymd_order;
    }

    public String getMonthString(Date date, boolean abbreviate) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        return this.getMonthString(month, abbreviate);
    }

    public String getMonthString(Date date) {
        return this.getMonthString(date, false);
    }

    public String getYearString(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        return this.getYearString(year);
    }

    public String getDayOfMonthString(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        return String.valueOf(day);
    }

    public String getMonthYearString(Date date, boolean abbreviate) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        int year = c.get(1);
        return this.getMonthYearString(month, year, abbreviate);
    }

    public String getMonthYearString(Date date) {
        return this.getMonthYearString(date, false);
    }

    public String getMonthDayString(Date date, boolean abbreviate) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        int day = c.get(5);
        return this.getMonthDayString(month, day, abbreviate);
    }

    public String getMonthDayString(Date date) {
        return this.getMonthDayString(date, false);
    }

    public String getMonthYearRangeString(Date from, Date to, boolean abbreviate) {
        Calendar cFrom = Calendar.getInstance();
        Calendar cTo = Calendar.getInstance();
        cFrom.setTime(from);
        cTo.setTime(to);
        int fromMonth = cFrom.get(2);
        int fromYear = cFrom.get(1);
        int toMonth = cTo.get(2);
        int toYear = cTo.get(1);
        StringBuilder sb = new StringBuilder();
        if (fromYear == toYear) {
            if (fromMonth == toMonth) {
                sb.append(this.getMonthYearString(fromMonth, fromYear, abbreviate));
            } else {
                if (!this.isMonthYear()) {
                    sb.append(this.getYearString(fromYear));
                    sb.append(" ");
                }
                sb.append(this.getMonthString(fromMonth, abbreviate));
                sb.append(" - ");
                sb.append(this.getMonthString(toMonth, abbreviate));
                if (this.isMonthYear()) {
                    sb.append(" ");
                    sb.append(this.getYearString(fromYear));
                }
            }
        } else {
            sb.append(this.getMonthYearString(fromMonth, fromYear, abbreviate));
            sb.append(" - ");
            sb.append(this.getMonthYearString(toMonth, toYear, abbreviate));
        }
        return sb.toString();
    }

    public String getMonthYearRangeString(Date from, Date to) {
        return this.getMonthYearRangeString(from, to, false);
    }

    public String getMonthDayYearRangeString(Date from, Date to, boolean abbreviate) {
        Calendar cFrom = Calendar.getInstance();
        Calendar cTo = Calendar.getInstance();
        cFrom.setTime(from);
        cTo.setTime(to);
        int fromDay = cFrom.get(5);
        int fromMonth = cFrom.get(2);
        int fromYear = cFrom.get(1);
        int toDay = cTo.get(5);
        int toMonth = cTo.get(2);
        int toYear = cTo.get(1);
        StringBuilder sb = new StringBuilder();
        if (fromYear == toYear) {
            if (!this.isMonthYear()) {
                sb.append(this.getYearString(fromYear));
                sb.append(" ");
            }
            if (fromMonth == toMonth && fromDay == toDay) {
                sb.append(this.getMonthDayString(fromMonth, fromDay, abbreviate));
            } else {
                sb.append(this.getMonthDayString(fromMonth, fromDay, abbreviate));
                sb.append(" - ");
                sb.append(this.getMonthDayString(toMonth, toDay, abbreviate));
            }
            if (this.isMonthYear()) {
                sb.append(" ");
                sb.append(this.getYearString(fromYear));
            }
        } else {
            if (!this.isMonthYear()) {
                sb.append(this.getYearString(fromYear));
                sb.append(" ");
            }
            sb.append(this.getMonthDayString(fromMonth, fromDay, abbreviate));
            if (this.isMonthYear()) {
                sb.append(" ");
                sb.append(this.getYearString(fromYear));
            }
            sb.append(" - ");
            if (!this.isMonthYear()) {
                sb.append(this.getYearString(toYear));
                sb.append(" ");
            }
            sb.append(this.getMonthDayString(toMonth, toDay, abbreviate));
            if (this.isMonthYear()) {
                sb.append(" ");
                sb.append(this.getYearString(toYear));
            }
        }
        return sb.toString();
    }

    public String getMonthDayYearRangeString(Date from, Date to) {
        return this.getMonthDayYearRangeString(from, to, false);
    }

    private DateTimeFormatter(Locale locale) {
        this.locale = locale;
        this.isChinese = Locale.CHINESE.getLanguage().equals(locale.getLanguage());
        this.isJapanese = Locale.JAPANESE.getLanguage().equals(locale.getLanguage());
        this.isKorean = Locale.KOREAN.getLanguage().equals(locale.getLanguage());
        this.isCzech = Locales.CZECH.getLanguage().equals(locale.getLanguage());
        this.isArabic = Locales.ARABIC.getLanguage().equals(locale.getLanguage());
        this.isHebrew = Locales.HEBREW.getLanguage().equals(locale.getLanguage());
        for (int i = 0; i <= 3; ++i) {
            this.date_formatters[i] = DateFormat.getDateInstance(i, locale);
            this.local_date_formatters[i] = DateFormat.getDateInstance(i, locale);
            this.time_formatters[i] = DateFormat.getTimeInstance(i, locale);
            this.local_time_formatters[i] = DateFormat.getTimeInstance(i, locale);
        }
        this.date_format_symbols = new DateFormatSymbols(locale);
        this.ymd_order = this.determineYearMonthDateOrderAccordingToLocale2(locale);
    }

    private String determineYearMonthDateOrderAccordingToLocale2(Locale locale) {
        StringBuilder dateFieldOrderString = new StringBuilder();
        Calendar c = GregorianCalendar.getInstance();
        c.set(2000, 10, 22);
        Date date = c.getTime();
        DateFormat df = DateFormat.getDateInstance(3, locale);
        df.setCalendar(c);
        AttributedCharacterIterator characterIterator = df.formatToCharacterIterator(date);
        while (characterIterator.current() != '\uffff') {
            Set<AttributedCharacterIterator.Attribute> currentCharacterDateFields = characterIterator.getAttributes().keySet();
            this.ensureOnlyOneDateFieldForCharacterPosition(currentCharacterDateFields);
            if (currentCharacterDateFields.size() == 0) {
                this.drainCharIteratorUntilAnAttributeFound(characterIterator);
                continue;
            }
            DateFormat.Field dateField = (DateFormat.Field)currentCharacterDateFields.iterator().next();
            if (this.isJapanese) {
                this.ensureDateFormatFieldIsAllowed(ALLOWED_JAPANESE_DATE_FORMAT_FIELDS, dateField);
            } else {
                this.ensureDateFormatFieldIsAllowed(ALLOWED_DATE_FORMAT_FIELDS, dateField);
            }
            dateFieldOrderString.append(ALLOWED_DATE_FORMAT_FIELDS.get(dateField));
            this.drainCharIteratorUntilAttributeIsGone(characterIterator, dateField);
        }
        return dateFieldOrderString.toString();
    }

    private void ensureOnlyOneDateFieldForCharacterPosition(Set currentCharacterDateFields) {
        if (currentCharacterDateFields.size() > 1) {
            String string = String.valueOf(this.locale);
            throw new IllegalArgumentException(new StringBuilder(132 + String.valueOf(string).length()).append("Formatted date for Locale ").append(string).append(" assigns more than one DateFormat.Field attribute to a given character position. This should never happen.").toString());
        }
    }

    private void ensureDateFormatFieldIsAllowed(Map<DateFormat.Field, String> allowedDateFormatFieldMap, DateFormat.Field dateField) {
        if (!allowedDateFormatFieldMap.containsKey(dateField)) {
            String string = String.valueOf(dateField);
            throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(string).length()).append("Formatted date has an unexpected attribute: ").append(string).toString());
        }
    }

    private void drainCharIteratorUntilAnAttributeFound(AttributedCharacterIterator characterIterator) {
        while (characterIterator.next() != '\uffff' && characterIterator.getAttributes().size() <= 0) {
        }
    }

    private void drainCharIteratorUntilAttributeIsGone(AttributedCharacterIterator characterIterator, AttributedCharacterIterator.Attribute attribute) {
        while (characterIterator.next() != '\uffff' && characterIterator.getAttributes().containsKey(attribute)) {
        }
    }

    @Override
    public String getMonthString(int month, boolean abbreviate) {
        if (!(!abbreviate || this.isChinese || this.isJapanese || this.isKorean || this.isCzech || this.isArabic || this.isHebrew)) {
            return this.date_format_symbols.getShortMonths()[month];
        }
        if (this.isChinese) {
            String string = String.valueOf(month + 1);
            return new StringBuilder(1 + String.valueOf(string).length()).append(string).append('\u6708').toString();
        }
        return this.date_format_symbols.getMonths()[month];
    }

    public String getMonthYearString(int month, int year, boolean abbreviate) {
        StringBuilder sb = new StringBuilder();
        if (this.isMonthYear()) {
            sb.append(this.getMonthString(month, abbreviate));
            if (!this.isJapanese && !this.isChinese) {
                sb.append(' ');
            }
            sb.append(this.getYearString(year));
        } else {
            sb.append(this.getYearString(year));
            if (!this.isJapanese && !this.isChinese) {
                sb.append(' ');
            }
            sb.append(this.getMonthString(month, abbreviate));
        }
        return sb.toString();
    }

    private String getMonthDayString(int month, int day, boolean abbreviate) {
        StringBuilder sb = new StringBuilder();
        if (this.isMonthDay()) {
            sb.append(this.getMonthString(month, abbreviate));
            if (!this.isJapanese && !this.isChinese) {
                sb.append(' ');
            }
            sb.append(this.getDayString(day));
        } else {
            sb.append(this.getDayString(day));
            if (!this.isJapanese && !this.isChinese) {
                sb.append(' ');
            }
            sb.append(this.getMonthString(month, abbreviate));
        }
        return sb.toString();
    }

    @Override
    public String getYearString(int year) {
        if (this.isChinese || this.isJapanese) {
            String string = String.valueOf(year);
            return new StringBuilder(1 + String.valueOf(string).length()).append(string).append('\u5e74').toString();
        }
        if (this.isKorean) {
            String string = String.valueOf(year);
            return new StringBuilder(1 + String.valueOf(string).length()).append(string).append('\ub144').toString();
        }
        return String.valueOf(year);
    }

    @Override
    public String getDayString(int day) {
        if (this.isChinese || this.isJapanese) {
            String string = String.valueOf(day);
            return new StringBuilder(1 + String.valueOf(string).length()).append(string).append('\u65e5').toString();
        }
        if (this.isKorean) {
            String string = String.valueOf(day);
            return new StringBuilder(1 + String.valueOf(string).length()).append(string).append('\uc77c').toString();
        }
        return String.valueOf(day);
    }

    public boolean isCjk() {
        return this.isChinese || this.isJapanese || this.isKorean;
    }

    private boolean isMonthYear() {
        return this.ymd_order.indexOf(77) < this.ymd_order.indexOf(89);
    }

    private boolean isMonthDay() {
        return this.ymd_order.indexOf(77) < this.ymd_order.indexOf(68);
    }
}

