/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.money.CurrencyCode;
import com.google.i18n.MessageReference;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.ULocaleConverter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Formatter {
    protected ULocale icuLocale;
    private static final Map<CurrencyCode, String> SIMPLE_SYMBOL_MAP = Formatter.createSimpleSymbolMap();
    private static final ConcurrentMap<FormatterKey, DecimalFormat> simpleCurrencyFormatterMap = new ConcurrentHashMap<FormatterKey, DecimalFormat>();

    public Formatter(Locale locale) {
        this.icuLocale = ULocale.forLocale((Locale)locale);
    }

    public Formatter(LanguageCode language) {
        this.icuLocale = ULocaleConverter.CONVERTER.toOther(language);
    }

    public String formatMessageNamedArgs(String msg, Object ... nameValuePairs) {
        return this.formatMessageNamedArgs(msg, Formatter.mapFromNameValuePairs(nameValuePairs));
    }

    private static Map<String, Object> mapFromNameValuePairs(Object[] args) {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            argsMap.put((String)args[i], args[i + 1]);
        }
        return argsMap;
    }

    public String formatMessageNamedArgs(MessageReference msg, Object ... nameValuePairs) {
        String msgString = msg.getMessage(this.icuLocale.toLocale()).toString();
        return this.formatMessageNamedArgs(msgString, nameValuePairs);
    }

    public String formatMessageNamedArgs(String msg, Map<String, Object> argsMap) {
        StringBuffer result = new StringBuffer();
        return new MessageFormat(msg, this.icuLocale).format(argsMap, result, null).toString();
    }

    public String formatMessageNumberedArgs(String msg, Object ... args) {
        StringBuffer result = new StringBuffer();
        return new MessageFormat(msg, this.icuLocale).format(args, result, null).toString();
    }

    public String formatMessageNumberedArgs(MessageReference msg, Object ... args) {
        String msgString = msg.getMessage(this.icuLocale.toLocale()).toString();
        return this.formatMessageNumberedArgs(msgString, args);
    }

    public String getSimpleCurrencySymbol(CurrencyCode currencyCode) {
        return SIMPLE_SYMBOL_MAP.get(currencyCode);
    }

    public String formatSimplePrice(double value, CurrencyCode currencyCode) {
        DecimalFormat fmt;
        FormatterKey fmtKey = new FormatterKey(currencyCode, this.icuLocale);
        if (simpleCurrencyFormatterMap.containsKey(fmtKey)) {
            fmt = (DecimalFormat)simpleCurrencyFormatterMap.get(fmtKey);
        } else {
            fmt = (DecimalFormat)NumberFormat.getCurrencyInstance((ULocale)this.icuLocale);
            Currency currency = Currency.getInstance((String)currencyCode.toString());
            fmt.setCurrency(currency);
            String symbol = this.getSimpleCurrencySymbol(currencyCode);
            if (symbol != null) {
                DecimalFormatSymbols symbols = fmt.getDecimalFormatSymbols();
                symbols.setCurrencySymbol(symbol);
                fmt.setDecimalFormatSymbols(symbols);
            }
            simpleCurrencyFormatterMap.put(fmtKey, fmt);
        }
        return fmt.format(value);
    }

    @Deprecated
    public String formatGlobalPrice(double value, CurrencyCode currencyCode) {
        return this.formatGlobalPrice(value, currencyCode, CurrencyCodePosition.AFTER);
    }

    public String formatGlobalPrice(double value, CurrencyCode currencyCode, CurrencyCodePosition currencyCodePosition) {
        String simplePrice = this.formatSimplePrice(value, currencyCode);
        if (currencyCodePosition == CurrencyCodePosition.BEFORE) {
            String string = currencyCode.toString();
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(simplePrice).length()).append(string).append(" ").append(simplePrice).toString();
        }
        String string = currencyCode.toString();
        return new StringBuilder(1 + String.valueOf(simplePrice).length() + String.valueOf(string).length()).append(simplePrice).append(" ").append(string).toString();
    }

    private static Map<CurrencyCode, String> createSimpleSymbolMap() {
        HashMap<CurrencyCode, String> tempMap = new HashMap<CurrencyCode, String>();
        tempMap.put(CurrencyCode.AFN, "Af.");
        tempMap.put(CurrencyCode.TOP, "T$");
        tempMap.put(CurrencyCode.MGA, "Ar");
        tempMap.put(CurrencyCode.THB, "\u0e3f");
        tempMap.put(CurrencyCode.PAB, "B/.");
        tempMap.put(CurrencyCode.ETB, "Birr");
        tempMap.put(CurrencyCode.VEF, "Bs");
        tempMap.put(CurrencyCode.BOB, "Bs");
        tempMap.put(CurrencyCode.GHS, "GHS");
        tempMap.put(CurrencyCode.CRC, "\u20a1");
        tempMap.put(CurrencyCode.NIO, "C$");
        tempMap.put(CurrencyCode.GMD, "GMD");
        tempMap.put(CurrencyCode.MKD, "din");
        tempMap.put(CurrencyCode.BHD, "din");
        tempMap.put(CurrencyCode.DZD, "din");
        tempMap.put(CurrencyCode.IQD, "din");
        tempMap.put(CurrencyCode.JOD, "din");
        tempMap.put(CurrencyCode.KWD, "din");
        tempMap.put(CurrencyCode.LYD, "din");
        tempMap.put(CurrencyCode.RSD, "din");
        tempMap.put(CurrencyCode.TND, "din");
        tempMap.put(CurrencyCode.AED, "dh");
        tempMap.put(CurrencyCode.MAD, "dh");
        tempMap.put(CurrencyCode.STD, "Db");
        tempMap.put(CurrencyCode.BSD, "$");
        tempMap.put(CurrencyCode.FJD, "$");
        tempMap.put(CurrencyCode.GYD, "$");
        tempMap.put(CurrencyCode.KYD, "$");
        tempMap.put(CurrencyCode.LRD, "$");
        tempMap.put(CurrencyCode.SBD, "$");
        tempMap.put(CurrencyCode.SRD, "$");
        tempMap.put(CurrencyCode.AUD, "$");
        tempMap.put(CurrencyCode.BBD, "$");
        tempMap.put(CurrencyCode.BMD, "$");
        tempMap.put(CurrencyCode.BND, "$");
        tempMap.put(CurrencyCode.BZD, "$");
        tempMap.put(CurrencyCode.CAD, "$");
        tempMap.put(CurrencyCode.HKD, "$");
        tempMap.put(CurrencyCode.JMD, "$");
        tempMap.put(CurrencyCode.NAD, "$");
        tempMap.put(CurrencyCode.NZD, "$");
        tempMap.put(CurrencyCode.SGD, "$");
        tempMap.put(CurrencyCode.TTD, "$");
        tempMap.put(CurrencyCode.TWD, "NT$");
        tempMap.put(CurrencyCode.USD, "$");
        tempMap.put(CurrencyCode.XCD, "$");
        tempMap.put(CurrencyCode.VND, "\u20ab");
        tempMap.put(CurrencyCode.AMD, "Dram");
        tempMap.put(CurrencyCode.CVE, "CVE");
        tempMap.put(CurrencyCode.EUR, "\u20ac");
        tempMap.put(CurrencyCode.AWG, "Afl.");
        tempMap.put(CurrencyCode.HUF, "Ft");
        tempMap.put(CurrencyCode.BIF, "FBu");
        tempMap.put(CurrencyCode.CDF, "FrCD");
        tempMap.put(CurrencyCode.CHF, "CHF");
        tempMap.put(CurrencyCode.DJF, "Fdj");
        tempMap.put(CurrencyCode.GNF, "FG");
        tempMap.put(CurrencyCode.RWF, "RF");
        tempMap.put(CurrencyCode.XOF, "CFA");
        tempMap.put(CurrencyCode.XPF, "FCFP");
        tempMap.put(CurrencyCode.KMF, "CF");
        tempMap.put(CurrencyCode.XAF, "FCFA");
        tempMap.put(CurrencyCode.HTG, "HTG");
        tempMap.put(CurrencyCode.PYG, "Gs");
        tempMap.put(CurrencyCode.UAH, "\u20b4");
        tempMap.put(CurrencyCode.PGK, "PGK");
        tempMap.put(CurrencyCode.LAK, "\u20ad");
        tempMap.put(CurrencyCode.CZK, "K\u010d");
        tempMap.put(CurrencyCode.SEK, "kr");
        tempMap.put(CurrencyCode.ISK, "kr");
        tempMap.put(CurrencyCode.DKK, "kr");
        tempMap.put(CurrencyCode.NOK, "kr");
        tempMap.put(CurrencyCode.HRK, "kn");
        tempMap.put(CurrencyCode.MWK, "MWK");
        tempMap.put(CurrencyCode.ZMK, "ZWK");
        tempMap.put(CurrencyCode.AOA, "Kz");
        tempMap.put(CurrencyCode.MMK, "K");
        tempMap.put(CurrencyCode.GEL, "GEL");
        tempMap.put(CurrencyCode.LVL, "Ls");
        tempMap.put(CurrencyCode.ALL, "Lek");
        tempMap.put(CurrencyCode.HNL, "L");
        tempMap.put(CurrencyCode.SLL, "SLL");
        tempMap.put(CurrencyCode.MDL, "MDL");
        tempMap.put(CurrencyCode.RON, "RON");
        tempMap.put(CurrencyCode.BGN, "lev");
        tempMap.put(CurrencyCode.SZL, "SZL");
        tempMap.put(CurrencyCode.TRY, "TL");
        tempMap.put(CurrencyCode.LTL, "Lt");
        tempMap.put(CurrencyCode.LSL, "LSL");
        tempMap.put(CurrencyCode.AZN, "man.");
        tempMap.put(CurrencyCode.BAM, "KM");
        tempMap.put(CurrencyCode.MZN, "MTn");
        tempMap.put(CurrencyCode.NGN, "\u20a6");
        tempMap.put(CurrencyCode.ERN, "Nfk");
        tempMap.put(CurrencyCode.BTN, "Nu.");
        tempMap.put(CurrencyCode.MRO, "MRO");
        tempMap.put(CurrencyCode.MOP, "MOP");
        tempMap.put(CurrencyCode.CUP, "$");
        tempMap.put(CurrencyCode.CUC, "$");
        tempMap.put(CurrencyCode.ARS, "$");
        tempMap.put(CurrencyCode.CLF, "UF");
        tempMap.put(CurrencyCode.CLP, "$");
        tempMap.put(CurrencyCode.COP, "$");
        tempMap.put(CurrencyCode.DOP, "$");
        tempMap.put(CurrencyCode.MXN, "$");
        tempMap.put(CurrencyCode.PHP, "\u20b1");
        tempMap.put(CurrencyCode.UYU, "$");
        tempMap.put(CurrencyCode.FKP, "\u00a3");
        tempMap.put(CurrencyCode.GIP, "\u00a3");
        tempMap.put(CurrencyCode.SHP, "\u00a3");
        tempMap.put(CurrencyCode.EGP, "E\u00a3");
        tempMap.put(CurrencyCode.LBP, "L\u00a3");
        tempMap.put(CurrencyCode.SDG, "SDG");
        tempMap.put(CurrencyCode.SSP, "SSP");
        tempMap.put(CurrencyCode.GBP, "\u00a3");
        tempMap.put(CurrencyCode.SYP, "\u00a3");
        tempMap.put(CurrencyCode.BWP, "P");
        tempMap.put(CurrencyCode.GTQ, "Q");
        tempMap.put(CurrencyCode.ZAR, "R");
        tempMap.put(CurrencyCode.BRL, "R$");
        tempMap.put(CurrencyCode.OMR, "Rial");
        tempMap.put(CurrencyCode.QAR, "Rial");
        tempMap.put(CurrencyCode.YER, "Rial");
        tempMap.put(CurrencyCode.IRR, "Rial");
        tempMap.put(CurrencyCode.KHR, "Riel");
        tempMap.put(CurrencyCode.MYR, "RM");
        tempMap.put(CurrencyCode.SAR, "Riyal");
        tempMap.put(CurrencyCode.BYR, "BYR");
        tempMap.put(CurrencyCode.RUB, "\u0440\u0443\u0431.");
        tempMap.put(CurrencyCode.MUR, "Rs");
        tempMap.put(CurrencyCode.SCR, "SCR");
        tempMap.put(CurrencyCode.LKR, "Rs");
        tempMap.put(CurrencyCode.NPR, "Rs");
        tempMap.put(CurrencyCode.INR, "\u20b9");
        tempMap.put(CurrencyCode.PKR, "Rs");
        tempMap.put(CurrencyCode.IDR, "Rp");
        tempMap.put(CurrencyCode.ILS, "\u20aa");
        tempMap.put(CurrencyCode.KES, "Ksh");
        tempMap.put(CurrencyCode.SOS, "SOS");
        tempMap.put(CurrencyCode.TZS, "TSh");
        tempMap.put(CurrencyCode.UGX, "UGX");
        tempMap.put(CurrencyCode.PEN, "S/.");
        tempMap.put(CurrencyCode.KGS, "KGS");
        tempMap.put(CurrencyCode.UZS, "so\u02bcm");
        tempMap.put(CurrencyCode.TJS, "Som");
        tempMap.put(CurrencyCode.BDT, "\u09f3");
        tempMap.put(CurrencyCode.WST, "WST");
        tempMap.put(CurrencyCode.KZT, "\u20b8");
        tempMap.put(CurrencyCode.MNT, "\u20ae");
        tempMap.put(CurrencyCode.VUV, "VUV");
        tempMap.put(CurrencyCode.KPW, "\u20a9");
        tempMap.put(CurrencyCode.KRW, "\u20a9");
        tempMap.put(CurrencyCode.JPY, "\u00a5");
        tempMap.put(CurrencyCode.CNY, "\u00a5");
        tempMap.put(CurrencyCode.PLN, "z\u0142");
        tempMap.put(CurrencyCode.MVR, "Rf");
        tempMap.put(CurrencyCode.NLG, "NAf");
        tempMap.put(CurrencyCode.ZMW, "ZK");
        tempMap.put(CurrencyCode.ANG, "\u0192");
        tempMap.put(CurrencyCode.TMT, "TMT");
        return Collections.unmodifiableMap(tempMap);
    }

    public static enum CurrencyCodePosition {
        BEFORE,
        AFTER;

    }

    private static class FormatterKey {
        private final CurrencyCode currencyCode;
        private final ULocale locale;

        public FormatterKey(CurrencyCode currencyCode, ULocale locale) {
            this.currencyCode = currencyCode;
            this.locale = locale;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FormatterKey)) {
                return false;
            }
            FormatterKey o = (FormatterKey)other;
            return this.currencyCode.equals((Object)o.currencyCode) && this.locale.equals((Object)o.locale);
        }

        public int hashCode() {
            return this.currencyCode.hashCode() ^ this.locale.hashCode();
        }
    }
}

