/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import java.util.Arrays;

public class JapaneseUtil {
    private static final String[] KATAKANA_FULLWIDTH_TO_HALFWIDTH = new String[]{"\uff67", "\uff71", "\uff68", "\uff72", "\uff69", "\uff73", "\uff6a", "\uff74", "\uff6b", "\uff75", "\uff76", "\uff76\uff9e", "\uff77", "\uff77\uff9e", "\uff78", "\uff78\uff9e", "\uff79", "\uff79\uff9e", "\uff7a", "\uff7a\uff9e", "\uff7b", "\uff7b\uff9e", "\uff7c", "\uff7c\uff9e", "\uff7d", "\uff7d\uff9e", "\uff7e", "\uff7e\uff9e", "\uff7f", "\uff7f\uff9e", "\uff80", "\uff80\uff9e", "\uff81", "\uff81\uff9e", "\uff6f", "\uff82", "\uff82\uff9e", "\uff83", "\uff83\uff9e", "\uff84", "\uff84\uff9e", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8a\uff9e", "\uff8a\uff9f", "\uff8b", "\uff8b\uff9e", "\uff8b\uff9f", "\uff8c", "\uff8c\uff9e", "\uff8c\uff9f", "\uff8d", "\uff8d\uff9e", "\uff8d\uff9f", "\uff8e", "\uff8e\uff9e", "\uff8e\uff9f", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff6c", "\uff94", "\uff6d", "\uff95", "\uff6e", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff9c", "\uff68", "\uff6a", "\uff66", "\uff9d", "\uff69\uff9e", "\uff76", "\uff79", "\uff9c\uff9e", "\uff68\uff9e", "\uff6a\uff9e", "\uff66\uff9e", "\uff65", "\uff70"};
    private static final char[] KATAKANA_HALFWIDTH_TO_FULLWIDTH = new char[]{'\u3002', '\u300c', '\u300d', '\u3001', '\u30fb', '\u30f2', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30fc', '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa', '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3', '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd', '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e4', '\u30e6', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ef', '\u30f3', '\u309b', '\u309c'};
    private static final char[] CAN_HAS_VOICED_MARK_HALF = new char[]{'\uff73', '\uff76', '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e'};
    private static final char[] WITH_VOICED_MARK_FULL = new char[]{'\u30f4', '\u30ac', '\u30ae', '\u30b0', '\u30b2', '\u30b4', '\u30b6', '\u30b8', '\u30ba', '\u30bc', '\u30be', '\u30c0', '\u30c2', '\u30c5', '\u30c7', '\u30c9', '\u30d0', '\u30d3', '\u30d6', '\u30d9', '\u30dc'};
    private static final char[] WITH_SEMIVOICED_MARK_FULL = new char[]{'\u30d1', '\u30d4', '\u30d7', '\u30da', '\u30dd'};
    private static final char VOICEDMARK = '\uff9e';
    private static final char SEMIVOICEDMARK = '\uff9f';

    private JapaneseUtil() {
    }

    public static StringBuilder convertFullToHalf(StringBuilder dst, CharSequence src) {
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if ('\uff01' <= ch && ch <= '\uff5d') {
                dst.append((char)(ch - 65248));
                continue;
            }
            if ('\u30a1' <= ch && ch <= '\u30fc') {
                dst.append(KATAKANA_FULLWIDTH_TO_HALFWIDTH[ch - 12449]);
                continue;
            }
            if (ch == '\u3001') {
                dst.append('\uff64');
                continue;
            }
            if (ch == '\u3002') {
                dst.append('\uff61');
                continue;
            }
            if (ch == '\u300c') {
                dst.append('\uff62');
                continue;
            }
            if (ch == '\u300d') {
                dst.append('\uff63');
                continue;
            }
            if (ch == '\u3099' || ch == '\u309b') {
                dst.append('\uff9e');
                continue;
            }
            if (ch == '\u309a' || ch == '\u309c') {
                dst.append('\uff9f');
                continue;
            }
            dst.append(ch);
        }
        return dst;
    }

    public static StringBuilder convertHalfToFullKatakana(StringBuilder dst, CharSequence src) {
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if ('\uff61' <= ch && ch <= '\uff9f') {
                int idx;
                if (i + 1 < len && src.charAt(i + 1) == '\uff9e' && (idx = Arrays.binarySearch(CAN_HAS_VOICED_MARK_HALF, ch)) >= 0) {
                    dst.append(WITH_VOICED_MARK_FULL[idx]);
                    ++i;
                    continue;
                }
                if (i + 1 < len && src.charAt(i + 1) == '\uff9f' && '\uff8a' <= ch && ch <= '\uff8e') {
                    idx = ch - 65418;
                    dst.append(WITH_SEMIVOICED_MARK_FULL[idx]);
                    ++i;
                    continue;
                }
                idx = ch - 65377;
                dst.append(KATAKANA_HALFWIDTH_TO_FULLWIDTH[idx]);
                continue;
            }
            dst.append(ch);
        }
        return dst;
    }

    public static boolean HasHalfwidthKatakana(CharSequence text) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            if ('\uff61' > ch || ch > '\uff9f') continue;
            return true;
        }
        return false;
    }
}

