/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.ibm.icu.text.Collator;

public class JsSortKeyGenerator
implements Cloneable {
    @VisibleForTesting
    static final byte[] WEBSAFE_ALPHABET_ASCENDING = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private final Collator collator;
    private final ByteArrayToStringConverter converter;

    public JsSortKeyGenerator(Collator collator, EncodingMode mode) {
        Preconditions.checkNotNull(collator);
        try {
            Collator cloned = (Collator)collator.clone();
            cloned.freeze();
            this.collator = cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("com.ibm.icu.text.Collator.clone() should never fail, yet it did.", e);
        }
        switch (mode) {
            case BASE64: {
                this.converter = new ByteArrayToBase64Converter();
                break;
            }
            case PACKED_FAKE_UNICODE: {
                this.converter = new ByteArrayToPackedFakeUnicodeConverter();
                break;
            }
            case ZERO_EXTENDED_FAKE_UNICODE: {
                this.converter = new ByteArrayToZeroExtendedFakeUnicodeConverter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invlalid Encoding mode specified.");
            }
        }
    }

    public String get(String value) {
        byte[] sortkey = this.collator.getRawCollationKey(value, null).releaseBytes();
        return this.converter.convert(sortkey);
    }

    @Deprecated
    public JsSortKeyGenerator clone() {
        return this;
    }

    @VisibleForTesting
    static String convertByteArrayToPackedFakeUnicode(byte[] input) {
        StringBuilder outBuffer = new StringBuilder();
        for (int i = 0; i < input.length - 1; i += 2) {
            outBuffer.append((char)((input[i] << 8 | input[i + 1] << 24 >>> 24) & 0xFFFF));
        }
        return outBuffer.toString();
    }

    @VisibleForTesting
    static String convertByteArrayToZeroExtendedFakeUnicode(byte[] input) {
        StringBuilder outBuffer = new StringBuilder();
        for (int i = 0; i < input.length - 1; ++i) {
            outBuffer.append((char)(input[i] & 0xFF));
        }
        return outBuffer.toString();
    }

    private static class ByteArrayToZeroExtendedFakeUnicodeConverter
    extends ByteArrayToStringConverter {
        private ByteArrayToZeroExtendedFakeUnicodeConverter() {
        }

        @Override
        public String convert(byte[] input) {
            return JsSortKeyGenerator.convertByteArrayToZeroExtendedFakeUnicode(input);
        }
    }

    private static class ByteArrayToPackedFakeUnicodeConverter
    extends ByteArrayToStringConverter {
        private ByteArrayToPackedFakeUnicodeConverter() {
        }

        @Override
        public String convert(byte[] input) {
            return JsSortKeyGenerator.convertByteArrayToPackedFakeUnicode(input);
        }
    }

    private static class ByteArrayToBase64Converter
    extends ByteArrayToStringConverter {
        private static final byte PADDING_BYTE = 61;

        private ByteArrayToBase64Converter() {
        }

        @Override
        public String convert(byte[] input) {
            return ByteArrayToBase64Converter.encode(input, 0, input.length - 1);
        }

        private static String encode(byte[] source, int off, int len) {
            int outLen = source.length;
            int lenDiv3 = (len + 2) / 3;
            int len43 = lenDiv3 * 4;
            byte[] outBuff = new byte[len43];
            int d = 0;
            int e = 0;
            int len2 = len - 2;
            while (d < len2) {
                int inBuff = source[d + off] << 24 >>> 8 | source[d + 1 + off] << 24 >>> 16 | source[d + 2 + off] << 24 >>> 24;
                outBuff[e] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 18];
                outBuff[e + 1] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 12 & 0x3F];
                outBuff[e + 2] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 6 & 0x3F];
                outBuff[e + 3] = WEBSAFE_ALPHABET_ASCENDING[inBuff & 0x3F];
                d += 3;
                e += 4;
            }
            if (d < len) {
                ByteArrayToBase64Converter.encode3to4(source, d + off, len - d, outBuff, e);
            }
            while (outLen > 0 && outBuff[outLen - 1] == 61) {
                --outLen;
            }
            return new String(outBuff, 0, outLen);
        }

        private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
            int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
            switch (numSigBytes) {
                case 3: {
                    destination[destOffset] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 18];
                    destination[destOffset + 1] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = WEBSAFE_ALPHABET_ASCENDING[inBuff & 0x3F];
                    return destination;
                }
                case 2: {
                    destination[destOffset] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 18];
                    destination[destOffset + 1] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = 61;
                    return destination;
                }
                case 1: {
                    destination[destOffset] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 18];
                    destination[destOffset + 1] = WEBSAFE_ALPHABET_ASCENDING[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = 61;
                    destination[destOffset + 3] = 61;
                    return destination;
                }
            }
            return destination;
        }
    }

    private static abstract class ByteArrayToStringConverter {
        private ByteArrayToStringConverter() {
        }

        public abstract String convert(byte[] var1);
    }

    public static enum EncodingMode {
        BASE64,
        PACKED_FAKE_UNICODE,
        ZERO_EXTENDED_FAKE_UNICODE;

    }
}

